/*
 * Decompiled with CFR 0.152.
 */
package com.alonsoaliaga.alonsojoin.utils;

import com.alonsoaliaga.alonsojoin.AlonsoJoin;
import com.alonsoaliaga.alonsojoin.others.Materials;
import com.alonsoaliaga.alonsojoin.others.Sounds;
import com.alonsoaliaga.alonsojoin.utils.AlonsoUtils;
import com.alonsoaliaga.alonsojoin.utils.ProtocolLibUtils;
import com.alonsoaliaga.alonsolib.libraries.adventure.text.Component;
import com.alonsoaliaga.alonsolib.libraries.adventure.text.serializer.legacy.LegacyComponentSerializer;
import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.ProtocolManager;
import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.wrappers.EnumWrappers;
import com.comphenix.protocol.wrappers.WrappedChatComponent;
import de.tr7zw.nbtapi.NBTCompound;
import java.awt.Color;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Optional;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.clip.placeholderapi.PlaceholderAPI;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.ComponentBuilder;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.api.chat.hover.content.Content;
import net.md_5.bungee.api.chat.hover.content.Text;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.util.Vector;

public class LocalUtils {
    public static long DAY_START;
    public static long DAY_END;
    public static boolean hexColorSupport;
    public static boolean soundCategorySupport;
    public static boolean clickableTextSupport;
    public static boolean oldHoverMethod;
    public static boolean newSetUnbreakableMethod;
    public static boolean newIsUnbreakableMethod;
    public static boolean setUnbreakableSupport;
    public static boolean isUnbreakableSupport;
    public static boolean oldSendTitleMethod;
    public static boolean longInventoryTitleSupport;
    public static boolean getMaxHealthFeatureSupport;
    public static boolean setMaxHealthFeatureSupport;
    public static boolean getMaxHealthAttributeSupport;
    public static boolean setMaxHealthAttributeSupport;
    public static boolean nativeOpenBookSupport;
    public static Method METHOD_SET_UNBREAKABLE_OLD;
    public static Method METHOD_IS_UNBREAKABLE_OLD;
    public static Method METHOD_ITEM_META_SPIGOT;
    public static Method METHOD_GET_MAX_HEALTH;
    public static Method METHOD_SET_MAX_HEALTH;
    public static boolean fixColors;
    private static Map<org.bukkit.ChatColor, ColorSet<Integer, Integer, Integer>> colorMap;
    private static final Pattern PARSED_HEX_PATTERN;
    private static final Pattern PARSED_PATTERN_COLORS;
    private static final Pattern HEX_COLOR_PATTERN_TO_FIX;
    private static final Pattern HEX_COLOR_PATTERN;
    private static String placeholderHexFormat;
    private static final NavigableMap<Long, String> suffixes;

    public static org.bukkit.ChatColor fromRGB(int r, int g, int b) {
        TreeMap closest = new TreeMap();
        colorMap.forEach((color, set) -> {
            int red = Math.abs(r - (Integer)set.getRed());
            int green = Math.abs(g - (Integer)set.getGreen());
            int blue = Math.abs(b - (Integer)set.getBlue());
            closest.put(red + green + blue, color);
        });
        return (org.bukkit.ChatColor)closest.firstEntry().getValue();
    }

    public static void setFixColors(boolean newFixColors) {
        if (fixColors != newFixColors) {
            LocalUtils.logp((newFixColors ? "Enabling" : "Disabling") + " HEX color fix for 1.8 - 1.15 players.." + (newFixColors ? " (This is an experimental feature)" : ""));
        }
        fixColors = newFixColors;
    }

    public static boolean getfixColors() {
        return fixColors;
    }

    public static void setPlaceholderHexFormat(String string) {
        placeholderHexFormat = string;
    }

    public static String restoreColorNodesFromString(String string, boolean includeNativeCodes) {
        String match;
        Matcher matcher;
        if (string.length() < 2) {
            return string;
        }
        if (hexColorSupport) {
            matcher = PARSED_HEX_PATTERN.matcher(string);
            while (matcher.find()) {
                match = matcher.group(0);
                string = string.replace(match, placeholderHexFormat.replace("{COLOR}", match.substring(2).replace("\u00a7", "")));
            }
        }
        if (includeNativeCodes) {
            matcher = PARSED_PATTERN_COLORS.matcher(string);
            while (matcher.find()) {
                match = matcher.group(0);
                string = string.replace(match, match.replace("\u00a7", "&"));
            }
        }
        return string;
    }

    public static List<String> fixHexColorCodes(List<String> strings) {
        if (hexColorSupport) {
            ArrayList<String> newList = new ArrayList<String>();
            if (fixColors) {
                for (String string : strings) {
                    Matcher matcher = HEX_COLOR_PATTERN_TO_FIX.matcher(string);
                    while (matcher.find()) {
                        String match = matcher.group(0);
                        ChatColor color = ChatColor.of((String)match);
                        org.bukkit.ChatColor chatColor = LocalUtils.fromRGB(color.getColor().getRed(), color.getColor().getGreen(), color.getColor().getBlue());
                        string = string.replace(match, "&" + match.substring(0, match.length() - 1) + chatColor.getChar());
                    }
                    newList.add(string);
                }
            } else {
                for (String string : strings) {
                    Matcher matcher = HEX_COLOR_PATTERN_TO_FIX.matcher(string);
                    while (matcher.find()) {
                        String match = matcher.group(0);
                        string = string.replace(match, "&" + match);
                    }
                    newList.add(string);
                }
            }
            return newList;
        }
        return strings;
    }

    public static String fixHexColorCodes(String string) {
        block4: {
            if (!hexColorSupport) break block4;
            if (fixColors) {
                Matcher matcher = HEX_COLOR_PATTERN_TO_FIX.matcher(string);
                while (matcher.find()) {
                    String match = matcher.group(0);
                    ChatColor color = ChatColor.of((String)match);
                    org.bukkit.ChatColor chatColor = LocalUtils.fromRGB(color.getColor().getRed(), color.getColor().getGreen(), color.getColor().getBlue());
                    string = string.replace(match, "&" + match.substring(0, match.length() - 1) + chatColor.getChar());
                }
            } else {
                Matcher matcher = HEX_COLOR_PATTERN_TO_FIX.matcher(string);
                while (matcher.find()) {
                    String match = matcher.group(0);
                    string = string.replace(match, "&" + match);
                }
            }
        }
        return string;
    }

    public static String translateAlternateHexColorCodes(Character c, String string, boolean includeColors) {
        if (includeColors) {
            return LocalUtils.translateAlternateHexColorCodes(c, string);
        }
        if (string.length() < 7 || !string.contains("#")) {
            return string;
        }
        Matcher matcher = HEX_COLOR_PATTERN.matcher(string);
        if (fixColors) {
            while (matcher.find()) {
                String match = matcher.group(0);
                ChatColor color = ChatColor.of((String)match);
                org.bukkit.ChatColor chatColor = LocalUtils.fromRGB(color.getColor().getRed(), color.getColor().getGreen(), color.getColor().getBlue());
                String parsedHex = color.toString();
                string = string.replace(match, parsedHex.substring(0, parsedHex.length() - 1) + chatColor.getChar());
            }
        } else {
            while (matcher.find()) {
                String match = matcher.group(0);
                ChatColor color = ChatColor.of((String)match);
                string = string.replace(match, color.toString());
            }
        }
        return string;
    }

    public static String translateAlternateHexColorCodes(Character c, String string) {
        string = org.bukkit.ChatColor.translateAlternateColorCodes((char)c.charValue(), (String)string);
        if (string.length() < 7 || !string.contains("#")) {
            return string;
        }
        Matcher matcher = HEX_COLOR_PATTERN.matcher(string);
        if (fixColors) {
            while (matcher.find()) {
                String match = matcher.group(0);
                ChatColor color = ChatColor.of((String)match);
                org.bukkit.ChatColor chatColor = LocalUtils.fromRGB(color.getColor().getRed(), color.getColor().getGreen(), color.getColor().getBlue());
                String parsedHex = color.toString();
                string = string.replace(match, parsedHex.substring(0, parsedHex.length() - 1) + chatColor.getChar());
            }
        } else {
            while (matcher.find()) {
                String match = matcher.group(0);
                ChatColor color = ChatColor.of((String)match);
                string = string.replace(match, color.toString());
            }
        }
        return string;
    }

    public static String colorize(String string) {
        return hexColorSupport ? LocalUtils.translateAlternateHexColorCodes(Character.valueOf('&'), string) : org.bukkit.ChatColor.translateAlternateColorCodes((char)'&', (String)string);
    }

    public static List<String> colorize(List<String> strings) {
        return strings.stream().map(LocalUtils::colorize).collect(Collectors.toList());
    }

    public static void logp(String string) {
        Bukkit.getConsoleSender().sendMessage(LocalUtils.colorize(AlonsoUtils.second + "[" + "AlonsoJoin" + "] &7" + string));
    }

    public static void logd(String string) {
        Bukkit.getConsoleSender().sendMessage(LocalUtils.colorize(AlonsoUtils.second + "[" + "AlonsoJoin" + "]" + AlonsoUtils.first + "&l[Debug] &7" + string));
    }

    public static void loge(String string) {
        Bukkit.getConsoleSender().sendMessage(LocalUtils.colorize("&c[AlonsoJoin] " + string));
    }

    public static void log(String string) {
        Bukkit.getConsoleSender().sendMessage(LocalUtils.colorize(string));
    }

    public static Material findMaterial(String ... names) {
        for (String name : names) {
            try {
                return Material.valueOf((String)name.toUpperCase());
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
        }
        return Material.COBBLESTONE;
    }

    public static Sound findSound(String ... names) {
        for (String name : names) {
            try {
                return Sound.valueOf((String)name.toUpperCase(Locale.US));
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
        }
        try {
            return Sound.valueOf((String)"CLICK");
        }
        catch (IllegalArgumentException e) {
            return Sound.valueOf((String)"UI_BUTTON_CLICK");
        }
    }

    public static Sound getSound(String name) {
        try {
            return Sounds.valueOf(name.toUpperCase(Locale.US)).getSound();
        }
        catch (Exception e) {
            try {
                return Sound.valueOf((String)name.toUpperCase(Locale.US));
            }
            catch (IllegalArgumentException e2) {
                return null;
            }
        }
    }

    public static Sound getSound(String name, Sound defaultSound) {
        try {
            return Sounds.valueOf(name.toUpperCase(Locale.US)).getSound();
        }
        catch (Exception e) {
            try {
                return Sound.valueOf((String)name.toUpperCase());
            }
            catch (IllegalArgumentException e2) {
                return defaultSound;
            }
        }
    }

    public static Sound getSoundException(String name) {
        try {
            return Sounds.valueOf(name.toUpperCase(Locale.US)).getSound();
        }
        catch (Exception e) {
            return Sound.valueOf((String)name.toUpperCase(Locale.US));
        }
    }

    public static Material getMaterial(String name) {
        try {
            return Materials.valueOf(name).getMaterial();
        }
        catch (IllegalArgumentException e) {
            try {
                return Material.valueOf((String)name);
            }
            catch (IllegalArgumentException e2) {
                return null;
            }
        }
    }

    public static Material getMaterial(String name, Material defaultMaterial) {
        try {
            return Materials.valueOf(name).getMaterial();
        }
        catch (IllegalArgumentException e) {
            try {
                return Material.valueOf((String)name);
            }
            catch (IllegalArgumentException e2) {
                return defaultMaterial;
            }
        }
    }

    public static Material getMaterialException(String name) {
        try {
            return Materials.valueOf(name).getMaterial();
        }
        catch (IllegalArgumentException e) {
            return Material.valueOf((String)name);
        }
    }

    public static List<EntityType> getEntityTypes(String ... names) {
        ArrayList<EntityType> entityTypes = new ArrayList<EntityType>();
        for (String name : names) {
            try {
                entityTypes.add(EntityType.valueOf((String)name.toUpperCase(Locale.US)));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return entityTypes;
    }

    public static List<EntityType> getEntityTypes(List<String> names) {
        ArrayList<EntityType> entityTypes = new ArrayList<EntityType>();
        for (String name : names) {
            try {
                entityTypes.add(EntityType.valueOf((String)name.toUpperCase()));
            }
            catch (IllegalArgumentException ignored) {
                LocalUtils.logp("&cInvalid entity type: " + name.toUpperCase());
            }
        }
        return entityTypes;
    }

    public static String numberFormat(long value) {
        if (value == Long.MIN_VALUE) {
            return LocalUtils.numberFormat(-9223372036854775807L);
        }
        if (value < 0L) {
            return "-" + LocalUtils.numberFormat(-value);
        }
        if (value < 1000L) {
            return Long.toString(value);
        }
        Map.Entry<Long, String> e = suffixes.floorEntry(value);
        Long divideBy = e.getKey();
        String suffix = e.getValue();
        long truncated = value / (divideBy / 10L);
        boolean hasDecimal = truncated < 100L && (double)truncated / 10.0 != (double)(truncated / 10L);
        return hasDecimal ? (double)truncated / 10.0 + suffix : truncated / 10L + suffix;
    }

    public static String limitString(String text, int length) {
        if (text.length() <= length) {
            return text;
        }
        return text.substring(0, length);
    }

    public static void setUUID(NBTCompound nbtCompound, String name, UUID uuid) {
        if (AlonsoUtils.serverVersion.isOlderThan(AlonsoUtils.ServerVersion.v1_16)) {
            nbtCompound.setString(name, uuid.toString());
        } else {
            nbtCompound.setUUID(name, uuid);
        }
    }

    public static String pascalCase(String string) {
        return LocalUtils.pascalCase(string, false);
    }

    public static String pascalCase(String string, boolean fancy) {
        if (string == null) {
            return "";
        }
        if (string.length() <= 1) {
            return string.toUpperCase();
        }
        String toCase = fancy ? string.trim().replace("_", " ").replace("-", " ") : string.trim();
        ArrayList<String> list = new ArrayList<String>();
        for (String s : toCase.split(" ")) {
            if (!s.isEmpty()) {
                list.add(s.substring(0, 1).toUpperCase() + s.substring(1).toLowerCase());
                continue;
            }
            list.add("");
        }
        return String.join((CharSequence)" ", list);
    }

    public static String firstCase(String string) {
        if (string == null) {
            return "";
        }
        String toCase = string.trim();
        if (string.length() <= 1) {
            return toCase.toUpperCase();
        }
        return toCase.substring(0, 1).toUpperCase() + toCase.substring(1).toLowerCase();
    }

    public static String firstCase(String string, boolean fancy) {
        if (string == null) {
            return "";
        }
        if (!fancy) {
            return LocalUtils.firstCase(string);
        }
        String toCase = string.trim();
        if (string.length() <= 1) {
            return toCase.toUpperCase();
        }
        return (toCase.substring(0, 1).toUpperCase() + toCase.substring(1).toLowerCase()).replace("_", " ").replace("-", " ");
    }

    public static boolean isDay(long dayTime) {
        if (dayTime >= 24000L) {
            dayTime %= 24000L;
        }
        return dayTime > DAY_START || dayTime < DAY_END;
    }

    public static boolean isNight(long dayTime) {
        return !LocalUtils.isDay(dayTime);
    }

    @Nullable
    public static Location decodeLocation(String locationString) {
        if (locationString == null) {
            return null;
        }
        try {
            String[] parts = locationString.split("\\|");
            World world = Bukkit.getWorld((String)parts[0]);
            if (world == null) {
                return null;
            }
            return new Location(world, Double.parseDouble(parts[1]), Double.parseDouble(parts[2]), Double.parseDouble(parts[3]), Float.parseFloat(parts[4]), Float.parseFloat(parts[5]));
        }
        catch (Exception e) {
            return null;
        }
    }

    public static void sendProtocolActionBar(AlonsoUtils.AlonsoPlugin plugin, Player player, String message) {
        ProtocolManager protocolManager = ProtocolLibrary.getProtocolManager();
        PacketContainer chatPacket = protocolManager.createPacket(PacketType.Play.Server.CHAT);
        chatPacket.getChatComponents().write(0, (Object)WrappedChatComponent.fromText((String)message));
        try {
            if (plugin.getPluginUtils().getActionBarProtocolMethod() == 0) {
                chatPacket.getBytes().write(0, (Object)2);
            } else {
                chatPacket.getChatTypes().write(0, (Object)EnumWrappers.ChatType.GAME_INFO);
            }
            protocolManager.sendServerPacket(player, chatPacket);
        }
        catch (Exception e) {
            LocalUtils.log(String.format("&c%s[ProtocolLib] Error sending Action Bar to %s", "[AlonsoJoin] ", player.getName()));
        }
    }

    public static void sendProtocolActionBar(AlonsoUtils.AlonsoPlugin plugin, Collection<? extends Player> players, String message) {
        ProtocolManager protocolManager = ProtocolLibrary.getProtocolManager();
        PacketContainer chatPacket = protocolManager.createPacket(PacketType.Play.Server.CHAT);
        chatPacket.getChatComponents().write(0, (Object)WrappedChatComponent.fromText((String)message));
        try {
            if (plugin.getPluginUtils().getActionBarProtocolMethod() == 0) {
                chatPacket.getBytes().write(0, (Object)2);
            } else {
                chatPacket.getChatTypes().write(0, (Object)EnumWrappers.ChatType.GAME_INFO);
            }
            for (Player player : players) {
                protocolManager.sendServerPacket(player, chatPacket);
            }
        }
        catch (Exception e) {
            LocalUtils.log(String.format("&c%s[ProtocolLib] Error sending Action Bar to players.", "[AlonsoJoin] "));
        }
    }

    public static void sendBungeeActionBar(Player player, String message) {
        player.spigot().sendMessage(ChatMessageType.ACTION_BAR, TextComponent.fromLegacyText((String)message));
    }

    public static void sendActionBar(AlonsoUtils.AlonsoPlugin plugin, Player player, String message) {
        if (plugin.getPluginUtils().getActionBarType() == AlonsoUtils.ActionBarType.BUNGEE) {
            LocalUtils.sendBungeeActionBar(player, message);
        } else if (plugin.getPluginUtils().getActionBarType() == AlonsoUtils.ActionBarType.PROTOCOL) {
            LocalUtils.sendProtocolActionBar(plugin, player, message);
        } else {
            player.sendMessage(message);
        }
    }

    public static void sendActionBar(AlonsoJoin plugin, Collection<? extends Player> players, String message) {
        if (plugin.getPluginUtils().getActionBarType() == AlonsoUtils.ActionBarType.BUNGEE) {
            for (Player player : players) {
                LocalUtils.sendBungeeActionBar(player, message);
            }
        } else if (plugin.getPluginUtils().getActionBarType() == AlonsoUtils.ActionBarType.PROTOCOL) {
            LocalUtils.sendProtocolActionBar((AlonsoUtils.AlonsoPlugin)plugin, players, message);
        } else {
            for (Player player : players) {
                player.sendMessage(message);
            }
        }
    }

    @Nullable
    public static String encodeLocation(Location location) {
        if (location == null) {
            return null;
        }
        try {
            String locationString = "%s|%s|%s|%s|%s|%s";
            return String.format(locationString, location.getWorld().getName(), location.getX(), location.getY(), location.getZ(), Float.valueOf(location.getYaw()), Float.valueOf(location.getPitch()));
        }
        catch (Exception e) {
            return null;
        }
    }

    public static void send(CommandSender sender, String message) {
        sender.sendMessage(LocalUtils.colorize(message));
    }

    public static Collection<Material> getMaterials(String ... names) {
        List<String> possibleNames = Arrays.asList(names);
        return Stream.of(Material.values()).filter(material -> possibleNames.contains(material.name())).collect(Collectors.toList());
    }

    public static List<Location> getLocationsInLine(Location start, Location end) {
        Vector target = end.toVector();
        start.setDirection(target.subtract(start.toVector()));
        Vector toIncrease = start.getDirection();
        double distance = start.distance(end);
        ArrayList<Location> locations = new ArrayList<Location>();
        locations.add(start.clone());
        int i = 0;
        while ((double)i < distance) {
            Location newLoc = start.add(toIncrease);
            locations.add(newLoc.clone());
            ++i;
        }
        return locations;
    }

    public static List<Location> getLocationsInLine(Location start, Location end, double interval) {
        Vector target = end.toVector();
        start.setDirection(target.subtract(start.toVector()));
        Vector toIncrease = start.getDirection();
        double distance = start.distance(end);
        ArrayList<Location> locations = new ArrayList<Location>();
        locations.add(start.clone());
        for (double i = 0.0; i < distance; i += interval) {
            Location newLoc = start.add(toIncrease);
            locations.add(newLoc.clone());
        }
        return locations;
    }

    public static String getDuration(long milliseconds) {
        return LocalUtils.getDuration(milliseconds, false);
    }

    public static String getDuration(long milliseconds, boolean fancy) {
        long seconds = milliseconds / 1000L;
        long minutes = seconds / 60L;
        long hours = minutes / 60L;
        long days = hours / 24L;
        if (milliseconds > 86399999L) {
            return Math.abs(days) + "d " + Math.abs(hours % 24L) + "h " + Math.abs(minutes) % 60L + "m " + Math.abs(seconds) % 60L + "s";
        }
        if (milliseconds > 1439999L) {
            return Math.abs(hours % 24L) + "h " + Math.abs(minutes) % 60L + "m " + Math.abs(seconds) % 60L + "s";
        }
        if (milliseconds > 59999L || !fancy) {
            return Math.abs(minutes) % 60L + "m " + Math.abs(seconds) % 60L + "s";
        }
        long amount = Math.abs(seconds) % 60L;
        return (amount <= 0L ? 1L : amount) + "s";
    }

    public static String getWatchDuration(long milliseconds) {
        return LocalUtils.getWatchDuration(milliseconds, true);
    }

    public static String getWatchDuration(long milliseconds, boolean fancy) {
        long seconds = milliseconds / 1000L;
        long minutes = seconds / 60L;
        long hours = minutes / 60L;
        long days = hours / 24L;
        if (fancy) {
            if (milliseconds > 86399999L) {
                long day = Math.abs(days);
                long hour = Math.abs(hours % 24L);
                long min = Math.abs(minutes % 60L);
                long sec = Math.abs(seconds % 60L);
                return (day < 10L ? "0" + day : Long.valueOf(hour)) + ":" + (hour < 10L ? "0" + hour : Long.valueOf(hour)) + ":" + (min < 10L ? "0" + min : Long.valueOf(min)) + ":" + (sec < 10L ? "0" + sec : Long.valueOf(sec));
            }
            if (milliseconds > 1439999L) {
                long hour = Math.abs(hours % 24L);
                long min = Math.abs(minutes % 60L);
                long sec = Math.abs(seconds % 60L);
                return (hour < 10L ? "0" + hour : Long.valueOf(hour)) + ":" + (min < 10L ? "0" + min : Long.valueOf(min)) + ":" + (sec < 10L ? "0" + sec : Long.valueOf(sec));
            }
            long min = Math.abs(minutes) % 60L;
            long sec = Math.abs(seconds) % 60L;
            return (min < 10L ? "0" + min : Long.valueOf(min)) + ":" + (sec < 10L ? "0" + sec : Long.valueOf(sec));
        }
        if (milliseconds > 86399999L) {
            return Math.abs(days) + ":" + Math.abs(hours % 24L) + ":" + Math.abs(minutes) % 60L + ":" + Math.abs(seconds) % 60L;
        }
        if (milliseconds > 1439999L) {
            return Math.abs(hours % 24L) + ":" + Math.abs(minutes) % 60L + ":" + Math.abs(seconds) % 60L;
        }
        return Math.abs(minutes) % 60L + ":" + Math.abs(seconds) % 60L;
    }

    public static String random(List<String> list) {
        return list.get(ThreadLocalRandom.current().nextInt(list.size()));
    }

    public static <E> E randomFromList(List<E> list) {
        return list.get(ThreadLocalRandom.current().nextInt(list.size()));
    }

    public static <E> E randomNbt(List<E> list) {
        return list.get(ThreadLocalRandom.current().nextInt(list.size()));
    }

    public static boolean isInteger(String string) {
        try {
            Integer.parseInt(string);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public static LivingEntity getLivingEntityAround(Player player, UUID uuid, int id, int radius) {
        Optional<Entity> entity = player.getNearbyEntities((double)radius, (double)radius, (double)radius).stream().filter(l -> l instanceof LivingEntity && l.getEntityId() == id).findFirst();
        return entity.orElse(null);
    }

    public static TextComponent createClickable(@Nonnull String text, HoverEvent.Action hoverAction, @Nullable String hover, ClickEvent.Action clickAction, String click) {
        TextComponent textComponent = new TextComponent(LocalUtils.colorize(text));
        if (hover != null && hoverAction != null) {
            if (oldHoverMethod) {
                textComponent.setHoverEvent(new HoverEvent(hoverAction, new ComponentBuilder(LocalUtils.colorize(hover)).create()));
            } else {
                textComponent.setHoverEvent(new HoverEvent(hoverAction, new Content[]{new Text(LocalUtils.colorize(hover))}));
            }
        }
        if (click != null && clickAction != null) {
            textComponent.setClickEvent(new ClickEvent(clickAction, click));
        }
        return textComponent;
    }

    public static void sendTitle(Player player, String title, String subtitle, int fadeIn, int stay, int fadeOut) {
        if (oldSendTitleMethod) {
            player.sendTitle(LocalUtils.colorize(title), LocalUtils.colorize(subtitle));
        } else {
            player.sendTitle(LocalUtils.colorize(title), LocalUtils.colorize(subtitle), fadeIn, stay, fadeOut);
        }
    }

    public static void sendTitle(Collection<? extends Player> players, String title, String subtitle, int fadeIn, int stay, int fadeOut) {
        if (oldSendTitleMethod) {
            for (Player player : players) {
                player.sendTitle(LocalUtils.colorize(title), LocalUtils.colorize(subtitle));
            }
        } else {
            for (Player player : players) {
                player.sendTitle(LocalUtils.colorize(title), LocalUtils.colorize(subtitle), fadeIn, stay, fadeOut);
            }
        }
    }

    public static void sendTitle(Player player, String title, String subtitle) {
        LocalUtils.sendTitle(player, title, subtitle, 15, 30, 15);
    }

    public static void sendTitle(Collection<? extends Player> players, String title, String subtitle) {
        LocalUtils.sendTitle(players, title, subtitle, 15, 30, 15);
    }

    public static ItemMeta setUnbreakable(ItemMeta itemMeta, boolean unbreakable) {
        block5: {
            if (newSetUnbreakableMethod) {
                itemMeta.setUnbreakable(unbreakable);
            } else if (setUnbreakableSupport) {
                try {
                    Object itemMetaSpigot = METHOD_ITEM_META_SPIGOT.invoke((Object)itemMeta, new Object[0]);
                    METHOD_SET_UNBREAKABLE_OLD.invoke(itemMetaSpigot, unbreakable);
                }
                catch (Throwable e) {
                    if (!AlonsoJoin.getInstance().debugMode) break block5;
                    LocalUtils.loge("Reflections for setUnbreakable method failed. This is a debug message!");
                }
            }
        }
        return itemMeta;
    }

    public static boolean isUnbreakable(ItemMeta itemMeta) {
        block4: {
            if (newSetUnbreakableMethod) {
                return itemMeta.isUnbreakable();
            }
            if (setUnbreakableSupport) {
                try {
                    Object itemMetaSpigot = METHOD_ITEM_META_SPIGOT.invoke((Object)itemMeta, new Object[0]);
                    return (Boolean)METHOD_IS_UNBREAKABLE_OLD.invoke(itemMetaSpigot, new Object[0]);
                }
                catch (Throwable e) {
                    if (!AlonsoJoin.getInstance().debugMode) break block4;
                    LocalUtils.loge("Reflections for isUnbreakable method failed. This is a debug message!");
                }
            }
        }
        return false;
    }

    public static String fixInventoryTitle(String title) {
        return longInventoryTitleSupport ? title : (title.length() > 32 ? title.substring(0, 32) : title);
    }

    public static boolean isClickableTextSupported() {
        return clickableTextSupport;
    }

    public static void findClasses(String lastChance, String ... clazzes) throws ClassNotFoundException {
        boolean found = false;
        for (String clazz : clazzes) {
            try {
                Class.forName(clazz);
                found = true;
                break;
            }
            catch (Throwable throwable) {
            }
        }
        if (!found) {
            Class.forName(lastChance);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean setMaxHealth(Player player, double value) {
        if (setMaxHealthFeatureSupport) {
            if (setMaxHealthAttributeSupport) {
                AttributeInstance inst = player.getAttribute(Attribute.GENERIC_MAX_HEALTH);
                if (inst == null) return false;
                inst.setBaseValue(value);
                return true;
            }
            try {
                METHOD_SET_MAX_HEALTH.invoke((Object)player, value);
                return true;
            }
            catch (Throwable ignored) {
                if (!AlonsoJoin.getInstance().debugMode) return false;
                LocalUtils.logp("Reflections to set max health failed. This is a debug message!");
                return false;
            }
        } else {
            if (!AlonsoJoin.getInstance().debugMode) return false;
            LocalUtils.logp("Set max health feature is NOT available in this server. Do NOT use it.");
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static double getMaxHealth(Player player) {
        if (getMaxHealthFeatureSupport) {
            if (getMaxHealthAttributeSupport) {
                AttributeInstance inst = player.getAttribute(Attribute.GENERIC_MAX_HEALTH);
                if (inst == null) return 20.0;
                return inst.getValue();
            }
            try {
                return (Double)METHOD_GET_MAX_HEALTH.invoke((Object)player, new Object[0]);
            }
            catch (Throwable ignored) {
                if (!AlonsoJoin.getInstance().debugMode) return 20.0;
                LocalUtils.logp("Reflections to get max health failed. This is a debug message!");
                return 20.0;
            }
        } else {
            if (!AlonsoJoin.getInstance().debugMode) return 20.0;
            LocalUtils.logp("Get max health feature is NOT available in this server. Do NOT use it.");
        }
        return 20.0;
    }

    public static org.bukkit.Color getColor(String string) {
        return LocalUtils.getColor(string, null);
    }

    public static org.bukkit.Color getColor(String string, org.bukkit.Color defaultColor) {
        block14: {
            if (AlonsoJoin.getInstance().debugMode) {
                LocalUtils.logp("Checking if '" + string + "' is a color..");
            }
            try {
                Field field = Color.class.getField(string);
                Color awtColor = (Color)field.get(null);
                if (AlonsoJoin.getInstance().debugMode) {
                    LocalUtils.logp("java.awt.Color field is " + (awtColor == null ? "" : "not ") + "null");
                }
                if (awtColor != null) {
                    return org.bukkit.Color.fromRGB((int)awtColor.getRed(), (int)awtColor.getGreen(), (int)awtColor.getBlue());
                }
            }
            catch (Throwable e) {
                if (!AlonsoJoin.getInstance().debugMode) break block14;
                e.printStackTrace();
                LocalUtils.logp("java.awt.Color field is null (getRGB)");
            }
        }
        try {
            Color color = Color.decode(string.startsWith("#") ? string : "#" + string);
            if (AlonsoJoin.getInstance().debugMode) {
                LocalUtils.logp("java.awt.Color field is " + (color == null ? "" : "not ") + "null");
            }
            return org.bukkit.Color.fromRGB((int)color.getRed(), (int)color.getGreen(), (int)color.getBlue());
        }
        catch (Throwable e) {
            if (AlonsoJoin.getInstance().debugMode) {
                LocalUtils.logp("java.awt.Color.decode is null (" + (string.startsWith("#") ? string : "#" + string) + ")");
            }
            try {
                org.bukkit.Color color = org.bukkit.Color.fromRGB((int)Integer.parseInt(string));
                if (AlonsoJoin.getInstance().debugMode) {
                    LocalUtils.logp("Color.fromRGB is not null (" + color.asRGB() + ").");
                }
                return color;
            }
            catch (Throwable ignored) {
                if (AlonsoJoin.getInstance().debugMode) {
                    LocalUtils.logp("Color.fromRGB is null (" + string + ") not a valid color int.");
                }
                if (AlonsoJoin.getInstance().debugMode) {
                    LocalUtils.logp("Using default color " + defaultColor + "!");
                }
                return defaultColor;
            }
        }
    }

    public static boolean openBook(Player player, ItemStack itemStack) {
        if (nativeOpenBookSupport) {
            player.openBook(itemStack);
            return true;
        }
        if (AlonsoUtils.PluginUtils.hasProtocolLibSupport()) {
            ProtocolLibUtils.sendBook(player, itemStack);
            return true;
        }
        return false;
    }

    public static String setPlaceholders(Player player, String string) {
        if (string.isEmpty()) {
            return string;
        }
        String playerName = player.getName();
        String worldName = player.getWorld().getName();
        String worldUUID = player.getWorld().getUID().toString();
        String x = String.valueOf(player.getLocation().getBlockX());
        String y = String.valueOf(player.getLocation().getBlockY());
        String z = String.valueOf(player.getLocation().getBlockZ());
        String playerUniqueId = player.getUniqueId().toString();
        if ((string = string.replace("{PLAYER}", playerName).replace("{UUID}", playerUniqueId).replace("{WORLD}", worldName).replace("{WORLD_UUID}", worldUUID).replace("{X}", x).replace("{Y}", y).replace("{Z}", z)).contains("{UNIQUE_PLAYERS}")) {
            string = string.replace("{UNIQUE_PLAYERS}", String.valueOf(Bukkit.getOfflinePlayers().length + 1));
        }
        return AlonsoUtils.PluginUtils.hasPlaceholderApiSupport() ? PlaceholderAPI.setPlaceholders((Player)player, (String)string) : string;
    }

    public static Component buildComponent(String string) {
        return LegacyComponentSerializer.legacyAmpersand().deserialize(string);
    }

    public static boolean isSoundCategoryAvailable() {
        return soundCategorySupport;
    }

    static {
        Object spigotMeta;
        ItemMeta testMeta;
        ItemStack testItem;
        DAY_START = 22750L;
        DAY_END = 12750L;
        METHOD_SET_UNBREAKABLE_OLD = null;
        METHOD_IS_UNBREAKABLE_OLD = null;
        METHOD_ITEM_META_SPIGOT = null;
        METHOD_GET_MAX_HEALTH = null;
        METHOD_SET_MAX_HEALTH = null;
        fixColors = true;
        colorMap = new HashMap<org.bukkit.ChatColor, ColorSet<Integer, Integer, Integer>>();
        PARSED_HEX_PATTERN = Pattern.compile("\u00a7x(\u00a7[a-f0-9]){6}", 2);
        PARSED_PATTERN_COLORS = Pattern.compile("\u00a7[a-f0-9klmnor]", 2);
        HEX_COLOR_PATTERN_TO_FIX = Pattern.compile("(?<!&)#[a-f0-9]{6}", 2);
        HEX_COLOR_PATTERN = Pattern.compile("&?#[a-f0-9]{6}", 2);
        try {
            Class.forName("org.bukkit.SoundCategory");
            soundCategorySupport = true;
        }
        catch (Throwable e) {
            soundCategorySupport = false;
        }
        try {
            Player.class.getMethod("getAttribute", Attribute.class);
            getMaxHealthAttributeSupport = true;
            setMaxHealthAttributeSupport = true;
            getMaxHealthFeatureSupport = true;
            setMaxHealthFeatureSupport = true;
            LocalUtils.logp("Max health Attribute check found. Using it..");
        }
        catch (Throwable e) {
            getMaxHealthAttributeSupport = false;
            setMaxHealthAttributeSupport = false;
            try {
                METHOD_GET_MAX_HEALTH = Player.class.getMethod("getMaxHealth", new Class[0]);
                getMaxHealthFeatureSupport = true;
                LocalUtils.logp("Max health Attribute check not found. Using Player#getMaxHealth method..");
            }
            catch (Throwable e2) {
                getMaxHealthFeatureSupport = false;
                LocalUtils.logp("Max health check couldn't be loaded. Feature will be disabled and will always return 20..");
            }
            try {
                METHOD_SET_MAX_HEALTH = Player.class.getMethod("setMaxHealth", Double.TYPE);
                setMaxHealthFeatureSupport = true;
                LocalUtils.logp("Max health Attribute check not found. Using Player#getMaxHealth method..");
            }
            catch (Throwable e2) {
                setMaxHealthFeatureSupport = false;
                LocalUtils.logp("Max health check couldn't be loaded. Feature will be disabled and will always return 20..");
            }
        }
        try {
            Inventory inventory = Bukkit.createInventory(null, (int)9, (String)"Hello Thanks For Downloading My Plugin. Consider donating to support my work on https://alonsoaliaga.com/donate");
            inventory.setItem(0, new ItemStack(Materials.PLAYER_HEAD.getMaterial()));
            longInventoryTitleSupport = true;
            LocalUtils.logp("Inventory title with support for more than 32 characters. Skipping..");
        }
        catch (Throwable e) {
            longInventoryTitleSupport = false;
            LocalUtils.logp("Inventory title without support for more than 32 characters. Limiting..");
        }
        try {
            Class<?> CLASS_CHAT_COLOR_BUNGEE = Class.forName("net.md_5.bungee.api.ChatColor");
            CLASS_CHAT_COLOR_BUNGEE.getDeclaredMethod("of", String.class);
            hexColorSupport = true;
            LocalUtils.logp("Hex colors are available! Ready for RGB..");
        }
        catch (Throwable e) {
            hexColorSupport = false;
            LocalUtils.logp("Hex colors are not available! Ignoring..");
        }
        try {
            HoverEvent.class.getDeclaredConstructor(HoverEvent.Action.class, BaseComponent[].class);
            oldHoverMethod = true;
            clickableTextSupport = true;
            LocalUtils.logp("Old constructor for HoverEvent found! Using it..");
        }
        catch (Throwable e) {
            oldHoverMethod = false;
            try {
                Class<?> CLASS_PLAYER_SPIGOT = Class.forName("org.bukkit.entity.Player$Spigot");
                CLASS_PLAYER_SPIGOT.getDeclaredMethod("sendMessage", TextComponent.class);
                clickableTextSupport = true;
                LocalUtils.logp("Old constructor for HoverEvent not found! Using the new one..");
            }
            catch (Throwable e2) {
                clickableTextSupport = false;
                LocalUtils.logp("Clickable text is not available, consider using spigot or forks! Skipping..");
            }
        }
        try {
            Player.class.getDeclaredMethod("sendTitle", String.class, String.class, Integer.TYPE, Integer.TYPE, Integer.TYPE);
            oldSendTitleMethod = false;
            LocalUtils.logp("New sendTitle method found! Using it..");
        }
        catch (Throwable e) {
            oldSendTitleMethod = true;
            LocalUtils.logp("New sendTitle method not found! Using the old one..");
        }
        try {
            ItemMeta.class.getDeclaredMethod("setUnbreakable", Boolean.TYPE);
            newSetUnbreakableMethod = true;
            setUnbreakableSupport = true;
            LocalUtils.logp("New setUnbreakable method found! Using it..");
        }
        catch (Throwable e) {
            try {
                METHOD_ITEM_META_SPIGOT = ItemMeta.class.getDeclaredMethod("spigot", new Class[0]);
                testItem = new ItemStack(LocalUtils.findMaterial("COBBLESTONE", "PLAYER_HEAD", "SKULL", "STONE"));
                testMeta = testItem.getItemMeta();
                spigotMeta = METHOD_ITEM_META_SPIGOT.invoke((Object)testMeta, new Object[0]);
                METHOD_SET_UNBREAKABLE_OLD = spigotMeta.getClass().getDeclaredMethod("setUnbreakable", Boolean.TYPE);
                testItem.setItemMeta(testMeta);
                newSetUnbreakableMethod = false;
                setUnbreakableSupport = true;
                LocalUtils.logp("New setUnbreakable method not found! Using the old one for spigot ONLY..");
            }
            catch (Throwable e2) {
                newSetUnbreakableMethod = false;
                setUnbreakableSupport = false;
                LocalUtils.logp("Server type/version does not support setUnbreakable method. Consider using spigot/paper!");
            }
        }
        try {
            ItemMeta.class.getDeclaredMethod("isUnbreakable", new Class[0]);
            newIsUnbreakableMethod = true;
            isUnbreakableSupport = true;
            LocalUtils.logp("New isUnbreakable method found! Using it..");
        }
        catch (Throwable e) {
            try {
                METHOD_ITEM_META_SPIGOT = ItemMeta.class.getDeclaredMethod("spigot", new Class[0]);
                testItem = new ItemStack(LocalUtils.findMaterial("COBBLESTONE", "PLAYER_HEAD", "SKULL", "STONE"));
                testMeta = testItem.getItemMeta();
                spigotMeta = METHOD_ITEM_META_SPIGOT.invoke((Object)testMeta, new Object[0]);
                METHOD_IS_UNBREAKABLE_OLD = spigotMeta.getClass().getDeclaredMethod("isUnbreakable", new Class[0]);
                testItem.setItemMeta(testMeta);
                newIsUnbreakableMethod = false;
                isUnbreakableSupport = true;
                LocalUtils.logp("New isUnbreakable method not found! Using the old one for spigot ONLY..");
            }
            catch (Throwable e2) {
                newIsUnbreakableMethod = false;
                isUnbreakableSupport = false;
                LocalUtils.logp("Server type/version does not support isUnbreakable method. Consider using spigot/paper!");
            }
        }
        try {
            Player.class.getMethod("openBook", ItemStack.class);
            nativeOpenBookSupport = true;
        }
        catch (Throwable e) {
            nativeOpenBookSupport = false;
        }
        if (hexColorSupport) {
            colorMap.put(org.bukkit.ChatColor.BLACK, new ColorSet<Integer, Integer, Integer>(0, 0, 0));
            colorMap.put(org.bukkit.ChatColor.DARK_BLUE, new ColorSet<Integer, Integer, Integer>(0, 0, 170));
            colorMap.put(org.bukkit.ChatColor.DARK_GREEN, new ColorSet<Integer, Integer, Integer>(0, 170, 0));
            colorMap.put(org.bukkit.ChatColor.DARK_AQUA, new ColorSet<Integer, Integer, Integer>(0, 170, 170));
            colorMap.put(org.bukkit.ChatColor.DARK_RED, new ColorSet<Integer, Integer, Integer>(170, 0, 0));
            colorMap.put(org.bukkit.ChatColor.DARK_PURPLE, new ColorSet<Integer, Integer, Integer>(170, 0, 170));
            colorMap.put(org.bukkit.ChatColor.GOLD, new ColorSet<Integer, Integer, Integer>(255, 170, 0));
            colorMap.put(org.bukkit.ChatColor.GRAY, new ColorSet<Integer, Integer, Integer>(170, 170, 170));
            colorMap.put(org.bukkit.ChatColor.DARK_GRAY, new ColorSet<Integer, Integer, Integer>(85, 85, 85));
            colorMap.put(org.bukkit.ChatColor.BLUE, new ColorSet<Integer, Integer, Integer>(85, 85, 255));
            colorMap.put(org.bukkit.ChatColor.GREEN, new ColorSet<Integer, Integer, Integer>(85, 255, 85));
            colorMap.put(org.bukkit.ChatColor.AQUA, new ColorSet<Integer, Integer, Integer>(85, 255, 255));
            colorMap.put(org.bukkit.ChatColor.RED, new ColorSet<Integer, Integer, Integer>(255, 85, 85));
            colorMap.put(org.bukkit.ChatColor.LIGHT_PURPLE, new ColorSet<Integer, Integer, Integer>(255, 85, 255));
            colorMap.put(org.bukkit.ChatColor.YELLOW, new ColorSet<Integer, Integer, Integer>(255, 255, 85));
            colorMap.put(org.bukkit.ChatColor.WHITE, new ColorSet<Integer, Integer, Integer>(255, 255, 255));
        }
        placeholderHexFormat = "&#{COLOR}";
        suffixes = new TreeMap<Long, String>();
        suffixes.put(1000L, "k");
        suffixes.put(1000000L, "M");
        suffixes.put(1000000000L, "G");
        suffixes.put(1000000000000L, "T");
        suffixes.put(1000000000000000L, "P");
        suffixes.put(1000000000000000000L, "E");
    }

    private static class ColorSet<R, G, B> {
        R red = null;
        G green = null;
        B blue = null;

        ColorSet(R red, G green, B blue) {
            this.red = red;
            this.green = green;
            this.blue = blue;
        }

        public R getRed() {
            return this.red;
        }

        public G getGreen() {
            return this.green;
        }

        public B getBlue() {
            return this.blue;
        }
    }
}

