/*
 * Decompiled with CFR 0.152.
 */
package com.alonsoaliaga.alonsojoin.utils;

import com.alonsoaliaga.alonsojoin.AlonsoJoin;
import com.alonsoaliaga.alonsojoin.others.FileManager;
import com.alonsoaliaga.alonsojoin.utils.LocalUtils;
import com.alonsoaliaga.alonsojoin.utils.ProtocolLibUtils;
import com.alonsoaliaga.alonsojoin.utils.SafeLogger;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Base64;
import javax.annotation.Nullable;
import javax.net.ssl.HttpsURLConnection;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;

public class AlonsoUtils {
    public static final String PLUGIN = "AlonsoJoin";
    public static final boolean DEBUG = true;
    public static String first = "&d";
    public static String second = "&5";
    public static final String PREFIX = second + "[" + "AlonsoJoin" + "] &7";
    public static final String PREFIXC = "[AlonsoJoin] ";
    public static ServerType serverType = AlonsoUtils.getServerType();
    public static ServerVersion serverVersion = AlonsoUtils.getServerVersion();
    public static final String DEVELOPER_TEXTURE = "ewogICJ0aW1lc3RhbXAiIDogMTU5NDQ0NjkyMDI5NiwKICAicHJvZmlsZUlkIiA6ICJlMWMxYTE5NDdlODY0MTRmODZiYjQyZDgyYTIxY2ZiOCIsCiAgInByb2ZpbGVOYW1lIiA6ICJBbG9uc29BbGlhZ2EiLAogICJ0ZXh0dXJlcyIgOiB7CiAgICAiU0tJTiIgOiB7CiAgICAgICJ1cmwiIDogImh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvMTY4YWE3NGNjODg1NzgwNjBkMGZlM2JkOTA4YjM0ZjY5ZjEyZTA3ZjFmODljNWRkYzE1ZTZiZjYwZjA0Y2NjNiIKICAgIH0KICB9Cn0=";

    public static void sendEnableText(JavaPlugin plugin) {
        LocalUtils.log(first + "    _   _                     _     _       Running " + second + "v" + plugin.getDescription().getVersion());
        LocalUtils.log(first + "   /_\\ | |___ _ _  ___ ___ _ | |___(_)_ _   Server " + second + Bukkit.getServer().getName() + first + " v" + Bukkit.getVersion());
        LocalUtils.log(first + "  / _ \\| / _ \\ ' \\(_-</ _ \\ || / _ \\ | ' \\  Discord for support: " + second + "https://alonsoaliaga.com/discord");
        LocalUtils.log(second + " /_/ \\_\\_\\___/_||_/__/\\___/\\__/\\___/_|_||_| Thanks for using my plugin " + second + "\u2764" + first + "!");
        LocalUtils.log(second + "        " + first + "Developed by " + second + "AlonsoAliaga");
        LocalUtils.log("");
        if (plugin.getDescription().getVersion().contains("-DEV") || plugin.getDescription().getVersion().contains("-DEV-")) {
            LocalUtils.log(first + "   You are using a Development build of " + second + plugin.getDescription().getName() + first + ". Make sure you update the plugin once");
            LocalUtils.log(first + "   an official update is released on SpigotMC to ensure plugin is free of bugs.");
            LocalUtils.log("");
        }
    }

    private static ServerType getServerType() {
        try {
            LocalUtils.findClasses("com.destroystokyo.paper.event.player.PlayerJumpEvent", "com.destroystokyo.paper.event.block.BeaconEffectEvent", "com.destroystokyo.paper.PaperConfig", "org.github.paperspigot.event.block.BeaconEffectEvent", "org.github.paperspigot.PaperSpigotConfig", "org.github.paperspigot.exception.ServerException");
            return ServerType.PAPER;
        }
        catch (Throwable e1) {
            try {
                LocalUtils.findClasses("org.spigotmc.event.entity.EntityDismountEvent", "org.spigotmc.event.entity.EntityMountEvent");
                return ServerType.SPIGOT;
            }
            catch (Throwable e2) {
                return ServerType.CRAFTBUKKIT;
            }
        }
    }

    public static boolean isSupported() {
        if (serverType == ServerType.PAPER) {
            LocalUtils.log(second + "==============================================================================================");
            LocalUtils.log(first + PREFIXC + "This is not a error! This is just a warning to keep in mind if you have issues!");
            LocalUtils.log(first + PREFIXC + "You are using a Paper fork (" + Bukkit.getName() + "). This plugin was made for Spigot");
            LocalUtils.log(first + PREFIXC + "but was (in most cases) tested with different builds of Paper and Purpur.");
            LocalUtils.log(first + PREFIXC + "Spigot and forks API are really similar and should be compatible, however there are");
            LocalUtils.log(first + PREFIXC + "some cases in which they aren't compatible. If you have issues report them to the");
            LocalUtils.log(first + PREFIXC + "developer instead of reviewing 1 star. Thanks in advanced!");
            LocalUtils.log(first + PREFIXC + "Join us in our official support server on alonsoaliaga.com/discord");
            LocalUtils.log(second + "==============================================================================================");
            LocalUtils.log("");
        } else if (serverType == ServerType.SPIGOT) {
            LocalUtils.log(second + "==============================================================================================");
            LocalUtils.log(first + PREFIXC + "You are using a Spigot or a Spigot fork (" + Bukkit.getName() + "), plugin should work fine!");
            LocalUtils.log(first + PREFIXC + "If you have issues, join us on our official support server on alonsoaliaga.com/discord");
            LocalUtils.log(second + "==============================================================================================");
            LocalUtils.log("");
        } else {
            LocalUtils.log("&c==============================================================================================");
            LocalUtils.log("&c[AlonsoJoin] This is not a error! This is just a warning to keep in mind if you have issues!");
            LocalUtils.log("&c[AlonsoJoin] You are using an Unknown fork (" + Bukkit.getName() + "). This plugin was made for Spigot");
            LocalUtils.log("&c[AlonsoJoin] but was (in most cases) tested with different builds of Paper and Purpur.");
            LocalUtils.log("&c[AlonsoJoin] Spigot and forks API are really similar and should be compatible, however there are");
            LocalUtils.log("&c[AlonsoJoin] some cases in which they aren't compatible. If you have issues report them to the");
            LocalUtils.log("&c[AlonsoJoin] developer instead of reviewing 1 star. Thanks in advanced!");
            LocalUtils.log("&c[AlonsoJoin] Join us in our official support server on alonsoaliaga.com/discord");
            LocalUtils.log("&c==============================================================================================");
            LocalUtils.log("");
        }
        return true;
    }

    public static ServerVersion getServerVersion() {
        String version = Bukkit.getBukkitVersion().trim();
        for (ServerVersion value : ServerVersion.values()) {
            if (!version.startsWith(value.getVersionString())) continue;
            serverVersion = value;
            return value;
        }
        return ServerVersion.v1_20;
    }

    public static void sendDisableText() {
        SafeLogger.log(" ");
        SafeLogger.log(String.format("&c%sPlugin has been disabled!", PREFIXC));
        SafeLogger.log(String.format("&c%sThank you for using my plugin!", PREFIXC));
        SafeLogger.log(" ");
    }

    public static class Updater {
        private String resourceID;
        private JavaPlugin plugin;
        private int updateCheckCounter = 0;
        private UpdateFound updateFound = null;
        private String notificationMessage = null;

        public Updater(JavaPlugin plugin, @Nullable String resourceID, boolean notify, @Nullable String notifyPermission, String notificationMessage) {
            this.plugin = plugin;
            this.resourceID = resourceID;
            if (plugin.isEnabled() && resourceID != null && !resourceID.isEmpty()) {
                this.startChecking();
                if (notify) {
                    new UpdateJoinListener(plugin, notifyPermission);
                }
                this.notificationMessage = LocalUtils.colorize(notificationMessage == null ? String.format("%s&eA new update has been found! Download it here &c{LINK}", PREFIX) : notificationMessage);
            }
        }

        private void checkSafeUpdate() {
            if (this.resourceID == null || this.resourceID.isEmpty()) {
                return;
            }
            Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
                block11: {
                    HttpsURLConnection connection = null;
                    try {
                        connection = (HttpsURLConnection)new URL(new String(Base64.getDecoder().decode("aHR0cHM6Ly9yYXcuZ2l0aHVidXNlcmNvbnRlbnQuY29tL0Fsb25zb0FsaWFnYS9BbG9uc29BbGlhZ2FBUEkvbWFpbi9hcGkvc3BpZ290bWMvdXBkYXRlcy5qc29u"))).openConnection();
                        int timed_out = 1250;
                        connection.setConnectTimeout(timed_out);
                        connection.setReadTimeout(timed_out);
                        String localPluginVersion = this.plugin.getDescription().getVersion();
                        String toParse = new BufferedReader(new InputStreamReader(connection.getInputStream())).readLine();
                        JsonParser parser = new JsonParser();
                        JsonObject jsonObject = parser.parse(toParse).getAsJsonObject();
                        if (jsonObject.has(this.resourceID)) {
                            LocalUtils.logp("Checking for updates...");
                            JsonObject dataObject = jsonObject.getAsJsonObject(this.resourceID);
                            String spigotPluginVersion = dataObject.get("version").getAsString();
                            if (!spigotPluginVersion.equals(localPluginVersion)) {
                                this.updateFound = new UpdateFound(spigotPluginVersion, this.resourceID);
                                LocalUtils.logp(String.format("&aNew version available: %s", spigotPluginVersion));
                                LocalUtils.logp("&aPlease download the latest version to get support!");
                                LocalUtils.logp(String.format("&aDownload: https://www.spigotmc.org/resources/%s/", this.resourceID));
                            } else {
                                this.updateFound = null;
                                if (this.updateCheckCounter % 3 == 0) {
                                    LocalUtils.logp("&ePlugin up-to-date! You have the latest version!");
                                }
                            }
                        } else {
                            LocalUtils.log(String.format("&c%sCouldn't find updates info! Check updates on &b%s", AlonsoUtils.PREFIXC, String.format("https://www.spigotmc.org/resources/%s/", this.resourceID)));
                        }
                        connection.disconnect();
                        ++this.updateCheckCounter;
                    }
                    catch (Throwable e) {
                        if (AlonsoJoin.getInstance().debugMode) {
                            LocalUtils.log(String.format("&c%sFailed to check for an update on RestAPI: %s", AlonsoUtils.PREFIXC, e.getMessage()));
                        } else {
                            LocalUtils.log(String.format("&c%sFailed to check for an update on RestAPI!", AlonsoUtils.PREFIXC));
                        }
                        ++this.updateCheckCounter;
                        if (connection == null) break block11;
                        try {
                            connection.disconnect();
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                }
            });
        }

        private void checkUpdate() {
            if (this.resourceID == null || this.resourceID.isEmpty()) {
                return;
            }
            Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
                block10: {
                    HttpURLConnection connection = null;
                    try {
                        connection = (HttpsURLConnection)new URL(String.format("https://api.spigotmc.org/legacy/update.php?resource=%s", this.resourceID)).openConnection();
                        int timed_out = 1250;
                        connection.setConnectTimeout(timed_out);
                        connection.setReadTimeout(timed_out);
                        String localPluginVersion = this.plugin.getDescription().getVersion();
                        String spigotPluginVersion = new BufferedReader(new InputStreamReader(connection.getInputStream())).readLine();
                        LocalUtils.logp("Checking for updates...");
                        if (!spigotPluginVersion.equals(localPluginVersion)) {
                            this.updateFound = new UpdateFound(spigotPluginVersion, this.resourceID);
                            LocalUtils.logp(String.format("&aNew version available: %s", spigotPluginVersion));
                            LocalUtils.logp("&aPlease download the latest version to get support!");
                            LocalUtils.logp(String.format("&aDownload: https://www.spigotmc.org/resources/%s/", this.resourceID));
                        } else {
                            this.updateFound = null;
                            if (this.updateCheckCounter % 3 == 0) {
                                LocalUtils.logp("&ePlugin up-to-date! You have the latest version!");
                            }
                        }
                        connection.disconnect();
                        ++this.updateCheckCounter;
                    }
                    catch (Throwable e) {
                        if (AlonsoJoin.getInstance().debugMode) {
                            LocalUtils.log(String.format("&c%sFailed to check for an update on SpigotMC. Error: %s", AlonsoUtils.PREFIXC, e.getMessage()));
                        }
                        if (AlonsoJoin.getInstance().debugMode) {
                            LocalUtils.log(String.format("&c%sAttempting RestAPI..", AlonsoUtils.PREFIXC));
                        }
                        if (connection != null) {
                            try {
                                connection.disconnect();
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                        }
                        if (this.updateFound != null) break block10;
                        this.checkSafeUpdate();
                    }
                }
            });
        }

        private void startChecking() {
            new BukkitRunnable(){

                public void run() {
                    if (!plugin.isEnabled()) {
                        this.cancel();
                        return;
                    }
                    this.checkUpdate();
                }
            }.runTaskTimerAsynchronously((Plugin)this.plugin, 0L, 86400000L);
        }

        public class UpdateJoinListener
        implements Listener {
            private JavaPlugin plugin;
            private String notifyPermission;

            public UpdateJoinListener(@Nullable JavaPlugin plugin, String notifyPermission) {
                this.plugin = plugin;
                this.notifyPermission = notifyPermission == null || notifyPermission.equalsIgnoreCase("none") ? null : notifyPermission;
                plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
            }

            @EventHandler
            public void onJoinUpdate(PlayerJoinEvent e) {
                if (Updater.this.updateFound != null && (e.getPlayer().isOp() || this.notifyPermission != null && e.getPlayer().hasPermission(this.notifyPermission))) {
                    e.getPlayer().sendMessage(Updater.this.notificationMessage.replace("{NEWLINE}", "\n").replace("{CURRENT}", this.plugin.getDescription().getVersion()).replace("{NEW}", Updater.this.updateFound.getNewVersion()).replace("{LINK}", Updater.this.updateFound.getDownloadLink()));
                }
            }
        }

        public class UpdateFound {
            private String newVersion;
            private String resourceID;

            public UpdateFound(String newVersion, String resourceID) {
                this.newVersion = newVersion;
                this.resourceID = resourceID;
            }

            public String getNewVersion() {
                return this.newVersion;
            }

            public String getDownloadLink() {
                return String.format("https://www.spigotmc.org/resources/%s/history", this.resourceID);
            }
        }
    }

    public static class PluginUtils {
        private JavaPlugin plugin;
        private ActionBarType actionBarType;
        private ServerType serverType;
        private ServerVersion serverVersion;
        private boolean protocolLibSupported;
        private static boolean protocolLibSupport;
        private boolean customModelSupport;
        private int actionBarProtocolMethod;
        private boolean betterHeadsSupported;
        private static boolean betterHeadsSupport;
        private boolean nbtApiSupported;
        private static boolean nbtApiSupport;
        private boolean placeholderApiSupported;
        private static boolean placeholderApiSupport;
        private boolean citizensSupported;
        private static boolean citizensSupport;

        public PluginUtils(JavaPlugin plugin) {
            this.plugin = plugin;
            this.load();
        }

        private void load() {
            this.actionBarType = ActionBarType.UNSUPPORTED;
            this.betterHeadsSupported = Bukkit.getServer().getPluginManager().getPlugin("BetterHeads") != null;
            this.nbtApiSupported = Bukkit.getServer().getPluginManager().getPlugin("NBTAPI") != null;
            this.placeholderApiSupported = Bukkit.getServer().getPluginManager().getPlugin("PlaceholderAPI") != null;
            this.citizensSupported = Bukkit.getServer().getPluginManager().getPlugin("Citizens") != null;
            this.serverType = serverType;
            this.serverVersion = serverVersion;
            this.protocolLibSupported = false;
            this.customModelSupport = this.serverVersion.getWeight() >= ServerVersion.v1_14.getWeight();
            this.actionBarProtocolMethod = -1;
            try {
                Class<?> CLASS_CHAT_MESSAGE_TYPE = Class.forName("net.md_5.bungee.api.ChatMessageType");
                Class<?> CLASS_BASE_COMPONENT = Class.forName("net.md_5.bungee.api.chat.BaseComponent");
                Player.Spigot.class.getDeclaredMethod("sendMessage", CLASS_CHAT_MESSAGE_TYPE, CLASS_BASE_COMPONENT);
                LocalUtils.logp("BungeeCord action bar available. Hooking..");
                this.actionBarType = ActionBarType.BUNGEE;
            }
            catch (Throwable e) {
                LocalUtils.logp("BungeeCord action bar not available for your server type/version! Skipping..");
            }
            if (this.plugin.getServer().getPluginManager().getPlugin("ProtocolLib") != null) {
                LocalUtils.logp("ProtocolLib found! Checking..");
                this.protocolLibSupported = true;
                if (this.actionBarType != ActionBarType.BUNGEE) {
                    this.actionBarProtocolMethod = ProtocolLibUtils.getProtocolActionBarMethod();
                    if (this.actionBarProtocolMethod != -1) {
                        this.actionBarType = ActionBarType.PROTOCOL;
                    }
                }
            } else {
                LocalUtils.logp("ProtocolLib not found! Skipping..");
            }
        }

        public ServerType getServerType() {
            return this.serverType;
        }

        public ServerVersion getServerVersion() {
            return this.serverVersion;
        }

        public ActionBarType getActionBarType() {
            return this.actionBarType;
        }

        public boolean isProtocolLibSupported() {
            return this.protocolLibSupported;
        }

        public static boolean hasProtocolLibSupport() {
            return protocolLibSupport;
        }

        public boolean isCustomModelSupported() {
            return this.customModelSupport;
        }

        public boolean isV1_8() {
            return this.serverVersion == ServerVersion.v1_8;
        }

        public int getActionBarProtocolMethod() {
            return this.actionBarProtocolMethod;
        }

        public boolean isBetterHeadsSupported() {
            return this.betterHeadsSupported;
        }

        public static boolean hasBetterHeadsSupport() {
            return betterHeadsSupport;
        }

        public boolean isNbtApiSupported() {
            return this.nbtApiSupported;
        }

        public static boolean hasNbtApiSupport() {
            return nbtApiSupport;
        }

        public boolean isPlaceholderApiSupported() {
            return this.placeholderApiSupported;
        }

        public static boolean hasPlaceholderApiSupport() {
            return placeholderApiSupport;
        }

        public static boolean hasCitizensSupport() {
            return citizensSupport;
        }

        public boolean isCitizensSupported() {
            return this.citizensSupported;
        }

        static {
            betterHeadsSupport = Bukkit.getServer().getPluginManager().getPlugin("BetterHeads") != null;
            nbtApiSupport = Bukkit.getServer().getPluginManager().getPlugin("NBTAPI") != null;
            placeholderApiSupport = Bukkit.getServer().getPluginManager().getPlugin("PlaceholderAPI") != null;
            citizensSupport = Bukkit.getServer().getPluginManager().getPlugin("Citizens") != null;
            protocolLibSupport = Bukkit.getServer().getPluginManager().getPlugin("ProtocolLib") != null;
        }
    }

    public static interface AlonsoPlugin {
        public PluginUtils getPluginUtils();

        public FileManager getFiles();

        public JavaPlugin getPlugin();

        public AlonsoJoin getMain();
    }

    public static enum ActionBarType {
        PROTOCOL,
        BUNGEE,
        UNSUPPORTED;

    }

    public static enum ServerVersion {
        v1_7(0, "1.7"),
        v1_8(1, "1.8"),
        v1_9(2, "1.9"),
        v1_10(3, "1.10"),
        v1_11(4, "1.11"),
        v1_12(5, "1.12"),
        v1_13(6, "1.13"),
        v1_14(7, "1.14"),
        v1_15(8, "1.15"),
        v1_16(9, "1.16"),
        v1_17(10, "1.17"),
        v1_18(11, "1.18"),
        v1_19(12, "1.19"),
        v1_20(13, "1.20");

        int weight;
        String versionString;

        private ServerVersion(int weight, String versionString) {
            this.weight = weight;
            this.versionString = versionString;
        }

        public int getWeight() {
            return this.weight;
        }

        public String getVersionString() {
            return this.versionString;
        }

        public boolean isOlderEqualThan(ServerVersion version) {
            return this.getWeight() <= version.getWeight();
        }

        public boolean isOlderThan(ServerVersion version) {
            return this.getWeight() < version.getWeight();
        }

        public boolean isNewerEqualThan(ServerVersion version) {
            return this.getWeight() >= version.getWeight();
        }

        public boolean isNewerThan(ServerVersion version) {
            return this.getWeight() > version.getWeight();
        }

        public boolean isEqualThan(ServerVersion version) {
            return this.getWeight() == version.getWeight();
        }

        public boolean isV1_8() {
            return this == v1_8;
        }

        public boolean isLegacy() {
            return this.getWeight() <= v1_12.getWeight();
        }

        public boolean isNewerEqualThanV1_13() {
            return this.getWeight() >= v1_13.getWeight();
        }

        public boolean isNewerThanV1_13() {
            return this.getWeight() > v1_13.getWeight();
        }

        public boolean isNewerThanV1_12() {
            return this.getWeight() > v1_12.getWeight();
        }

        public boolean isNewerEqualThanV1_11() {
            return this.getWeight() >= v1_11.getWeight();
        }

        public boolean isNewerEqualThanV1_16() {
            return this.getWeight() >= v1_16.getWeight();
        }

        public boolean isNewerThanV1_16() {
            return this.getWeight() > v1_16.getWeight();
        }

        public boolean isNewerThanV1_17() {
            return this.getWeight() > v1_17.getWeight();
        }

        public boolean isNewerThanV1_20() {
            return this.getWeight() > v1_20.getWeight();
        }

        public boolean isNewerEqualThanV1_20() {
            return this.getWeight() >= v1_20.getWeight();
        }
    }

    public static enum ServerType {
        CRAFTBUKKIT,
        SPIGOT,
        PAPER;

    }
}

