/*
 * Decompiled with CFR 0.152.
 */
package com.alonsoaliaga.alonsojoin.others;

import com.alonsoaliaga.alonsojoin.utils.AlonsoUtils;
import org.bukkit.Bukkit;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.permissions.Permission;
import org.bukkit.permissions.PermissionDefault;

public class Permissions {
    private AlonsoUtils.AlonsoPlugin plugin;
    public String mainPermission;
    public String adminPermission;
    public String staffPermission;
    public String fakeJoinPermission;
    public String fakeLeavePermission;

    public Permissions(AlonsoUtils.AlonsoPlugin plugin) {
        this.plugin = plugin;
        this.reloadMessages();
    }

    public void reloadMessages() {
        FileConfiguration config = this.plugin.getFiles().getConfig().get();
        this.mainPermission = config.getString("Permissions.Main", "none");
        if (this.mainPermission.equalsIgnoreCase("none")) {
            this.mainPermission = null;
        }
        this.adminPermission = config.getString("Permissions.Admin", "alonsojoin.admin");
        this.staffPermission = config.getString("Options.Exceptions.Permission", "alonsojoin.staff");
        this.fakeJoinPermission = config.getString("Permissions.Fake-join", "alonsojoin.fake-join");
        this.fakeLeavePermission = config.getString("Permissions.Fake-leave", "alonsojoin.fake-leave");
    }

    public void addPermission(String permission, PermissionDefault permissionDefault) {
        try {
            Bukkit.getServer().getPluginManager().addPermission(new Permission(permission, permissionDefault));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }
}

