/*
 * Decompiled with CFR 0.152.
 */
package com.alonsoaliaga.alonsojoin.others;

import com.alonsoaliaga.alonsojoin.AlonsoJoin;
import com.alonsoaliaga.alonsojoin.enums.ActionType;
import com.alonsoaliaga.alonsojoin.utils.LocalUtils;
import com.alonsoaliaga.alonsolib.libraries.adventure.text.Component;
import com.alonsoaliaga.alonsolib.libraries.adventure.text.TextComponent;
import com.alonsoaliaga.alonsolib.libraries.adventure.text.event.ClickEvent;
import com.alonsoaliaga.alonsolib.libraries.adventure.text.event.HoverEvent;
import com.alonsoaliaga.alonsolib.libraries.adventure.text.event.HoverEventSource;
import com.alonsoaliaga.alonsolib.libraries.adventure.text.serializer.legacy.LegacyComponentSerializer;
import java.util.List;
import me.clip.placeholderapi.PlaceholderAPI;
import org.bukkit.entity.Player;

public class PartBuilder {
    private AlonsoJoin plugin;
    private String text;
    private List<String> hover;
    private ActionType actionType;
    private String value;

    public PartBuilder(AlonsoJoin plugin, String text, List<String> hover, ActionType actionType, String value) {
        this.plugin = plugin;
        this.text = LocalUtils.fixHexColorCodes(text);
        this.hover = hover == null || hover.isEmpty() ? null : LocalUtils.fixHexColorCodes(hover);
        this.actionType = actionType;
        this.value = value == null ? value : LocalUtils.fixHexColorCodes(value);
        this.processData();
    }

    private void processData() {
        if (this.actionType != null && this.value != null) {
            switch (this.actionType) {
                case RUN_COMMAND: 
                case SUGGEST_COMMAND: {
                    if (this.value.startsWith("/")) break;
                    this.value = "/" + this.value;
                }
            }
        } else {
            this.actionType = null;
            this.value = null;
        }
    }

    public Component build(Player player, Player player2) {
        TextComponent component = LegacyComponentSerializer.legacyAmpersand().deserialize(this.setPlaceholders(player, player2, this.text));
        if (this.hover != null) {
            component = component.hoverEvent((HoverEventSource)HoverEvent.showText((Component)LegacyComponentSerializer.legacyAmpersand().deserialize(this.setPlaceholders(player, player2, String.join((CharSequence)"\n", this.hover)))));
        }
        if (this.actionType != null) {
            switch (this.actionType) {
                case OPEN_URL: {
                    component = component.clickEvent(ClickEvent.openUrl((String)this.setPlaceholders(player, player2, this.value)));
                    break;
                }
                case SUGGEST_COMMAND: {
                    component = component.clickEvent(ClickEvent.suggestCommand((String)this.setPlaceholders(player, player2, this.value)));
                    break;
                }
                case SUGGEST_CHAT: {
                    component = component.clickEvent(ClickEvent.suggestCommand((String)this.setPlaceholders(player, player2, this.value)));
                    break;
                }
                case CHAT: {
                    component = component.clickEvent(ClickEvent.runCommand((String)this.setPlaceholders(player, player2, this.value)));
                    break;
                }
                case RUN_COMMAND: {
                    component = component.clickEvent(ClickEvent.runCommand((String)this.setPlaceholders(player, player2, this.value)));
                    break;
                }
                case COPY_TO_CLIPBOARD: {
                    component = component.clickEvent(ClickEvent.copyToClipboard((String)this.setPlaceholders(player, player2, this.value)));
                }
            }
        }
        return component;
    }

    public Component build(Player player) {
        TextComponent component = LegacyComponentSerializer.legacyAmpersand().deserialize(this.setPlaceholders(player, this.text));
        if (this.hover != null) {
            component = component.hoverEvent((HoverEventSource)HoverEvent.showText((Component)LegacyComponentSerializer.legacyAmpersand().deserialize(this.setPlaceholders(player, String.join((CharSequence)"\n", this.hover)))));
        }
        if (this.actionType != null) {
            switch (this.actionType) {
                case OPEN_URL: {
                    component = component.clickEvent(ClickEvent.openUrl((String)this.setPlaceholders(player, this.value)));
                    break;
                }
                case SUGGEST_COMMAND: {
                    component = component.clickEvent(ClickEvent.suggestCommand((String)this.setPlaceholders(player, this.value)));
                    break;
                }
                case SUGGEST_CHAT: {
                    component = component.clickEvent(ClickEvent.suggestCommand((String)this.setPlaceholders(player, this.value)));
                    break;
                }
                case CHAT: {
                    component = component.clickEvent(ClickEvent.runCommand((String)this.setPlaceholders(player, this.value)));
                    break;
                }
                case RUN_COMMAND: {
                    component = component.clickEvent(ClickEvent.runCommand((String)this.setPlaceholders(player, this.value)));
                    break;
                }
                case COPY_TO_CLIPBOARD: {
                    component = component.clickEvent(ClickEvent.copyToClipboard((String)this.setPlaceholders(player, this.value)));
                }
            }
        }
        return component;
    }

    private String setPlaceholders(Player player, String text, boolean colorize) {
        if (colorize) {
            return LocalUtils.colorize(this.plugin.getPluginUtils().isPlaceholderApiSupported() ? PlaceholderAPI.setPlaceholders((Player)player, (String)text) : text).replace("{PLAYER}", player.getName());
        }
        return (this.plugin.getPluginUtils().isPlaceholderApiSupported() ? PlaceholderAPI.setPlaceholders((Player)player, (String)text) : text).replace("{PLAYER}", player.getName());
    }

    private String setPlaceholders(Player player, String text) {
        return this.setPlaceholders(player, text, false);
    }

    private String setPlaceholders(Player player1, Player player2, String text, boolean colorize) {
        if (colorize) {
            return LocalUtils.colorize(PlaceholderAPI.setPlaceholders((Player)player1, (String)PlaceholderAPI.setRelationalPlaceholders((Player)player1, (Player)player2, (String)text)).replace("{PLAYER}", player1.getName()));
        }
        return PlaceholderAPI.setPlaceholders((Player)player1, (String)PlaceholderAPI.setRelationalPlaceholders((Player)player1, (Player)player2, (String)text)).replace("{PLAYER}", player1.getName());
    }

    private String setPlaceholders(Player player1, Player player2, String text) {
        return this.setPlaceholders(player1, player2, text, false);
    }
}

