/*
 * Decompiled with CFR 0.152.
 */
package com.alonsoaliaga.alonsojoin.others;

import com.alonsoaliaga.alonsojoin.AlonsoJoin;
import com.alonsoaliaga.alonsojoin.others.CommandData;
import com.alonsoaliaga.alonsojoin.others.PartBuilder;
import com.alonsoaliaga.alonsojoin.utils.LocalUtils;
import com.alonsoaliaga.alonsolib.libraries.adventure.text.Component;
import com.alonsoaliaga.alonsolib.libraries.adventure.text.TextComponent;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import org.bukkit.Sound;
import org.bukkit.entity.Player;

public class JoinMessage {
    private LinkedHashMap<String, PartBuilder> joinParts;
    private LinkedHashMap<String, PartBuilder> quitParts;
    private Sound joinSound = null;
    private Sound quitSound = null;
    private boolean hasJoinSound = false;
    private boolean hasQuitSound = false;
    private String identifier;
    private String permission;
    private List<CommandData> joinActions;
    private List<CommandData> quitActions;
    private boolean relational;

    public JoinMessage(LinkedHashMap<String, PartBuilder> joinParts, LinkedHashMap<String, PartBuilder> quitParts, String identifier, String permission, Sound joinSound, Sound quitSound, List<CommandData> joinActions, List<CommandData> quitActions, boolean relational) {
        this.joinParts = joinParts;
        this.quitParts = quitParts;
        this.joinSound = joinSound;
        this.quitSound = quitSound;
        this.identifier = identifier;
        this.permission = permission;
        this.joinActions = joinActions == null ? new ArrayList() : joinActions;
        this.quitActions = quitActions == null ? new ArrayList() : quitActions;
        this.hasJoinSound = joinSound != null;
        this.hasQuitSound = quitSound != null;
        this.relational = relational;
    }

    public boolean isRelational() {
        return this.relational;
    }

    public Component buildJoinMessage(Player player) {
        if (this.joinParts.isEmpty()) {
            return null;
        }
        TextComponent component = Component.empty();
        for (PartBuilder componentData : this.joinParts.values()) {
            component = component.append(componentData.build(player));
        }
        return component;
    }

    public Component buildJoinMessage(Player player1, Player player2) {
        if (this.joinParts.isEmpty()) {
            return null;
        }
        TextComponent component = Component.empty();
        for (PartBuilder componentData : this.joinParts.values()) {
            component = component.append(componentData.build(player1, player2));
        }
        return component;
    }

    public Component buildQuitMessage(Player player) {
        if (this.joinParts.isEmpty()) {
            return null;
        }
        TextComponent component = Component.empty();
        for (PartBuilder componentData : this.quitParts.values()) {
            component = component.append(componentData.build(player));
        }
        return component;
    }

    public Component buildQuitMessage(Player player1, Player player2) {
        if (this.joinParts.isEmpty()) {
            return null;
        }
        TextComponent component = Component.empty();
        for (PartBuilder componentData : this.quitParts.values()) {
            component = component.append(componentData.build(player1, player2));
        }
        return component;
    }

    public List<CommandData> getJoinActions() {
        return this.joinActions;
    }

    public List<CommandData> getQuitActions() {
        return this.quitActions;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public boolean hasJoinSound() {
        return this.hasJoinSound;
    }

    public boolean hasQuitSound() {
        return this.hasQuitSound;
    }

    public Sound getJoinSound() {
        return this.joinSound;
    }

    public Sound getQuitSound() {
        return this.quitSound;
    }

    public boolean hasPermission() {
        return this.permission != null;
    }

    public boolean hasJoinMessage() {
        return !this.joinParts.isEmpty();
    }

    public boolean hasQuitMessage() {
        return !this.quitParts.isEmpty();
    }

    public boolean hasPermission(Player player) {
        if (AlonsoJoin.getInstance().debugMode) {
            LocalUtils.logp("Player '" + player.getName() + "' " + (this.permission == null || player.hasPermission(this.permission) ? "has" : "doesn't have") + " permission for '" + this.identifier + "' format! Permission is: " + this.permission);
        }
        return this.permission == null || player.hasPermission(this.permission);
    }
}

