/*
 * Decompiled with CFR 0.152.
 */
package com.alonsoaliaga.alonsojoin.others;

import com.alonsoaliaga.alonsojoin.AlonsoJoin;
import com.alonsoaliaga.alonsojoin.utils.LocalUtils;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.java.JavaPlugin;

public class FileManager {
    private JavaPlugin plugin;
    private Configuration configuration;
    private Configuration formats;

    public FileManager(JavaPlugin main) {
        this.plugin = main;
        this.configuration = this.setupConfigFile("config");
        this.formats = this.setupConfigFile("formats");
    }

    private Configuration setupConfigFile(String configName) {
        boolean created;
        File folder = new File(this.plugin.getDataFolder(), "/");
        if (!folder.exists() && (created = folder.mkdir())) {
            LocalUtils.logp("Creating datafolder '/AlonsoJoin/ ..'");
        }
        String fileName = configName.endsWith(".yml") ? configName : configName + ".yml";
        return new Configuration(this.plugin, fileName);
    }

    public Configuration getConfig() {
        return this.configuration;
    }

    public Configuration getFormats() {
        return this.formats;
    }

    private Configuration setupConfigFile(String targetName, String nameInJar, List<String> toRename) {
        File existingFile;
        boolean created;
        File folder = new File(this.plugin.getDataFolder(), "/");
        if (!folder.exists() && (created = folder.mkdir())) {
            LocalUtils.logp("Creating data folder '/AlonsoJoin/ ..'");
        }
        if (!(existingFile = new File(this.plugin.getDataFolder(), targetName)).exists()) {
            for (String name : toRename) {
                existingFile = new File(this.plugin.getDataFolder(), name);
                if (!existingFile.exists()) continue;
                FileManager.renameFile(targetName, name);
                break;
            }
            if (!(existingFile = new File(this.plugin.getDataFolder(), targetName)).exists()) {
                FileManager.copyResource(targetName, nameInJar);
            }
        }
        return new Configuration(this.plugin, targetName);
    }

    public static void renameFile(String targetName, String nameOfFile) {
        File sourceFile;
        File targetFile = new File(AlonsoJoin.getInstance().getDataFolder(), targetName);
        if (!targetFile.exists() && (sourceFile = new File(AlonsoJoin.getInstance().getDataFolder(), nameOfFile)).renameTo(targetFile)) {
            LocalUtils.logp("File '" + nameOfFile + "' renamed to '" + targetName + "'!");
        }
    }

    public static void copyResource(String targetName, String nameInJar) {
        File targetFile = new File(AlonsoJoin.getInstance().getDataFolder(), targetName);
        if (!targetFile.exists()) {
            AlonsoJoin.getInstance().saveResource(nameInJar, false);
            File sourceFile = new File(AlonsoJoin.getInstance().getDataFolder(), nameInJar);
            if (sourceFile.renameTo(targetFile)) {
                LocalUtils.logp("Created '" + targetName + "' file!");
            }
            sourceFile.delete();
        }
    }

    public class Configuration {
        private JavaPlugin plugin;
        private String fileName;
        private FileConfiguration fileConfiguration = null;
        private File file = null;

        public Configuration(JavaPlugin plugin, String name) {
            this.plugin = plugin;
            this.fileName = name.endsWith(".yml") ? name : name + ".yml";
            this.init();
        }

        private void init() {
            this.file = new File(this.plugin.getDataFolder(), this.fileName);
            if (!this.file.exists()) {
                this.plugin.saveResource(this.fileName, false);
            }
            this.fileConfiguration = YamlConfiguration.loadConfiguration((File)this.file);
        }

        public Configuration saveDefaults() {
            this.file = new File(this.plugin.getDataFolder(), this.fileName);
            this.plugin.saveResource(this.fileName, true);
            return this;
        }

        public Configuration save() {
            if (this.fileConfiguration == null || this.file == null) {
                return this;
            }
            try {
                if (this.fileConfiguration.getConfigurationSection("").getKeys(true).size() != 0) {
                    this.fileConfiguration.save(this.file);
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            return this;
        }

        public Configuration reload() {
            if (this.file == null) {
                this.file = new File(this.plugin.getDataFolder(), this.fileName);
            }
            this.fileConfiguration = YamlConfiguration.loadConfiguration((File)this.file);
            return this;
        }

        public String getFileName() {
            return this.fileName;
        }

        public FileConfiguration get() {
            return this.fileConfiguration;
        }
    }
}

