/*
 * Decompiled with CFR 0.152.
 */
package com.alonsoaliaga.alonsojoin.others;

import com.alonsoaliaga.alonsojoin.AlonsoJoin;
import com.alonsoaliaga.alonsojoin.utils.LocalUtils;
import java.io.File;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;

public class Database {
    public static String SQLITE_PLAYERS_QUERY = "";
    public static String MYSQL_PLAYERS_QUERY = "";

    public class MySQL
    implements Data {
        private Connection connection;
        private String host;
        private String database;
        private String username;
        private String password;
        private String table;
        private String query;
        private int port;
        private String additionalQuery;
        private AlonsoJoin plugin;

        public MySQL(AlonsoJoin plugin) {
            this.plugin = plugin;
            this.table = plugin.getFiles().getConfig().get().getString("Database.Table");
            this.query = MYSQL_PLAYERS_QUERY;
            this.additionalQuery = plugin.getFiles().getConfig().get().getString("Database.Additional-url", "");
            this.firstConnection();
        }

        @Override
        public Connection getConnection(boolean log) {
            try {
                if (this.connection == null || this.connection.isClosed()) {
                    Class.forName("com.mysql.jdbc.Driver");
                    if (log) {
                        LocalUtils.logp("[MySQL] Attempting to connect to database..");
                    }
                    this.connection = DriverManager.getConnection(String.format("jdbc:mysql://%s:%s/%s%s", this.host, this.port, this.database, this.additionalQuery), this.username, this.password);
                    if (log) {
                        LocalUtils.logp("[MySQL] Successfully connected to database!");
                    }
                }
                return this.connection;
            }
            catch (ClassNotFoundException e) {
                LocalUtils.logp(String.format("&c%s[MySQL] Drivers for MySQL couldn't be found!", "[AlonsoJoin] "));
                e.printStackTrace();
                return null;
            }
            catch (SQLException e) {
                LocalUtils.log(String.format("&c%s[MySQL] Error connecting to database!", "[AlonsoJoin] "));
                e.printStackTrace();
                return null;
            }
        }

        @Override
        public String getTable() {
            return this.table;
        }

        @Override
        public void closeConnection(boolean log) {
            try {
                if (this.connection != null && !this.connection.isClosed()) {
                    this.connection.close();
                }
                if (log) {
                    LocalUtils.logp("[MySQL] Forcing connection close..");
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }

        @Override
        public void firstConnection() {
            this.host = this.plugin.getFiles().getConfig().get().getString("Database.Host");
            this.port = this.plugin.getFiles().getConfig().get().getInt("Database.Port");
            this.database = this.plugin.getFiles().getConfig().get().getString("Database.Database");
            this.username = this.plugin.getFiles().getConfig().get().getString("Database.Username");
            this.password = this.plugin.getFiles().getConfig().get().getString("Database.Password");
            try {
                LocalUtils.logp(String.format("[MySQL] Attempting to create '%s' table..", this.table));
                PreparedStatement statement = this.getConnection(true).prepareStatement(String.format("CREATE TABLE IF NOT EXISTS %s (%s)", this.table, this.query));
                statement.executeUpdate();
                LocalUtils.logp(String.format("[MySQL] Table '%s' has been created if didn't exist.", this.table));
            }
            catch (SQLException e) {
                LocalUtils.log(String.format("&c%s[MySQL] Error creating '%s' table.", "[AlonsoJoin] ", this.table));
                e.printStackTrace();
            }
        }
    }

    public class SQLite
    implements Data {
        private AlonsoJoin plugin;
        private Connection connection;
        private String database;
        private String table;
        private String url;
        private String query;
        private String additionalQuery;

        public SQLite(AlonsoJoin plugin) {
            this.plugin = plugin;
            this.table = plugin.getFiles().getConfig().get().getString("Database.Table");
            this.query = SQLITE_PLAYERS_QUERY;
            this.additionalQuery = plugin.getFiles().getConfig().get().getString("Database.Additional-url", "");
            this.firstConnection();
        }

        @Override
        public Connection getConnection(boolean log) {
            try {
                if (this.connection == null || this.connection.isClosed()) {
                    Class.forName("org.sqlite.JDBC");
                    if (log) {
                        LocalUtils.log(String.format("[SQLite] Connecting to database '%s'!", this.database));
                    }
                    this.connection = DriverManager.getConnection(this.url);
                    DatabaseMetaData meta = this.connection.getMetaData();
                    if (log) {
                        LocalUtils.log(String.format("[SQLite] Driver available: %s", meta.getDriverName()));
                    }
                    if (log) {
                        LocalUtils.log("[SQLite] Successfully connected to database!");
                    }
                }
                return this.connection;
            }
            catch (ClassNotFoundException e) {
                LocalUtils.log(String.format("&c%s[SQLite] Drivers for SQLite couldn't be found!", "[AlonsoJoin] "));
                e.printStackTrace();
                return null;
            }
            catch (SQLException e) {
                LocalUtils.log(String.format("&c%s[SQLite] Error connecting to database!", "[AlonsoJoin] "));
                e.printStackTrace();
                return null;
            }
        }

        @Override
        public String getTable() {
            return this.table;
        }

        @Override
        public void closeConnection(boolean log) {
            try {
                if (this.connection != null && !this.connection.isClosed()) {
                    this.connection.close();
                }
                if (log) {
                    LocalUtils.log("[SQLite] Forcing connection close..");
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }

        @Override
        public void firstConnection() {
            String dataname = this.plugin.getFiles().getConfig().get().getString("Database.File");
            this.database = dataname.endsWith(".db") ? dataname : dataname + ".db";
            this.url = "jdbc:sqlite:" + this.plugin.getDataFolder() + File.separator + this.database + this.additionalQuery;
            try {
                LocalUtils.logp(String.format("[SQLite] Attempting to create '%s' table..", this.table));
                PreparedStatement statement = this.getConnection(true).prepareStatement(String.format("CREATE TABLE IF NOT EXISTS %s (%s)", this.table, this.query));
                statement.executeUpdate();
                LocalUtils.logp(String.format("[SQLite] Table '%s' has been created if didn't exist.", this.table));
            }
            catch (SQLException e) {
                LocalUtils.log(String.format("&c%s[SQLite] Error creating '%s' table.", "[AlonsoJoin] ", this.table));
                e.printStackTrace();
            }
        }
    }

    public static interface Data {
        public Connection getConnection(boolean var1);

        public String getTable();

        public void closeConnection(boolean var1);

        public void firstConnection();
    }
}

