/*
 * Decompiled with CFR 0.152.
 */
package com.alonsoaliaga.alonsojoin.others;

import com.alonsoaliaga.alonsojoin.AlonsoJoin;
import com.alonsoaliaga.alonsojoin.enums.CommandType;
import com.alonsoaliaga.alonsojoin.others.Sounds;
import com.alonsoaliaga.alonsojoin.utils.AlonsoUtils;
import com.alonsoaliaga.alonsojoin.utils.BungeeUtils;
import com.alonsoaliaga.alonsojoin.utils.LocalUtils;
import com.alonsoaliaga.alonsojoin.utils.ProtocolLibUtils;
import de.tr7zw.nbtapi.NBTCompound;
import de.tr7zw.nbtapi.NBTContainer;
import de.tr7zw.nbtapi.NBTItem;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.FireworkEffect;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.SoundCategory;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Firework;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class CommandData {
    private AlonsoJoin plugin = AlonsoJoin.getInstance();
    private BungeeBroadcastData bungeeBroadcastData = null;
    private String command;
    private String title = "";
    private String subtitle = "";
    private CommandType commandType;
    private Sound sound = null;
    private String customSound = null;
    private List<FireworkEffect> fireWorkEffects = new ArrayList<FireworkEffect>();
    private float volume = 1.0f;
    private float pitch = 1.0f;
    private CommandType.VanishType vanishType;
    private CommandType.ConnectionType connectionType;
    private String bookData = null;
    private SoundCategory soundCategory;
    private boolean soundCategorySpecified = false;
    private int power = 1;
    private int delay = 5;
    private final Pattern SERVER_WORLD_PATTERN = Pattern.compile(",(?=[^)]*(?:\\(|$))");
    private final Pattern SERVER_WORLD_FULL_PATTERN = Pattern.compile(",(?=[^(\\]|))]*(?:[(|\\[]|$))");

    public CommandData(String command, CommandType commandType, CommandType.ConnectionType connectionType) {
        this.command = command.trim();
        this.commandType = commandType == null ? CommandType.PLAYER : commandType;
        this.connectionType = connectionType;
        if (this.process()) {
            if (this.plugin.debugMode) {
                LocalUtils.logp("Successfully loaded command '" + this.command + "&r&7' with type '" + this.commandType.name() + "'!");
            }
        } else if (this.plugin.debugMode) {
            LocalUtils.logp("Couldn't load command '" + this.command + "&r&7' with type '" + this.commandType.name() + "'!");
        }
    }

    private boolean process() {
        if (this.commandType == CommandType.SOUND_BROADCAST || this.commandType == CommandType.SOUND || this.commandType == CommandType.SOUND_WORLD_BROADCAST) {
            String[] args = this.command.split(",");
            this.sound = LocalUtils.getSound(args[0].trim(), Sounds.LEVEL_UP.getSound());
            if (args.length >= 2) {
                try {
                    this.volume = Float.parseFloat(args[1].trim());
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if (args.length >= 3) {
                    try {
                        this.pitch = Float.parseFloat(args[2].trim());
                    }
                    catch (Throwable throwable) {}
                }
            }
        } else if (this.commandType == CommandType.CUSTOM_SOUND_BROADCAST || this.commandType == CommandType.CUSTOM_SOUND || this.commandType == CommandType.CUSTOM_SOUND_WORLD_BROADCAST) {
            String[] args = this.command.split(",");
            this.customSound = args[0];
            if (args.length >= 2) {
                try {
                    this.volume = Float.parseFloat(args[1].trim());
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if (args.length >= 3) {
                    try {
                        this.pitch = Float.parseFloat(args[2].trim());
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    if (args.length >= 4 && LocalUtils.isSoundCategoryAvailable()) {
                        try {
                            this.soundCategory = SoundCategory.valueOf((String)args[3]);
                            this.soundCategorySpecified = true;
                        }
                        catch (Throwable throwable) {}
                    }
                }
            }
        } else if (this.commandType == CommandType.TITLE || this.commandType == CommandType.TITLE_BROADCAST || this.commandType == CommandType.TITLE_WORLD_BROADCAST) {
            String[] parts = this.command.split("(?i)<SEPARATOR>");
            this.title = parts[0];
            if (parts.length >= 2) {
                this.subtitle = parts[1];
            }
        } else {
            if (this.commandType == CommandType.BOOK) {
                this.bookData = this.plugin.booksMap.get(this.command.toLowerCase().replace(".yml", ""));
                return this.bookData != null;
            }
            if (this.commandType == CommandType.FIREWORK) {
                String[] parts;
                for (String part : parts = this.command.split("\\|")) {
                    if (part.matches("(?i)^power=\\d+$")) {
                        try {
                            this.power = Math.max(0, Math.min(20, Integer.valueOf(part.replaceAll("(?i)^power=\\d+$", ""))));
                        }
                        catch (Throwable e) {
                            this.power = 1;
                        }
                        continue;
                    }
                    if (part.matches("(?i)^delay=\\d+$")) {
                        try {
                            this.delay = Math.max(0, Math.min(100, Integer.valueOf(part.replaceAll("(?i)^delay=\\d+$", ""))));
                        }
                        catch (Throwable e) {
                            this.delay = 1;
                        }
                        continue;
                    }
                    FireworkEffect.Builder builder = FireworkEffect.builder();
                    FireworkEffect.Type type = null;
                    Color color = null;
                    Color fadeColor = null;
                    boolean flicker = false;
                    boolean trail = false;
                    String[] data = part.split(":");
                    if (data.length >= 1) {
                        try {
                            type = FireworkEffect.Type.valueOf((String)data[0]);
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        if (data.length >= 2) {
                            color = LocalUtils.getColor(data[1]);
                            if (data.length >= 3) {
                                try {
                                    fadeColor = LocalUtils.getColor(data[2]);
                                }
                                catch (Throwable throwable) {
                                    // empty catch block
                                }
                                if (data.length >= 4) {
                                    boolean bl = flicker = data[3].equalsIgnoreCase("true") || data[3].equalsIgnoreCase("yes") || data[3].equalsIgnoreCase("flicker");
                                    if (data.length >= 5) {
                                        boolean bl2 = trail = data[4].equalsIgnoreCase("true") || data[4].equalsIgnoreCase("yes") || data[4].equalsIgnoreCase("trail");
                                    }
                                }
                            }
                        }
                    }
                    if (type != null) {
                        builder.with(type);
                    } else {
                        builder.with(FireworkEffect.Type.CREEPER);
                    }
                    if (color != null) {
                        builder.withColor(color);
                    } else {
                        builder.withColor(Color.WHITE);
                    }
                    if (fadeColor != null) {
                        builder.withFade(fadeColor);
                    } else {
                        builder.withFade(Color.WHITE);
                    }
                    builder.flicker(flicker).trail(trail);
                    this.fireWorkEffects.add(builder.build());
                    if (this.plugin.debugMode) {
                        LocalUtils.logp("Type: " + (type == null ? type : type.name()) + " | Color: " + (color == null ? color : Integer.valueOf(color.asRGB())) + " | Fade color:" + (fadeColor == null ? fadeColor : fadeColor.asRGB() + " | Flicker: " + flicker + " | Trail: " + trail));
                    }
                    if (!this.plugin.debugMode) continue;
                    LocalUtils.logp("Successfully built firework(" + builder.build().toString() + ").");
                }
                LocalUtils.logp("Successfully loaded " + this.fireWorkEffects.size() + " effects for fireworks!");
            } else if (this.commandType == CommandType.BUNGEE_BROADCAST) {
                String[] parts = this.command.split("<SEPARATOR>");
                HashMap<String, List<String>> serversMap = new HashMap<String, List<String>>();
                String onceString = "false";
                String soundString = "";
                String messageString = "";
                block23: for (String part : parts) {
                    if (part.startsWith("once=")) {
                        onceString = String.valueOf(part.substring(5).equalsIgnoreCase("true"));
                        continue;
                    }
                    if (part.startsWith("servers=")) {
                        for (String serverString : this.SERVER_WORLD_FULL_PATTERN.split(part.substring(8))) {
                            if (serverString.isEmpty()) continue;
                            if (serverString.contains("(")) {
                                String clearServersString;
                                int index;
                                String serverName;
                                if (!serverString.endsWith(")") || (serverName = serverString.substring(0, index = serverString.indexOf("("))).isEmpty()) continue;
                                String worldsPart = serverString.substring(index);
                                ArrayList worlds = new ArrayList();
                                if (worldsPart.length() > 2) {
                                    Collections.addAll(worlds, worldsPart.substring(1, worldsPart.length() - 1).split(","));
                                }
                                if ((clearServersString = serverName.replace("[", "").replace("]", "")).equalsIgnoreCase("all")) {
                                    serversMap.put("all", worlds);
                                    continue block23;
                                }
                                serversMap.put(clearServersString, worlds);
                                continue;
                            }
                            String clearServersString = serverString.replace("[", "").replace("]", "");
                            if (clearServersString.equals("all")) {
                                serversMap.put("all", new ArrayList());
                                continue block23;
                            }
                            serversMap.put(clearServersString, new ArrayList());
                        }
                        continue;
                    }
                    if (part.startsWith("sound=")) {
                        String[] partsSound;
                        String soundToParse = part.substring(6);
                        if (soundToParse.isEmpty() || (partsSound = soundToParse.split(","))[0].isEmpty()) continue;
                        double volume = 1.0;
                        double pitch = 1.0;
                        if (partsSound.length >= 2) {
                            try {
                                volume = Double.parseDouble(partsSound[1]);
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                            if (partsSound.length >= 3) {
                                try {
                                    pitch = Double.parseDouble(partsSound[2]);
                                }
                                catch (Throwable throwable) {
                                    // empty catch block
                                }
                            }
                        }
                        soundString = partsSound[0] + "," + volume + "," + pitch;
                        continue;
                    }
                    messageString = part;
                }
                if (!serversMap.isEmpty()) {
                    this.bungeeBroadcastData = new BungeeBroadcastData(onceString, serversMap, soundString, messageString);
                } else if (this.plugin.debugMode) {
                    LocalUtils.logp("Couldn't find servers specified in the command for [BUNGEE_BROADCAST] type. Skipping..");
                }
            }
        }
        return true;
    }

    public CommandData(String command) {
        this.command = command.trim();
        this.vanishType = CommandType.VanishType.getFromCommand(this.command);
        this.command = this.vanishType == null ? this.command : this.command.substring(this.vanishType.getToRemove().length());
        this.vanishType = this.vanishType == null ? CommandType.VanishType.ALWAYS : this.vanishType;
        this.connectionType = CommandType.ConnectionType.getFromCommand(this.command);
        this.command = this.connectionType == null ? this.command : this.command.substring(this.connectionType.getToRemove().length());
        this.connectionType = this.connectionType == null ? CommandType.ConnectionType.NORMAL : this.connectionType;
        this.commandType = CommandType.getFromCommand(this.command);
        this.command = this.commandType == null ? this.command : this.command.substring(this.commandType.getToRemove().length());
        CommandType commandType = this.commandType = this.commandType == null ? CommandType.PLAYER : this.commandType;
        if (this.process()) {
            if (this.plugin.debugMode) {
                LocalUtils.logp("Successfully loaded command '" + this.command + "&r&7' with type '" + this.commandType.name() + "'!");
            }
        } else if (this.plugin.debugMode) {
            LocalUtils.logp("Couldn't load command '" + this.command + "&r&7' with type '" + this.commandType.name() + "'!");
        }
    }

    /*
     * Unable to fully structure code
     */
    public void performCommand(@Nonnull Player player) {
        if (player.hasPlayedBefore() != false ? this.connectionType == CommandType.ConnectionType.FIRST_JOIN : this.connectionType == CommandType.ConnectionType.KNOWN_PLAYER) {
            return;
        }
        switch (1.$SwitchMap$com$alonsoaliaga$alonsojoin$enums$CommandType[this.commandType.ordinal()]) {
            case 1: {
                player.performCommand(LocalUtils.setPlaceholders(player, this.command));
                break;
            }
            case 2: {
                finalCommand = LocalUtils.setPlaceholders(player, this.command);
                if (player.isOp()) {
                    player.performCommand(finalCommand);
                    break;
                }
                player.setOp(true);
                try {
                    player.performCommand(finalCommand);
                    player.setOp(false);
                }
                catch (Throwable e) {
                    player.setOp(false);
                    LocalUtils.logp("Error running '" + finalCommand + "' as OP! Removing OP..");
                    e.printStackTrace();
                }
                break;
            }
            case 3: {
                Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)LocalUtils.setPlaceholders(player, this.command));
                break;
            }
            case 4: {
                player.sendMessage(LocalUtils.colorize(LocalUtils.setPlaceholders(player, this.command)));
                break;
            }
            case 5: {
                player.chat(LocalUtils.setPlaceholders(player, this.command));
                break;
            }
            case 6: {
                Bukkit.broadcastMessage((String)LocalUtils.colorize(LocalUtils.setPlaceholders(player, this.command)));
                break;
            }
            case 7: {
                message = LocalUtils.colorize(LocalUtils.setPlaceholders(player, this.command));
                for (Player worldPlayer : player.getWorld().getPlayers()) {
                    worldPlayer.sendMessage(message);
                }
                break;
            }
            case 8: {
                player.playSound(player.getLocation(), this.sound, this.volume, this.pitch);
                break;
            }
            case 9: {
                for (Player onlinePlayer : Bukkit.getOnlinePlayers()) {
                    onlinePlayer.playSound(onlinePlayer.getLocation(), this.sound, this.volume, this.pitch);
                }
                break;
            }
            case 10: {
                for (Player worldPlayer : player.getWorld().getPlayers()) {
                    worldPlayer.playSound(worldPlayer.getLocation(), this.sound, this.volume, this.pitch);
                }
                break;
            }
            case 11: {
                if (LocalUtils.isSoundCategoryAvailable() && this.soundCategorySpecified) {
                    player.playSound(player.getLocation(), this.customSound, this.soundCategory, this.volume, this.pitch);
                    break;
                }
                player.playSound(player.getLocation(), this.customSound, this.volume, this.pitch);
                break;
            }
            case 12: {
                if (LocalUtils.isSoundCategoryAvailable() && this.soundCategorySpecified) {
                    for (Player onlinePlayer : Bukkit.getOnlinePlayers()) {
                        onlinePlayer.playSound(onlinePlayer.getLocation(), this.customSound, this.soundCategory, this.volume, this.pitch);
                    }
                } else {
                    for (Player onlinePlayer : Bukkit.getOnlinePlayers()) {
                        onlinePlayer.playSound(onlinePlayer.getLocation(), this.customSound, this.volume, this.pitch);
                    }
                }
                break;
            }
            case 13: {
                if (LocalUtils.isSoundCategoryAvailable() && this.soundCategorySpecified) {
                    for (Player worldPlayer : player.getWorld().getPlayers()) {
                        worldPlayer.playSound(worldPlayer.getLocation(), this.customSound, this.soundCategory, this.volume, this.pitch);
                    }
                } else {
                    for (Player worldPlayer : player.getWorld().getPlayers()) {
                        worldPlayer.playSound(worldPlayer.getLocation(), this.customSound, this.volume, this.pitch);
                    }
                }
                break;
            }
            case 14: {
                LocalUtils.sendTitle(player, LocalUtils.setPlaceholders(player, this.title), LocalUtils.setPlaceholders(player, this.subtitle));
                break;
            }
            case 15: {
                LocalUtils.sendTitle(Bukkit.getOnlinePlayers(), LocalUtils.setPlaceholders(player, this.title), LocalUtils.setPlaceholders(player, this.subtitle));
                break;
            }
            case 16: {
                LocalUtils.sendTitle(player.getWorld().getPlayers(), LocalUtils.setPlaceholders(player, this.title), LocalUtils.setPlaceholders(player, this.subtitle));
                break;
            }
            case 17: {
                if (!BungeeUtils.isAvailable()) {
                    if (!this.plugin.debugMode) break;
                    LocalUtils.logp("Bungee message system is not available. Ignoring..");
                    break;
                }
                b = new ByteArrayOutputStream();
                out = new DataOutputStream(b);
                try {
                    out.writeUTF("AlonsoJoin");
                    out.writeUTF("BUNGEE_CONSOLE");
                    out.writeUTF(player.getName());
                    out.writeUTF(LocalUtils.setPlaceholders(player, this.command));
                }
                catch (IOException e) {
                    if (!this.plugin.debugMode) ** GOTO lbl109
                    LocalUtils.logp("Error writing UTF for BUNGEE_CONSOLE. Debug mode is enabled: " + e.getMessage());
                }
lbl109:
                // 3 sources

                BungeeUtils.sendBungeeMessage(player, b.toByteArray());
                break;
            }
            case 18: {
                if (!BungeeUtils.isAvailable()) {
                    if (!this.plugin.debugMode) break;
                    LocalUtils.logp("Bungee message system is not available. Ignoring..");
                    break;
                }
                b = new ByteArrayOutputStream();
                out = new DataOutputStream(b);
                try {
                    out.writeUTF("AlonsoJoin");
                    out.writeUTF("BUNGEE_PLAYER_CHAT");
                    out.writeUTF(player.getName());
                    out.writeUTF(LocalUtils.setPlaceholders(player, this.command));
                }
                catch (IOException e) {
                    if (!this.plugin.debugMode) ** GOTO lbl127
                    LocalUtils.logp("Error writing UTF for BUNGEE_PLAYER_CHAT. Debug mode is enabled: " + e.getMessage());
                }
lbl127:
                // 3 sources

                BungeeUtils.sendBungeeMessage(player, b.toByteArray());
                break;
            }
            case 19: {
                if (!BungeeUtils.isAvailable()) {
                    if (!this.plugin.debugMode) break;
                    LocalUtils.logp("Bungee message system is not available. Ignoring..");
                    break;
                }
                b = new ByteArrayOutputStream();
                out = new DataOutputStream(b);
                try {
                    out.writeUTF("AlonsoJoin");
                    out.writeUTF("BUNGEE_PLAYER_COMMAND");
                    out.writeUTF(player.getName());
                    out.writeUTF(LocalUtils.setPlaceholders(player, this.command));
                }
                catch (IOException e) {
                    if (!this.plugin.debugMode) ** GOTO lbl145
                    LocalUtils.logp("Error writing UTF for BUNGEE_PLAYER_COMMAND. Debug mode is enabled: " + e.getMessage());
                }
lbl145:
                // 3 sources

                BungeeUtils.sendBungeeMessage(player, b.toByteArray());
                break;
            }
            case 20: {
                if (!BungeeUtils.isAvailable()) {
                    if (!this.plugin.debugMode) break;
                    LocalUtils.logp("Bungee message system is not available. Ignoring..");
                    break;
                }
                if (this.bungeeBroadcastData == null) {
                    if (!this.plugin.debugMode) break;
                    LocalUtils.logp("BungeeBroadcastData is null so it wasn't loaded correctly. Ignoring..");
                    break;
                }
                b = new ByteArrayOutputStream();
                out = new DataOutputStream(b);
                try {
                    out.writeUTF("AlonsoJoin");
                    out.writeUTF("BUNGEE_BROADCAST");
                    out.writeUTF(player.getName());
                    out.writeUTF(BungeeBroadcastData.access$000(this.bungeeBroadcastData));
                    out.writeUTF(BungeeBroadcastData.access$100(this.bungeeBroadcastData));
                    out.writeUTF(BungeeBroadcastData.access$200(this.bungeeBroadcastData));
                    out.writeUTF(LocalUtils.setPlaceholders(player, BungeeBroadcastData.access$300(this.bungeeBroadcastData)));
                }
                catch (IOException e) {
                    if (!this.plugin.debugMode) ** GOTO lbl170
                    LocalUtils.logp("Error writing UTF for BUNGEE_BROADCAST. Debug mode is enabled: " + e.getMessage());
                }
lbl170:
                // 3 sources

                BungeeUtils.sendBungeeMessage(player, b.toByteArray());
                break;
            }
            case 21: {
                LocalUtils.sendActionBar((AlonsoUtils.AlonsoPlugin)this.plugin, player, LocalUtils.setPlaceholders(player, this.command));
                break;
            }
            case 22: {
                LocalUtils.sendActionBar(this.plugin, Bukkit.getOnlinePlayers(), LocalUtils.setPlaceholders(player, this.command));
                break;
            }
            case 23: {
                LocalUtils.sendActionBar(this.plugin, player.getWorld().getPlayers(), LocalUtils.setPlaceholders(player, this.command));
                break;
            }
            case 24: {
                firework = (Firework)player.getWorld().spawn(player.getLocation().add(0.0, 1.0, 0.0), Firework.class);
                fireworkMeta = firework.getFireworkMeta();
                fireworkMeta.addEffects(this.fireWorkEffects);
                firework.setFireworkMeta(fireworkMeta);
                fireworkMeta.setPower(this.power);
                if (this.delay == 0) {
                    firework.detonate();
                    break;
                }
                Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, (Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, lambda$performCommand$0(org.bukkit.entity.Firework ), ()V)((Firework)firework), (long)this.delay);
                break;
            }
            case 25: {
                if (this.plugin.debugMode) {
                    LocalUtils.logp("ProtocolLib is supported: " + AlonsoUtils.PluginUtils.hasProtocolLibSupport());
                }
                if (!AlonsoUtils.PluginUtils.hasProtocolLibSupport()) break;
                ProtocolLibUtils.sendJSON(player, LocalUtils.setPlaceholders(player, this.command));
                break;
            }
            case 26: {
                if (this.plugin.debugMode) {
                    LocalUtils.logp("ProtocolLib is supported: " + AlonsoUtils.PluginUtils.hasProtocolLibSupport());
                }
                if (!AlonsoUtils.PluginUtils.hasProtocolLibSupport()) break;
                ProtocolLibUtils.sendJSON(LocalUtils.setPlaceholders(player, this.command));
                break;
            }
            case 27: {
                if (this.plugin.debugMode) {
                    LocalUtils.logp("ProtocolLib is supported: " + AlonsoUtils.PluginUtils.hasProtocolLibSupport());
                }
                if (!AlonsoUtils.PluginUtils.hasProtocolLibSupport()) break;
                ProtocolLibUtils.sendJSON(player.getWorld().getPlayers(), LocalUtils.setPlaceholders(player, this.command));
                break;
            }
            case 28: {
                if (!BungeeUtils.isAvailable()) {
                    if (!this.plugin.debugMode) break;
                    LocalUtils.logp("Bungee message system is not available. Ignoring..");
                    break;
                }
                b = new ByteArrayOutputStream();
                out = new DataOutputStream(b);
                try {
                    out.writeUTF("Connect");
                    out.writeUTF(this.command);
                }
                catch (IOException e) {
                    if (!this.plugin.debugMode) ** GOTO lbl225
                    LocalUtils.logp("Error writing UTF for 'BUNGEE_CONNECT'. Debug mode is enabled: " + e.getMessage());
                }
lbl225:
                // 3 sources

                BungeeUtils.sendCustomBungeeMessage(player, "BungeeCord", b.toByteArray());
                break;
            }
            case 29: {
                if (!BungeeUtils.isAvailable()) {
                    if (!this.plugin.debugMode) break;
                    LocalUtils.logp("Bungee message system is not available. Ignoring..");
                    break;
                }
                b = new ByteArrayOutputStream();
                out = new DataOutputStream(b);
                try {
                    out.writeUTF("KickPlayer");
                    out.writeUTF(player.getName());
                    out.writeUTF(LocalUtils.setPlaceholders(player, this.command));
                }
                catch (IOException e) {
                    if (!this.plugin.debugMode) ** GOTO lbl242
                    LocalUtils.logp("Error writing UTF for 'BUNGEE_KICK'. Debug mode is enabled: " + e.getMessage());
                }
lbl242:
                // 3 sources

                BungeeUtils.sendCustomBungeeMessage(player, "BungeeCord", b.toByteArray());
                break;
            }
            case 30: {
                player.closeInventory();
                break;
            }
            case 31: {
                player.leaveVehicle();
                break;
            }
            case 32: {
                if (!AlonsoUtils.PluginUtils.hasNbtApiSupport() || this.bookData == null) break;
                try {
                    bookItem = new ItemStack(Material.WRITTEN_BOOK);
                    nbtItem = new NBTItem(bookItem, true);
                    nbtItem.mergeCompound((NBTCompound)new NBTContainer(LocalUtils.setPlaceholders(player, this.bookData)));
                    if (LocalUtils.openBook(player, bookItem)) break;
                    LocalUtils.logp("Custom book couldn't be sent, make sure you have required dependencies. Join our discord server for support!");
                    break;
                }
                catch (Throwable e) {
                    if (this.plugin.debugMode) {
                        LocalUtils.logp("Error creating custom book! You are reading the next stacktrace because debug mode is enabled.");
                        e.printStackTrace();
                        break;
                    }
                    LocalUtils.logp("Error creating custom book! Error: " + e.getMessage());
                }
            }
        }
    }

    public CommandType getCommandType() {
        return this.commandType;
    }

    public CommandType.ConnectionType getConnectionType() {
        return this.connectionType;
    }

    public CommandType.VanishType getVanishType() {
        return this.vanishType;
    }

    private static /* synthetic */ void lambda$performCommand$0(Firework firework) {
        if (!firework.isDead() && firework.isValid()) {
            firework.detonate();
        }
    }

    public static class BungeeBroadcastData {
        private String onceString;
        private String soundString;
        private String messageString;
        private String serversString;

        public BungeeBroadcastData(String onceString, HashMap<String, List<String>> serversMap, String soundString, String messageString) {
            this.onceString = onceString;
            this.soundString = soundString;
            this.messageString = messageString;
            ArrayList<String> toJoin = new ArrayList<String>();
            for (Map.Entry<String, List<String>> entry : serversMap.entrySet()) {
                if (entry.getValue().isEmpty()) {
                    toJoin.add(entry.getKey());
                    continue;
                }
                toJoin.add(entry.getKey() + "=" + String.join((CharSequence)",", (Iterable<? extends CharSequence>)entry.getValue()));
            }
            this.serversString = String.join((CharSequence)"|", toJoin);
        }

        static /* synthetic */ String access$000(BungeeBroadcastData x0) {
            return x0.onceString;
        }

        static /* synthetic */ String access$100(BungeeBroadcastData x0) {
            return x0.serversString;
        }

        static /* synthetic */ String access$200(BungeeBroadcastData x0) {
            return x0.soundString;
        }

        static /* synthetic */ String access$300(BungeeBroadcastData x0) {
            return x0.messageString;
        }
    }
}

