/*
 * Decompiled with CFR 0.152.
 */
package com.alonsoaliaga.alonsojoin.listeners;

import com.alonsoaliaga.alonsojoin.AlonsoJoin;
import com.alonsoaliaga.alonsojoin.enums.CommandType;
import com.alonsoaliaga.alonsojoin.others.CommandData;
import com.alonsoaliaga.alonsojoin.others.JoinMessage;
import com.alonsoaliaga.alonsojoin.utils.AdventureUtils;
import com.alonsoaliaga.alonsojoin.utils.LocalUtils;
import com.alonsoaliaga.alonsolib.libraries.adventure.text.Component;
import fr.xephi.authme.api.v3.AuthMeApi;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nonnull;
import me.clip.placeholderapi.PlaceholderAPI;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;

public class ConnectionListener
implements Listener {
    private AlonsoJoin plugin;
    public HashMap<UUID, BukkitTask> loginMap = new HashMap();

    public ConnectionListener(AlonsoJoin plugin) {
        this.plugin = plugin;
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
        this.reloadMessages();
    }

    public void reloadMessages() {
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onQuit(PlayerQuitEvent e) {
        if (this.plugin.mainCommand.testingMap.containsKey(e.getPlayer().getUniqueId())) {
            if (this.plugin.debugMode) {
                LocalUtils.logp("[QUIT] Player " + e.getPlayer().getName() + " left the server and was in testingMap. Removing..");
            }
            this.plugin.mainCommand.testingMap.remove(e.getPlayer().getUniqueId()).cancel();
        }
        if (this.plugin.removeQuitDefault) {
            e.setQuitMessage(null);
        }
        if (this.loginMap.containsKey(e.getPlayer().getUniqueId())) {
            if (this.plugin.debugMode) {
                LocalUtils.logp("[QUIT] Player " + e.getPlayer().getName() + " left the server but was in loginMap. Removing and skipping..");
            }
            this.loginMap.remove(e.getPlayer().getUniqueId()).cancel();
            return;
        }
        if (this.plugin.authMeSupport && !AuthMeApi.getInstance().isAuthenticated(e.getPlayer())) {
            if (this.plugin.debugMode) {
                LocalUtils.logp("[QUIT] Player " + e.getPlayer().getName() + " left the server but wasn't logged. Skipping..");
            }
            return;
        }
        this.startQuitProcess(e.getPlayer());
    }

    public void startQuitProcess(Player player) {
        this.startQuitProcess(player, false);
    }

    public void startQuitProcess(Player player, boolean ignoreExceptions) {
        for (Map.Entry<String, JoinMessage> entry : this.plugin.joinMessagesMap.entrySet()) {
            boolean shouldSendMessage;
            if (!entry.getValue().hasPermission(player)) continue;
            if (!player.isOnline()) {
                if (!this.plugin.debugMode) break;
                LocalUtils.logp("[QUIT] Player " + player.getName() + " has permission for " + entry.getValue().getIdentifier() + " format but is not online anymore.");
                break;
            }
            boolean bl = shouldSendMessage = ignoreExceptions || !this.isInvisible(player);
            if (!shouldSendMessage && this.plugin.notifySilentJoin) {
                player.sendMessage(LocalUtils.setPlaceholders(player, this.plugin.messages.joinInSilenceNotification).replace("<NEW-LINE>", "\n"));
            }
            this.performQuitMessage(player, entry.getValue(), shouldSendMessage);
            break;
        }
    }

    public void performQuitMessage(Player player, JoinMessage joinMessage) {
        this.performQuitMessage(player, joinMessage, false);
    }

    public void performQuitMessage(Player player, JoinMessage joinMessage, boolean isAsync) {
        this.performQuitMessage(player, joinMessage, isAsync, true);
    }

    public void performQuitMessage(Player player, JoinMessage joinMessage, boolean isAsync, boolean shouldSendMessage) {
        block43: {
            if (shouldSendMessage) {
                Component component;
                Iterator<String> worldPlayersNames;
                Component component2;
                ArrayList<String> worldPlayersNames2;
                if (this.plugin.whitelistMode) {
                    Component component3;
                    if (joinMessage.hasQuitSound()) {
                        if (joinMessage.isRelational() && this.plugin.getPluginUtils().isPlaceholderApiSupported()) {
                            worldPlayersNames2 = new ArrayList<String>();
                            for (World world : this.plugin.getServer().getWorlds()) {
                                if (!this.plugin.whitelistedWorlds.contains(world.getName())) continue;
                                for (Player worldPlayer : world.getPlayers()) {
                                    component3 = joinMessage.buildQuitMessage(player, worldPlayer);
                                    AdventureUtils.player(worldPlayer).sendMessage(component3);
                                    worldPlayer.playSound(worldPlayer.getLocation(), joinMessage.getQuitSound(), 1.0f, 1.0f);
                                    if (!this.plugin.debugMode) continue;
                                    worldPlayersNames2.add(worldPlayer.getName());
                                }
                            }
                            if (this.plugin.debugMode) {
                                LocalUtils.logp("[1] Sending quit message component to (" + worldPlayersNames2.size() + ") players: " + String.join((CharSequence)",", worldPlayersNames2) + "!");
                            }
                        } else {
                            component2 = joinMessage.buildQuitMessage(player);
                            worldPlayersNames = new ArrayList();
                            for (Object world : this.plugin.getServer().getWorlds()) {
                                if (!this.plugin.whitelistedWorlds.contains(world.getName())) continue;
                                for (Player worldPlayer : world.getPlayers()) {
                                    AdventureUtils.player(worldPlayer).sendMessage(component2);
                                    worldPlayer.playSound(worldPlayer.getLocation(), joinMessage.getQuitSound(), 1.0f, 1.0f);
                                    if (!this.plugin.debugMode) continue;
                                    worldPlayersNames.add(worldPlayer.getName());
                                }
                            }
                            if (this.plugin.debugMode) {
                                LocalUtils.logp("[2] Sending quit message component to (" + worldPlayersNames.size() + ") players: " + String.join((CharSequence)",", worldPlayersNames) + "!");
                            }
                        }
                    } else if (joinMessage.isRelational() && this.plugin.getPluginUtils().isPlaceholderApiSupported()) {
                        worldPlayersNames2 = new ArrayList();
                        for (World world : this.plugin.getServer().getWorlds()) {
                            if (!this.plugin.whitelistedWorlds.contains(world.getName())) continue;
                            for (Player worldPlayer : world.getPlayers()) {
                                component3 = joinMessage.buildQuitMessage(player, worldPlayer);
                                AdventureUtils.player(worldPlayer).sendMessage(component3);
                                if (!this.plugin.debugMode) continue;
                                worldPlayersNames2.add(worldPlayer.getName());
                            }
                        }
                        if (this.plugin.debugMode) {
                            LocalUtils.logp("[3] Sending quit message component to (" + worldPlayersNames2.size() + ") players: " + String.join((CharSequence)",", worldPlayersNames2) + "!");
                        }
                    } else {
                        component2 = joinMessage.buildQuitMessage(player);
                        worldPlayersNames = new ArrayList();
                        for (Object world : this.plugin.getServer().getWorlds()) {
                            if (!this.plugin.whitelistedWorlds.contains(world.getName())) continue;
                            for (Player worldPlayer : world.getPlayers()) {
                                AdventureUtils.player(worldPlayer).sendMessage(component2);
                                if (!this.plugin.debugMode) continue;
                                worldPlayersNames.add(worldPlayer.getName());
                            }
                        }
                        if (this.plugin.debugMode) {
                            LocalUtils.logp("[4] Sending quit message component to (" + worldPlayersNames.size() + ") players: " + String.join((CharSequence)",", worldPlayersNames) + "!");
                        }
                    }
                } else if (joinMessage.hasQuitSound()) {
                    if (joinMessage.isRelational() && this.plugin.getPluginUtils().isPlaceholderApiSupported()) {
                        worldPlayersNames2 = new ArrayList();
                        for (Player worldPlayer : this.plugin.getServer().getOnlinePlayers()) {
                            component = joinMessage.buildQuitMessage(player, worldPlayer);
                            if (component != null) {
                                AdventureUtils.player(worldPlayer).sendMessage(component);
                            }
                            worldPlayer.playSound(worldPlayer.getLocation(), joinMessage.getQuitSound(), 1.0f, 1.0f);
                            if (!this.plugin.debugMode) continue;
                            worldPlayersNames2.add(worldPlayer.getName());
                        }
                        if (this.plugin.debugMode) {
                            LocalUtils.logp("[5] Sending quit message component to (" + worldPlayersNames2.size() + ") players: " + String.join((CharSequence)",", worldPlayersNames2) + "!");
                        }
                    } else {
                        component2 = joinMessage.buildQuitMessage(player);
                        worldPlayersNames = new ArrayList();
                        for (Player worldPlayer : this.plugin.getServer().getOnlinePlayers()) {
                            if (component2 != null) {
                                AdventureUtils.player(worldPlayer).sendMessage(component2);
                            }
                            worldPlayer.playSound(worldPlayer.getLocation(), joinMessage.getQuitSound(), 1.0f, 1.0f);
                            if (!this.plugin.debugMode) continue;
                            worldPlayersNames.add(worldPlayer.getName());
                        }
                        if (this.plugin.debugMode) {
                            LocalUtils.logp("[6] Sending quit message component to (" + worldPlayersNames.size() + ") players: " + String.join((CharSequence)",", worldPlayersNames) + "!");
                        }
                    }
                } else if (joinMessage.hasQuitMessage()) {
                    if (joinMessage.isRelational() && this.plugin.getPluginUtils().isPlaceholderApiSupported()) {
                        worldPlayersNames2 = new ArrayList();
                        for (Player worldPlayer : this.plugin.getServer().getOnlinePlayers()) {
                            component = joinMessage.buildQuitMessage(player, worldPlayer);
                            AdventureUtils.player(worldPlayer).sendMessage(component);
                            if (!this.plugin.debugMode) continue;
                            worldPlayersNames2.add(worldPlayer.getName());
                        }
                        if (this.plugin.debugMode) {
                            LocalUtils.logp("[5] Sending quit message component to (" + worldPlayersNames2.size() + ") players: " + String.join((CharSequence)",", worldPlayersNames2) + "!");
                        }
                    } else {
                        component2 = joinMessage.buildQuitMessage(player);
                        AdventureUtils.players().sendMessage(component2);
                        if (this.plugin.debugMode) {
                            LocalUtils.logp("[8] Sending quit message to all online players!");
                        }
                    }
                }
            }
            if (joinMessage.getQuitActions().isEmpty()) break block43;
            if (isAsync) {
                Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
                    if (!shouldSendMessage) {
                        for (CommandData quitAction : joinMessage.getQuitActions()) {
                            if (quitAction.getVanishType() != CommandType.VanishType.ALWAYS && quitAction.getVanishType() != CommandType.VanishType.ONLY_VANISH) continue;
                            quitAction.performCommand(player);
                        }
                    } else {
                        for (CommandData quitAction : joinMessage.getQuitActions()) {
                            if (quitAction.getVanishType() != CommandType.VanishType.ALWAYS && quitAction.getVanishType() != CommandType.VanishType.NOT_IN_VANISH) continue;
                            quitAction.performCommand(player);
                        }
                    }
                });
            } else if (!shouldSendMessage) {
                for (CommandData quitAction : joinMessage.getQuitActions()) {
                    if (quitAction.getVanishType() != CommandType.VanishType.ALWAYS && quitAction.getVanishType() != CommandType.VanishType.ONLY_VANISH) continue;
                    quitAction.performCommand(player);
                }
            } else {
                for (CommandData quitAction : joinMessage.getQuitActions()) {
                    if (quitAction.getVanishType() != CommandType.VanishType.ALWAYS && quitAction.getVanishType() != CommandType.VanishType.NOT_IN_VANISH) continue;
                    quitAction.performCommand(player);
                }
            }
        }
    }

    public void performQuitMessage(Player player, boolean isAsync) {
        for (Map.Entry<String, JoinMessage> entry : this.plugin.joinMessagesMap.entrySet()) {
            if (!entry.getValue().hasPermission(player)) continue;
            if (!player.isOnline() || this.isInvisible(player)) break;
            if (this.plugin.debugMode) {
                LocalUtils.logp("[QUIT] Player " + player.getName() + " has permission for " + entry.getValue().getIdentifier() + " format!");
            }
            if (!player.isOnline()) break;
            this.performQuitMessage(player, entry.getValue(), isAsync);
            break;
        }
        if (this.plugin.debugMode) {
            LocalUtils.logp("[QUIT] Player " + player.getName() + " doesn't have permission any format!");
        }
    }

    @EventHandler
    public void onJoin(PlayerJoinEvent e) {
        if (this.plugin.removeJoinDefault) {
            e.setJoinMessage(null);
        }
        if (this.loginMap.containsKey(e.getPlayer().getUniqueId())) {
            if (this.plugin.debugMode) {
                LocalUtils.logp("[JOIN] Player " + e.getPlayer().getName() + " is in loginMap. Removing and cancelling previous task..");
            }
            this.loginMap.remove(e.getPlayer().getUniqueId()).cancel();
        }
        if (this.plugin.authMeSupport) {
            if (this.plugin.debugMode) {
                LocalUtils.logp("[JOIN] Player " + e.getPlayer().getName() + " joined but AuthMe is installed and support  is enabled!");
            }
            return;
        }
        this.startJoinProcess(e.getPlayer());
    }

    public void startJoinProcess(Player player) {
        this.startJoinProcess(player, false);
    }

    public void startJoinProcess(Player player, boolean ignoreExceptions) {
        this.startJoinProcess(player, ignoreExceptions, false);
    }

    public void startJoinProcess(Player player, boolean ignoreExceptions, boolean ignoreDelay) {
        for (Map.Entry<String, JoinMessage> entry : this.plugin.joinMessagesMap.entrySet()) {
            if (!entry.getValue().hasPermission(player)) continue;
            if (this.plugin.debugMode) {
                LocalUtils.logp("[JOIN] Player " + player.getName() + " has permission for " + entry.getValue().getIdentifier() + " format!");
            }
            if (ignoreDelay || this.plugin.delayTicks == 0) {
                boolean shouldSendMessage;
                if (!player.isOnline()) break;
                boolean bl = shouldSendMessage = ignoreExceptions || !this.isInvisible(player);
                if (this.plugin.preventSpam) {
                    player.setMetadata("alonsojoin-player-already-announced", (MetadataValue)new FixedMetadataValue((Plugin)this.plugin, null));
                }
                if (!shouldSendMessage) {
                    player.sendMessage(LocalUtils.setPlaceholders(player, this.plugin.messages.joinInSilenceNotification).replace("<NEW-LINE>", "\n"));
                }
                this.performJoinMessage(player, entry.getValue(), false, shouldSendMessage);
                break;
            }
            boolean isAsync = this.plugin.asyncMode;
            Runnable runnable = () -> {
                if (player.isOnline()) {
                    boolean shouldSendMessage;
                    boolean bl = shouldSendMessage = ignoreExceptions || !this.isInvisible(player);
                    if (this.plugin.preventSpam) {
                        player.setMetadata("alonsojoin-player-already-announced", (MetadataValue)new FixedMetadataValue((Plugin)this.plugin, null));
                    }
                    if (!shouldSendMessage) {
                        player.sendMessage(LocalUtils.setPlaceholders(player, this.plugin.messages.joinInSilenceNotification).replace("<NEW-LINE>", "\n"));
                    }
                    this.performJoinMessage(player, (JoinMessage)entry.getValue(), false, shouldSendMessage);
                    this.removeTask(player);
                } else {
                    this.removeTask(player);
                }
            };
            this.loginMap.put(player.getUniqueId(), isAsync ? Bukkit.getScheduler().runTaskLaterAsynchronously((Plugin)this.plugin, runnable, (long)this.plugin.delayTicks) : Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, runnable, (long)this.plugin.delayTicks));
            break;
        }
    }

    private void removeTask(Player player) {
        BukkitTask bukkitTask = this.loginMap.remove(player.getUniqueId());
        if (bukkitTask != null) {
            bukkitTask.cancel();
        }
    }

    public boolean isInvisible(@Nonnull Player player) {
        return this.isInvisible(null, player, false);
    }

    public boolean isInvisible(@Nonnull Player player, boolean ignoreExceptionsStatus) {
        return this.isInvisible(null, player, ignoreExceptionsStatus);
    }

    public boolean isInvisible(CommandSender sender, @Nonnull Player player, boolean ignoreExceptionsStatus) {
        if ((ignoreExceptionsStatus || this.plugin.exceptionsEnabled) && player.hasPermission(this.plugin.permissions.staffPermission)) {
            for (String string : this.plugin.ignoreMetadatas) {
                if (!player.hasMetadata(string)) continue;
                if (this.plugin.debugMode) {
                    player.sendMessage("\u00a7c[DEBUG] You have metadata '" + string + "'. You joined in silence..");
                    if (sender != null) {
                        sender.sendMessage("\u00a7c[DEBUG] Target '" + player.getName() + "' has metadata '" + string + "'. Target will not be announced on join..");
                    }
                }
                return true;
            }
            if (this.plugin.getPluginUtils().isPlaceholderApiSupported()) {
                for (Map.Entry entry : this.plugin.exceptionPlaceholdersMap.entrySet()) {
                    if (!PlaceholderAPI.setPlaceholders((Player)player, (String)((String)entry.getKey())).equals(entry.getValue())) continue;
                    if (this.plugin.debugMode) {
                        player.sendMessage("\u00a7c[DEBUG] Parsed placeholder check '" + (String)entry.getKey() + "' == '" + (String)entry.getValue() + "'. You joined in silence..");
                        if (sender != null) {
                            sender.sendMessage("\u00a7c[DEBUG] Parsed placeholder for target '" + player.getName() + "' => '" + (String)entry.getKey() + "' == '" + (String)entry.getValue() + "'. Target will not be announced on join..");
                        }
                    }
                    return true;
                }
            }
        }
        return false;
    }

    public void performJoinMessage(@Nonnull Player player, boolean isAsync) {
        if (this.loginMap.containsKey(player.getUniqueId())) {
            this.loginMap.remove(player.getUniqueId()).cancel();
        }
        for (Map.Entry<String, JoinMessage> entry : this.plugin.joinMessagesMap.entrySet()) {
            if (!entry.getValue().hasPermission(player)) continue;
            if (this.plugin.delayTicks == 0) {
                if (!player.isOnline()) break;
                this.performJoinMessage(player, entry.getValue(), isAsync);
                break;
            }
            this.performJoinMessage(player, entry.getValue(), isAsync);
            break;
        }
    }

    public void performJoinMessage(@Nonnull Player player, boolean runAsync, int delayInTicks) {
        if (this.loginMap.containsKey(player.getUniqueId())) {
            this.loginMap.remove(player.getUniqueId()).cancel();
        }
        for (Map.Entry<String, JoinMessage> entry : this.plugin.joinMessagesMap.entrySet()) {
            if (!entry.getValue().hasPermission(player)) continue;
            if (delayInTicks <= 0) {
                if (!player.isOnline()) break;
                this.performJoinMessage(player, entry.getValue(), false);
                if (!this.loginMap.containsKey(player.getUniqueId())) break;
                this.loginMap.remove(player.getUniqueId()).cancel();
                break;
            }
            Runnable runnable = () -> {
                if (player.isOnline() && !this.isInvisible(player)) {
                    this.performJoinMessage(player, (JoinMessage)entry.getValue(), runAsync);
                } else if (this.plugin.notifySilentJoin && player.isOnline()) {
                    player.sendMessage(LocalUtils.setPlaceholders(player, this.plugin.messages.joinInSilenceNotification).replace("<NEW-LINE>", "\n"));
                    if (this.loginMap.containsKey(player.getUniqueId())) {
                        this.loginMap.remove(player.getUniqueId()).cancel();
                    }
                }
            };
            this.loginMap.put(player.getUniqueId(), runAsync ? Bukkit.getScheduler().runTaskLaterAsynchronously((Plugin)this.plugin, runnable, (long)delayInTicks) : Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, runnable, (long)delayInTicks));
            break;
        }
    }

    @Deprecated
    public void performJoinMessage(@Nonnull Player player, @Nonnull JoinMessage joinMessage, boolean isAsync) {
        this.performJoinMessage(player, joinMessage, isAsync, true);
    }

    public void performJoinMessage(@Nonnull Player player, @Nonnull JoinMessage joinMessage, boolean isAsync, boolean shouldSendMessage) {
        if (shouldSendMessage) {
            Component component;
            Iterator<String> worldPlayersNames;
            Component component2;
            ArrayList<String> worldPlayersNames2;
            if (this.plugin.whitelistMode) {
                Component component3;
                if (joinMessage.hasJoinSound()) {
                    if (joinMessage.isRelational() && this.plugin.getPluginUtils().isPlaceholderApiSupported()) {
                        worldPlayersNames2 = new ArrayList<String>();
                        for (World world : this.plugin.getServer().getWorlds()) {
                            if (!this.plugin.whitelistedWorlds.contains(world.getName())) continue;
                            for (Player worldPlayer : world.getPlayers()) {
                                component3 = joinMessage.buildJoinMessage(player, worldPlayer);
                                if (component3 != null) {
                                    AdventureUtils.player(worldPlayer).sendMessage(component3);
                                }
                                worldPlayer.playSound(worldPlayer.getLocation(), joinMessage.getJoinSound(), 1.0f, 1.0f);
                                if (!this.plugin.debugMode) continue;
                                worldPlayersNames2.add(worldPlayer.getName());
                            }
                        }
                        if (this.plugin.debugMode) {
                            LocalUtils.logp("[1] Sending join message component to (" + worldPlayersNames2.size() + ") players: " + String.join((CharSequence)",", worldPlayersNames2) + "!");
                        }
                    } else {
                        component2 = joinMessage.buildJoinMessage(player);
                        worldPlayersNames = new ArrayList();
                        for (Object world : this.plugin.getServer().getWorlds()) {
                            if (!this.plugin.whitelistedWorlds.contains(world.getName())) continue;
                            for (Player worldPlayer : world.getPlayers()) {
                                if (component2 != null) {
                                    AdventureUtils.player(worldPlayer).sendMessage(component2);
                                }
                                worldPlayer.playSound(worldPlayer.getLocation(), joinMessage.getJoinSound(), 1.0f, 1.0f);
                                if (!this.plugin.debugMode) continue;
                                worldPlayersNames.add(worldPlayer.getName());
                            }
                        }
                        if (this.plugin.debugMode) {
                            LocalUtils.logp("[2] Sending join message component to (" + worldPlayersNames.size() + ") players: " + String.join((CharSequence)",", worldPlayersNames) + "!");
                        }
                    }
                } else if (joinMessage.hasJoinMessage()) {
                    if (joinMessage.isRelational() && this.plugin.getPluginUtils().isPlaceholderApiSupported()) {
                        worldPlayersNames2 = new ArrayList();
                        for (World world : this.plugin.getServer().getWorlds()) {
                            if (!this.plugin.whitelistedWorlds.contains(world.getName())) continue;
                            for (Player worldPlayer : world.getPlayers()) {
                                component3 = joinMessage.buildJoinMessage(player, worldPlayer);
                                AdventureUtils.player(worldPlayer).sendMessage(component3);
                                if (!this.plugin.debugMode) continue;
                                worldPlayersNames2.add(worldPlayer.getName());
                            }
                        }
                        if (this.plugin.debugMode) {
                            LocalUtils.logp("[3] Sending join message component to (" + worldPlayersNames2.size() + ") players: " + String.join((CharSequence)",", worldPlayersNames2) + "!");
                        }
                    } else {
                        component2 = joinMessage.buildJoinMessage(player);
                        worldPlayersNames = new ArrayList();
                        for (Object world : this.plugin.getServer().getWorlds()) {
                            if (!this.plugin.whitelistedWorlds.contains(world.getName())) continue;
                            for (Player worldPlayer : world.getPlayers()) {
                                AdventureUtils.player(worldPlayer).sendMessage(component2);
                                if (!this.plugin.debugMode) continue;
                                worldPlayersNames.add(worldPlayer.getName());
                            }
                        }
                        if (this.plugin.debugMode) {
                            LocalUtils.logp("[4] Sending join message component to (" + worldPlayersNames.size() + ") players: " + String.join((CharSequence)",", worldPlayersNames) + "!");
                        }
                    }
                }
            } else if (joinMessage.hasJoinSound()) {
                if (joinMessage.isRelational() && this.plugin.getPluginUtils().isPlaceholderApiSupported()) {
                    worldPlayersNames2 = new ArrayList();
                    for (Player worldPlayer : this.plugin.getServer().getOnlinePlayers()) {
                        component = joinMessage.buildJoinMessage(player, worldPlayer);
                        if (component != null) {
                            AdventureUtils.player(worldPlayer).sendMessage(component);
                        }
                        worldPlayer.playSound(worldPlayer.getLocation(), joinMessage.getJoinSound(), 1.0f, 1.0f);
                        if (!this.plugin.debugMode) continue;
                        worldPlayersNames2.add(worldPlayer.getName());
                    }
                    if (this.plugin.debugMode) {
                        LocalUtils.logp("[5] Sending join message component to (" + worldPlayersNames2.size() + ") players: " + String.join((CharSequence)",", worldPlayersNames2) + "!");
                    }
                } else {
                    component2 = joinMessage.buildJoinMessage(player);
                    worldPlayersNames = new ArrayList();
                    for (Player worldPlayer : this.plugin.getServer().getOnlinePlayers()) {
                        if (component2 != null) {
                            AdventureUtils.player(worldPlayer).sendMessage(component2);
                        }
                        worldPlayer.playSound(worldPlayer.getLocation(), joinMessage.getJoinSound(), 1.0f, 1.0f);
                        if (!this.plugin.debugMode) continue;
                        worldPlayersNames.add(worldPlayer.getName());
                    }
                    if (this.plugin.debugMode) {
                        LocalUtils.logp("[6] Sending join message component to (" + worldPlayersNames.size() + ") players: " + String.join((CharSequence)",", worldPlayersNames) + "!");
                    }
                }
            } else if (joinMessage.hasJoinMessage()) {
                if (joinMessage.isRelational() && this.plugin.getPluginUtils().isPlaceholderApiSupported()) {
                    worldPlayersNames2 = new ArrayList();
                    for (Player worldPlayer : this.plugin.getServer().getOnlinePlayers()) {
                        component = joinMessage.buildJoinMessage(player, worldPlayer);
                        AdventureUtils.player(worldPlayer).sendMessage(component);
                        if (!this.plugin.debugMode) continue;
                        worldPlayersNames2.add(worldPlayer.getName());
                    }
                    if (this.plugin.debugMode) {
                        LocalUtils.logp("[7] Sending join message component to (" + worldPlayersNames2.size() + ") players: " + String.join((CharSequence)",", worldPlayersNames2) + "!");
                    }
                } else {
                    component2 = joinMessage.buildJoinMessage(player);
                    AdventureUtils.players().sendMessage(component2);
                    if (this.plugin.debugMode) {
                        LocalUtils.logp("[8] Sending join message component to all players online!");
                    }
                }
            }
        }
        if (!joinMessage.getJoinActions().isEmpty()) {
            if (isAsync) {
                Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
                    if (!shouldSendMessage) {
                        for (CommandData joinAction : joinMessage.getJoinActions()) {
                            if (joinAction.getVanishType() != CommandType.VanishType.ALWAYS && joinAction.getVanishType() != CommandType.VanishType.ONLY_VANISH) continue;
                            joinAction.performCommand(player);
                        }
                    } else {
                        for (CommandData joinAction : joinMessage.getJoinActions()) {
                            if (joinAction.getVanishType() != CommandType.VanishType.ALWAYS && joinAction.getVanishType() != CommandType.VanishType.NOT_IN_VANISH) continue;
                            joinAction.performCommand(player);
                        }
                    }
                });
            } else if (!shouldSendMessage) {
                for (CommandData joinAction : joinMessage.getJoinActions()) {
                    if (joinAction.getVanishType() != CommandType.VanishType.ALWAYS && joinAction.getVanishType() != CommandType.VanishType.ONLY_VANISH) continue;
                    joinAction.performCommand(player);
                }
            } else {
                for (CommandData joinAction : joinMessage.getJoinActions()) {
                    if (joinAction.getVanishType() != CommandType.VanishType.ALWAYS && joinAction.getVanishType() != CommandType.VanishType.NOT_IN_VANISH) continue;
                    joinAction.performCommand(player);
                }
            }
        }
        this.removeTask(player);
        if (this.plugin.debugMode) {
            LocalUtils.logp("Player " + player.getName() + " has been removed from loginMap successfully!");
        }
    }
}

