/*
 * Decompiled with CFR 0.152.
 */
package com.alonsoaliaga.alonsojoin.listeners;

import com.alonsoaliaga.alonsojoin.AlonsoJoin;
import com.alonsoaliaga.alonsojoin.others.BukkitSoundData;
import com.alonsoaliaga.alonsojoin.others.CustomSoundData;
import com.alonsoaliaga.alonsojoin.others.SoundData;
import com.alonsoaliaga.alonsojoin.utils.AdventureUtils;
import com.alonsoaliaga.alonsojoin.utils.LocalUtils;
import com.alonsoaliaga.alonsolib.libraries.adventure.text.minimessage.MiniMessage;
import com.alonsoaliaga.alonsolib.libraries.adventure.text.serializer.gson.GsonComponentSerializer;
import com.alonsoaliaga.alonsolib.libraries.adventure.text.serializer.legacy.LegacyComponentSerializer;
import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteStreams;
import org.bukkit.Bukkit;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.plugin.messaging.PluginMessageListener;
import org.jetbrains.annotations.NotNull;

public class BungeeMessageListener
implements PluginMessageListener {
    private AlonsoJoin plugin;

    public BungeeMessageListener(AlonsoJoin plugin) {
        this.plugin = plugin;
    }

    public void onPluginMessageReceived(@NotNull String channel, @NotNull Player player, @NotNull byte[] bytes) {
        if (channel == null) {
            BungeeMessageListener.$$$reportNull$$$0(0);
        }
        if (player == null) {
            BungeeMessageListener.$$$reportNull$$$0(1);
        }
        if (bytes == null) {
            BungeeMessageListener.$$$reportNull$$$0(2);
        }
        if (!channel.equalsIgnoreCase("alonsobungee:main")) {
            return;
        }
        ByteArrayDataInput in = ByteStreams.newDataInput((byte[])bytes);
        String pluginName = in.readUTF();
        if (!pluginName.equalsIgnoreCase("AlonsoJoin")) {
            return;
        }
        String order = in.readUTF();
        if ("BUNGEE_BROADCAST".equals(order)) {
            World world;
            String message;
            String playerName = in.readUTF();
            String worldsString = in.readUTF();
            String soundString = in.readUTF();
            SoundData soundData = null;
            if (!soundString.isEmpty()) {
                String[] soundParts = soundString.split(",");
                float volume = 1.0f;
                float pitch = 1.0f;
                try {
                    volume = Float.parseFloat(soundParts[1]);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                try {
                    pitch = Float.parseFloat(soundParts[2]);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                String[] stringArray = soundParts[0].split("\\|");
                int n = stringArray.length;
                for (int i = 0; i < n; ++i) {
                    String s = stringArray[i];
                    Sound sound = LocalUtils.getSound(s);
                    if (sound != null) {
                        soundData = new BukkitSoundData(sound, volume, pitch);
                        break;
                    }
                    if (!s.startsWith("custom=")) continue;
                    String customSound = s.substring(7);
                    soundData = new CustomSoundData(customSound, volume, pitch);
                    break;
                }
            }
            Object component = (message = in.readUTF()).startsWith("json=") ? GsonComponentSerializer.gson().deserialize((Object)message.substring(5)) : (message.startsWith("minimessage=") ? MiniMessage.miniMessage().deserialize((Object)message.substring(12)) : LegacyComponentSerializer.legacyAmpersand().deserialize(message));
            if (worldsString.isEmpty()) {
                AdventureUtils.players().sendMessage(component);
                if (soundData != null) {
                    Bukkit.getOnlinePlayers().forEach(soundData::playSound);
                }
            } else if (soundData == null) {
                for (String s : worldsString.split(",")) {
                    world = Bukkit.getWorld((String)s);
                    if (world == null || world.getPlayers().isEmpty()) continue;
                    for (Player worldPlayer : world.getPlayers()) {
                        AdventureUtils.player(worldPlayer).sendMessage(component);
                    }
                }
            } else {
                for (String s : worldsString.split(",")) {
                    world = Bukkit.getWorld((String)s);
                    if (world == null || world.getPlayers().isEmpty()) continue;
                    for (Player worldPlayer : world.getPlayers()) {
                        AdventureUtils.player(worldPlayer).sendMessage(component);
                        soundData.playSound(worldPlayer);
                    }
                }
            }
        } else if (this.plugin.debugMode) {
            LocalUtils.logp("[DEBUG] Unknown order was received from Proxy: '" + order + "' from plugin '" + pluginName + "'");
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "channel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "player";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "bytes";
                break;
            }
        }
        objectArray[1] = "com/alonsoaliaga/alonsojoin/listeners/BungeeMessageListener";
        objectArray[2] = "onPluginMessageReceived";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

