/*
 * Decompiled with CFR 0.152.
 */
package com.alonsoaliaga.alonsojoin.listeners;

import com.alonsoaliaga.alonsojoin.AlonsoJoin;
import com.alonsoaliaga.alonsojoin.utils.LocalUtils;
import fr.xephi.authme.events.LoginEvent;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.plugin.Plugin;

public class AuthListener
implements Listener {
    private AlonsoJoin plugin;
    private boolean registered = false;

    public AuthListener(AlonsoJoin plugin) {
        this.plugin = plugin;
        this.reloadMessages();
    }

    public void reloadMessages() {
        if (this.plugin.authMeSupport) {
            if (!this.registered) {
                this.plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this.plugin);
                this.registered = true;
            }
        } else if (this.registered) {
            PlayerJoinEvent.getHandlerList().unregister((Listener)this);
            this.registered = false;
        }
    }

    @EventHandler
    public void onLogin(LoginEvent e) {
        if (this.plugin.preventSpam && e.getPlayer().hasMetadata("alonsojoin-player-already-announced")) {
            if (this.plugin.debugMode) {
                LocalUtils.logp("[LOGIN] Player " + e.getPlayer().getName() + " has login in but he was previously announced. Skipping..");
            }
            return;
        }
        if (this.plugin.debugMode) {
            LocalUtils.logp("[LOGIN] Player " + e.getPlayer().getName() + " has login in but and wasn't announced before. Starting join process..");
        }
        this.plugin.connectionListener.startJoinProcess(e.getPlayer());
    }
}

