/*
 * Decompiled with CFR 0.152.
 */
package com.alonsoaliaga.alonsojoin.hooks;

import com.alonsoaliaga.alonsojoin.AlonsoJoin;
import com.alonsoaliaga.alonsojoin.others.JoinMessage;
import com.alonsoaliaga.alonsojoin.utils.AlonsoUtils;
import com.alonsoaliaga.alonsojoin.utils.LocalUtils;
import java.util.Map;
import me.clip.placeholderapi.PlaceholderAPI;
import me.clip.placeholderapi.expansion.PlaceholderExpansion;
import org.bukkit.entity.Player;

public class PlaceholderAPIHook
extends PlaceholderExpansion {
    private AlonsoJoin plugin;
    private String identifier;

    public PlaceholderAPIHook(AlonsoJoin plugin, String identifier) {
        this.plugin = plugin;
        this.identifier = identifier;
        LocalUtils.logp("PlaceholderAPI found! Hooking..");
        this.loadPlaceholders();
    }

    public String onPlaceholderRequest(Player p, String params) {
        if (p == null) {
            return null;
        }
        if (params.equalsIgnoreCase("this_is_not_an_easter_egg")) {
            return AlonsoUtils.first + "You found an easter egg!";
        }
        if (params.equalsIgnoreCase("developer")) {
            return "AlonsoAliaga";
        }
        if (params.equalsIgnoreCase("version")) {
            return this.plugin.getDescription().getVersion();
        }
        if (params.equalsIgnoreCase("format_identifier")) {
            for (Map.Entry<String, JoinMessage> entry : this.plugin.joinMessagesMap.entrySet()) {
                if (!entry.getValue().hasPermission(p)) continue;
                return entry.getKey();
            }
            return "none";
        }
        if (params.startsWith("restoreall_")) {
            String placeholder = "%" + params.substring(11) + "%";
            String parsed = PlaceholderAPI.setPlaceholders((Player)p, (String)placeholder);
            return parsed.equals(placeholder) ? placeholder : LocalUtils.restoreColorNodesFromString(parsed, true);
        }
        if (params.startsWith("restorehex_")) {
            String placeholder = "%" + params.substring(11) + "%";
            String parsed = PlaceholderAPI.setPlaceholders((Player)p, (String)placeholder);
            return parsed.equals(placeholder) ? placeholder : LocalUtils.restoreColorNodesFromString(parsed, false);
        }
        return null;
    }

    private void loadPlaceholders() {
        this.register();
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public String getAuthor() {
        return "AlonsoAliaga";
    }

    public String getVersion() {
        return this.plugin.getDescription().getVersion();
    }

    public boolean persist() {
        return true;
    }
}

