/*
 * Decompiled with CFR 0.152.
 */
package com.alonsoaliaga.alonsojoin.enums;

import com.alonsoaliaga.alonsojoin.others.CommandData;

public enum CommandType {
    PLAYER("[PLAYER]", true),
    CONSOLE("[CONSOLE]", true),
    CHAT("[CHAT]", true),
    OP("[OP]", true),
    MESSAGE("[MESSAGE]"),
    MESSAGE_BROADCAST("[MESSAGE_BROADCAST]", true),
    MESSAGE_WORLD_BROADCAST("[MESSAGE_WORLD_BROADCAST]", true),
    SOUND("[SOUND]"),
    SOUND_BROADCAST("[SOUND_BROADCAST]", true),
    SOUND_WORLD_BROADCAST("[SOUND_WORLD_BROADCAST]", true),
    CUSTOM_SOUND("[CUSTOM_SOUND]"),
    CUSTOM_SOUND_BROADCAST("[CUSTOM_SOUND_BROADCAST]", true),
    CUSTOM_SOUND_WORLD_BROADCAST("[CUSTOM_SOUND_WORLD_BROADCAST]", true),
    TITLE("[TITLE]"),
    TITLE_BROADCAST("[TITLE_BROADCAST]", true),
    TITLE_WORLD_BROADCAST("[TITLE_WORLD_BROADCAST]", true),
    ACTION_BAR("[ACTION_BAR]"),
    ACTION_BAR_BROADCAST("[ACTION_BAR_BROADCAST]", true),
    ACTION_BAR_WORLD_BROADCAST("[ACTION_BAR_WORLD_BROADCAST]", true),
    FIREWORK("[FIREWORK]"),
    JSON("[JSON]"),
    JSON_BROADCAST("[JSON_BROADCAST]", true),
    JSON_WORLD_BROADCAST("[JSON_WORLD_BROADCAST]", true),
    BUNGEE_PLAYER_CHAT("[BUNGEE_PLAYER_CHAT]", true),
    BUNGEE_PLAYER_COMMAND("[BUNGEE_PLAYER_COMMAND]", true),
    BUNGEE_CONSOLE("[BUNGEE_CONSOLE]", true),
    BUNGEE_CONNECT("[BUNGEE_CONNECT]", true),
    BUNGEE_BROADCAST("[BUNGEE_BROADCAST]", true),
    BUNGEE_KICK("[BUNGEE_KICK]", true),
    CLOSE_INVENTORY("[CLOSE_INVENTORY]", false),
    LEAVE_VEHICLE("[LEAVE_VEHICLE]", false),
    BOOK("[BOOK]");

    private String toRemove;
    private boolean requiresOP;

    private CommandType(String toRemove) {
        this.toRemove = toRemove;
        this.requiresOP = false;
    }

    private CommandType(String toRemove, boolean requiresOP) {
        this.toRemove = toRemove;
        this.requiresOP = requiresOP;
    }

    public boolean requiresOP() {
        return this.requiresOP;
    }

    public String getToRemove() {
        return this.toRemove;
    }

    public CommandData getCommandData(String string) {
        return new CommandData(string);
    }

    public CommandData getCommandData(String string, CommandType defaultCommandType, ConnectionType connectionType) {
        string = string.trim();
        for (CommandType commandType : CommandType.values()) {
            if (!string.startsWith(commandType.getToRemove())) continue;
            return new CommandData(string.substring(commandType.getToRemove().length()), commandType, connectionType);
        }
        return new CommandData(string, defaultCommandType, connectionType);
    }

    public static CommandType getFromCommand(String name) {
        for (CommandType commandType : CommandType.values()) {
            if (!name.startsWith(commandType.getToRemove())) continue;
            return commandType;
        }
        return null;
    }

    public static CommandType getCommandType(String name) {
        return CommandType.getCommandType(name, null);
    }

    public static CommandType getCommandType(String name, CommandType defaultCommandType) {
        try {
            return CommandType.valueOf(name);
        }
        catch (Throwable e) {
            return defaultCommandType;
        }
    }

    public static enum VanishType {
        ALWAYS("[ALWAYS]"),
        ONLY_VANISH("[ONLY_VANISH]"),
        NOT_IN_VANISH("[NOT_IN_VANISH]");

        private String toRemove;

        private VanishType(String toRemove) {
            this.toRemove = toRemove;
        }

        public String getToRemove() {
            return this.toRemove;
        }

        public static VanishType getFromCommand(String name) {
            for (VanishType connectionType : VanishType.values()) {
                if (!name.startsWith(connectionType.getToRemove())) continue;
                return connectionType;
            }
            return null;
        }

        public static VanishType getVanishType(String name) {
            return VanishType.getVanishType(name, null);
        }

        public static VanishType getVanishType(String name, VanishType defaultVanishType) {
            try {
                return VanishType.valueOf(name);
            }
            catch (Throwable e) {
                return defaultVanishType;
            }
        }
    }

    public static enum ConnectionType {
        FIRST_JOIN("[FIRST_JOIN]"),
        KNOWN_PLAYER("[KNOWN_PLAYER]"),
        NORMAL("[NORMAL]");

        private String toRemove;

        private ConnectionType(String toRemove) {
            this.toRemove = toRemove;
        }

        public String getToRemove() {
            return this.toRemove;
        }

        public static ConnectionType getFromCommand(String name) {
            for (ConnectionType connectionType : ConnectionType.values()) {
                if (!name.startsWith(connectionType.getToRemove())) continue;
                return connectionType;
            }
            return null;
        }

        public static ConnectionType getConnectionType(String name) {
            return ConnectionType.getConnectionType(name, null);
        }

        public static ConnectionType getConnectionType(String name, ConnectionType defaultConnectionType) {
            try {
                return ConnectionType.valueOf(name);
            }
            catch (Throwable e) {
                return defaultConnectionType;
            }
        }
    }
}

