/*
 * Decompiled with CFR 0.152.
 */
package com.alonsoaliaga.alonsojoin.commands;

import com.alonsoaliaga.alonsojoin.AlonsoJoin;
import com.alonsoaliaga.alonsojoin.commands.AbstractCommand;
import com.alonsoaliaga.alonsojoin.others.CommandData;
import com.alonsoaliaga.alonsojoin.others.JoinMessage;
import com.alonsoaliaga.alonsojoin.others.Sounds;
import com.alonsoaliaga.alonsojoin.utils.AdventureUtils;
import com.alonsoaliaga.alonsojoin.utils.AlonsoUtils;
import com.alonsoaliaga.alonsojoin.utils.LocalUtils;
import com.alonsoaliaga.alonsolib.libraries.adventure.text.Component;
import com.alonsoaliaga.alonsolib.libraries.adventure.text.TextComponent;
import com.alonsoaliaga.alonsolib.libraries.adventure.text.event.HoverEvent;
import com.alonsoaliaga.alonsolib.libraries.adventure.text.event.HoverEventSource;
import com.alonsoaliaga.alonsolib.libraries.adventure.text.serializer.legacy.LegacyComponentSerializer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;

public class MainCommand
extends AbstractCommand {
    private AlonsoJoin plugin;
    private List<String> adminList = new ArrayList<String>(Arrays.asList("reload", "testjoin", "testquit", "testhover", "testexceptions", "broadcastjoin", "broadcastquit", "testaction", "testformat"));
    private List<String> fakeJoinList = Arrays.asList("fakejoin", "fj", "fjoin");
    private List<String> fakeLeaveList = Arrays.asList("fakeleave", "fl", "fleave", "fakequit", "fq", "fquit");
    private List<String> userList = Collections.emptyList();
    private List<String> emptyList = Collections.emptyList();
    private boolean testServer = false;
    private String errorBroadcast = LocalUtils.colorize("&cHello {PLAYER}! This command is no available in our test server.\n&cFeel free to use /alonsojoin testjoin/testquit <player>. It works the same way but only you can read it! (Doesn't run actions)");
    private String testError = LocalUtils.colorize("&cHey {PLAYER}! For security reasons, this command is disabled in this test server!");
    private String testReloadError = LocalUtils.colorize("&cHey {PLAYER}! For security reasons, this command is disabled in this test server!");
    private String testHoverError = LocalUtils.colorize("&cHey {PLAYER}! In this test server you can only target yourself for test!");
    public HashMap<UUID, BukkitTask> testingMap = new HashMap();

    public MainCommand(AlonsoJoin plugin, String command, List<String> aliases, String description) {
        super(command, "/" + command, description, aliases);
        this.plugin = plugin;
        this.register();
        this.reloadMessages();
        this.adminList.addAll(this.fakeJoinList);
        this.adminList.addAll(this.fakeLeaveList);
    }

    private void reloadMessages() {
    }

    @Override
    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        if (this.plugin.permissions.mainPermission != null && !sender.hasPermission(this.plugin.permissions.mainPermission)) {
            sender.sendMessage(this.plugin.messages.noPermission);
            return true;
        }
        if (args.length >= 1) {
            if (args[0].equalsIgnoreCase("paste") && sender.hasPermission(this.plugin.permissions.adminPermission)) {
                if (this.testServer && !sender.isOp()) {
                    Player player = (Player)sender;
                    LocalUtils.send((CommandSender)player, this.testError.replace("{PLAYER}", sender.getName()));
                    player.playSound(player.getLocation(), Sounds.ANVIL_LAND.getSound(), 1.0f, 1.0f);
                    player.playSound(player.getLocation(), Sounds.ANVIL_LAND.getSound(), 1.0f, 1.0f);
                    return true;
                }
                StringBuilder text = new StringBuilder("Plugin: " + this.plugin.getDescription().getName() + "\nVersion: " + this.plugin.getDescription().getVersion() + "\nJava: " + System.getProperty("java.version") + "\nOS: " + System.getProperty("os.name") + " (" + System.getProperty("os.version") + ")\nServer: " + this.plugin.getServer().getName() + " (" + this.plugin.getServer().getVersion() + ")\nDate: " + new Date().toString() + "\nDebug: " + this.plugin.debugMode + "\nDelay ticks: " + this.plugin.delayTicks + "\nAuthMe Support: " + this.plugin.authMeSupport + "\nLoaded books: " + this.plugin.booksMap.size() + "\nAsync mode: " + this.plugin.asyncMode + "\nFormats: " + this.plugin.joinMessagesMap.size() + "\nExceptions enabled: " + this.plugin.exceptionsEnabled + "\n" + (this.plugin.exceptionsEnabled ? "   Metadata: (" + this.plugin.ignoreMetadatas.size() + ")\n" + (this.plugin.ignoreMetadatas.isEmpty() ? "" : "     - " + this.plugin.ignoreMetadatas.stream().map(m -> "'" + m + "'").collect(Collectors.joining("\n -     ")) + "\n") + "   Placeholders: (" + this.plugin.exceptionPlaceholdersMap.size() + ")\n" + (this.plugin.exceptionPlaceholdersMap.isEmpty() ? "" : this.plugin.exceptionPlaceholdersMap.entrySet().stream().map(entry -> "      " + (String)entry.getKey() + " => '" + (String)entry.getValue() + "'").collect(Collectors.joining("\n      ")) + "\n") : "") + "Whitelist mode: " + this.plugin.whitelistMode + (this.plugin.whitelistMode ? "(" + String.join((CharSequence)", ", this.plugin.whitelistedWorlds) + ")" : "") + "\nNotify silent join: " + this.plugin.notifySilentJoin + "\nPrevent spam: " + this.plugin.preventSpam + "\nFirework Damage: " + !this.plugin.fireworkNoDamage + "\nFix colors: " + LocalUtils.getfixColors() + "\nRemove join: " + this.plugin.removeJoinDefault + "\nRemove quit: " + this.plugin.removeQuitDefault);
                Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
                    String encoded = text.toString();
                    int times = ThreadLocalRandom.current().nextInt(1, 6);
                    for (int i = 0; i < times; ++i) {
                        encoded = Base64.getEncoder().encodeToString(encoded.getBytes());
                    }
                    String finalMessage = String.valueOf(times).length() + "" + times + encoded + times + "A";
                    if (sender instanceof Player) {
                        Player player = (Player)sender;
                        player.playSound(player.getLocation(), Sounds.EXP_ORB.getSound(), 1.0f, 1.0f);
                        LocalUtils.send(sender, "&aRequired data has been sent to console!");
                    }
                    LocalUtils.log("&c***************************************************************************");
                    LocalUtils.log("&eRequested data by " + sender.getName() + ":");
                    Bukkit.getServer().getConsoleSender().sendMessage("\u00a7e" + finalMessage);
                    LocalUtils.log("&c***************************************************************************");
                });
                return true;
            }
            if (args[0].equalsIgnoreCase("testhover") && sender.hasPermission(this.plugin.permissions.adminPermission)) {
                if (args.length >= 2) {
                    String text;
                    Player target;
                    Player player = null;
                    boolean hasTarget = false;
                    if (args.length >= 4 && (target = Bukkit.getPlayer((String)args[1])) != null) {
                        player = target;
                        hasTarget = true;
                    }
                    if (sender instanceof Player) {
                        if (player == null) {
                            player = (Player)sender;
                        }
                        if (this.testServer && !sender.getName().equals(player.getName()) && !sender.isOp()) {
                            Player blockedPlayer = (Player)sender;
                            LocalUtils.send((CommandSender)blockedPlayer, this.testHoverError.replace("{PLAYER}", blockedPlayer.getName()));
                            blockedPlayer.playSound(blockedPlayer.getLocation(), Sounds.ANVIL_LAND.getSound(), 1.0f, 1.0f);
                            player.playSound(player.getLocation(), Sounds.ANVIL_LAND.getSound(), 1.0f, 1.0f);
                            return true;
                        }
                        sender.sendMessage("\u00a7aTest messages sent!");
                        text = String.join((CharSequence)" ", Arrays.copyOfRange(args, hasTarget ? 2 : 1, args.length));
                        player.sendMessage("\u00a7ePlain text:");
                        player.sendMessage(text);
                        player.sendMessage("\u00a7ePlaceholder text:");
                        player.sendMessage(LocalUtils.setPlaceholders(player, text));
                        player.sendMessage("\u00a7eColored text:");
                        player.sendMessage(LocalUtils.colorize(text));
                        player.sendMessage("\u00a7eColored placeholder text:");
                        player.sendMessage(LocalUtils.colorize(LocalUtils.setPlaceholders(player, text)));
                        player.sendMessage("\u00a7eHover text:");
                        TextComponent component1 = LegacyComponentSerializer.legacyAmpersand().deserialize(text);
                        component1 = component1.hoverEvent((HoverEventSource)HoverEvent.showText((Component)LegacyComponentSerializer.legacyAmpersand().deserialize("&cThis is a test hover for server owners to test colors.")));
                        AdventureUtils.player(player).sendMessage((Component)component1);
                        player.sendMessage("\u00a7eHover placeholder text:");
                        TextComponent component2 = LegacyComponentSerializer.legacyAmpersand().deserialize(LocalUtils.setPlaceholders(player, text));
                        component2 = component2.hoverEvent((HoverEventSource)HoverEvent.showText((Component)LegacyComponentSerializer.legacyAmpersand().deserialize(LocalUtils.setPlaceholders(player, "&cThis is a test hover for server owners to test colors."))));
                        AdventureUtils.player(player).sendMessage((Component)component2);
                        return true;
                    }
                    if (player == null) {
                        text = String.join((CharSequence)" ", Arrays.copyOfRange(args, 1, args.length));
                        sender.sendMessage("\u00a7ePlain text:");
                        sender.sendMessage(text);
                        sender.sendMessage("\u00a7eColored text:");
                        sender.sendMessage(LocalUtils.colorize(text));
                        return true;
                    }
                    sender.sendMessage("\u00a7aTest messages sent!");
                    text = String.join((CharSequence)" ", Arrays.copyOfRange(args, 2, args.length));
                    player.sendMessage("\u00a7ePlain text:");
                    player.sendMessage(text);
                    player.sendMessage("\u00a7ePlaceholder text:");
                    player.sendMessage(LocalUtils.setPlaceholders(player, text));
                    player.sendMessage("\u00a7eColored text:");
                    player.sendMessage(LocalUtils.colorize(text));
                    player.sendMessage("\u00a7eColored placeholder text:");
                    player.sendMessage(LocalUtils.colorize(LocalUtils.setPlaceholders(player, text)));
                    player.sendMessage("\u00a7eHover text:");
                    TextComponent component = LegacyComponentSerializer.legacyAmpersand().deserialize(text);
                    component = component.hoverEvent((HoverEventSource)HoverEvent.showText((Component)LegacyComponentSerializer.legacyAmpersand().deserialize("&cThis is a test hover for server owners to test colors.")));
                    AdventureUtils.player(player).sendMessage((Component)component);
                    player.sendMessage("\u00a7eHover placeholder text:");
                    TextComponent component2 = LegacyComponentSerializer.legacyAmpersand().deserialize(LocalUtils.setPlaceholders(player, text));
                    component2 = component2.hoverEvent((HoverEventSource)HoverEvent.showText((Component)LegacyComponentSerializer.legacyAmpersand().deserialize(LocalUtils.setPlaceholders(player, "&cThis is a test hover for server owners to test colors."))));
                    AdventureUtils.player(player).sendMessage((Component)component2);
                    return true;
                }
                LocalUtils.send(sender, "&cUsage: /alonsojoin testhover [target] <message>");
                return true;
            }
            if (args[0].equalsIgnoreCase("testexceptions") && sender.hasPermission(this.plugin.permissions.adminPermission)) {
                if (this.testServer && !sender.isOp()) {
                    Player player = (Player)sender;
                    LocalUtils.send((CommandSender)player, this.testReloadError.replace("{PLAYER}", sender.getName()));
                    player.playSound(player.getLocation(), Sounds.ANVIL_LAND.getSound(), 1.0f, 1.0f);
                    player.playSound(player.getLocation(), Sounds.ANVIL_LAND.getSound(), 1.0f, 1.0f);
                    return true;
                }
                if (sender instanceof Player) {
                    if (args.length >= 2) {
                        Player target = Bukkit.getPlayer((String)args[1]);
                        if (target == null) {
                            LocalUtils.send(sender, this.plugin.messages.invalidTarget);
                            return true;
                        }
                        boolean isVanished = this.plugin.connectionListener.isInvisible(sender, target, true);
                        if (isVanished) {
                            sender.sendMessage(this.plugin.messages.testExceptionsTargetIsVanished.replace("{PLAYER}", target.getName()));
                        } else {
                            sender.sendMessage(this.plugin.messages.testExceptionsTargetIsNotVanished.replace("{PLAYER}", target.getName()));
                        }
                        return true;
                    }
                    Player player = (Player)sender;
                    boolean isVanished = this.plugin.connectionListener.isInvisible(sender, player, true);
                    if (isVanished) {
                        sender.sendMessage(this.plugin.messages.testExceptionsYouAreVanished.replace("{PLAYER}", player.getName()));
                    } else {
                        sender.sendMessage(this.plugin.messages.testExceptionsYouAreNotVanished.replace("{PLAYER}", player.getName()));
                    }
                } else {
                    if (args.length >= 2) {
                        Player target = Bukkit.getPlayer((String)args[1]);
                        if (target == null) {
                            LocalUtils.send(sender, this.plugin.messages.invalidTarget);
                            return true;
                        }
                        boolean isVanished = this.plugin.connectionListener.isInvisible(sender, target, true);
                        if (isVanished) {
                            sender.sendMessage(this.plugin.messages.testExceptionsTargetIsVanished.replace("{PLAYER}", target.getName()));
                        } else {
                            sender.sendMessage(this.plugin.messages.testExceptionsTargetIsNotVanished.replace("{PLAYER}", target.getName()));
                        }
                        return true;
                    }
                    LocalUtils.send(sender, "&cUsage: /alonsojoin testexceptions <player>");
                }
                return true;
            }
            if (this.fakeJoinList.contains(args[0].toLowerCase()) && sender.hasPermission(this.plugin.permissions.fakeJoinPermission)) {
                if (args.length > 1) {
                    if (!sender.hasPermission(this.plugin.permissions.adminPermission)) {
                        sender.sendMessage(this.plugin.messages.noPermission);
                        return true;
                    }
                    Player target = Bukkit.getPlayer((String)args[1]);
                    if (target == null) {
                        LocalUtils.send(sender, this.plugin.messages.invalidTarget);
                        return true;
                    }
                    this.plugin.connectionListener.startJoinProcess(target, true, true);
                } else {
                    if (!(sender instanceof Player)) {
                        LocalUtils.send(sender, "&cConsole cannot do this.. Use /alonsojoin fakajoin <player>");
                        return true;
                    }
                    Player player = (Player)sender;
                    this.plugin.connectionListener.startJoinProcess(player, true, true);
                }
                return true;
            }
            if (this.fakeLeaveList.contains(args[0].toLowerCase()) && sender.hasPermission(this.plugin.permissions.fakeLeavePermission)) {
                if (args.length > 1) {
                    if (!sender.hasPermission(this.plugin.permissions.adminPermission)) {
                        sender.sendMessage(this.plugin.messages.noPermission);
                        return true;
                    }
                    Player target = Bukkit.getPlayer((String)args[1]);
                    if (target == null) {
                        LocalUtils.send(sender, this.plugin.messages.invalidTarget);
                        return true;
                    }
                    this.plugin.connectionListener.startQuitProcess(target, true);
                } else {
                    if (!(sender instanceof Player)) {
                        LocalUtils.send(sender, "&cConsole cannot do this.. Use /alonsojoin fakaleave <player>");
                        return true;
                    }
                    Player player = (Player)sender;
                    this.plugin.connectionListener.startQuitProcess(player, true);
                }
                return true;
            }
            if (args[0].equalsIgnoreCase("testaction") && sender.hasPermission(this.plugin.permissions.adminPermission)) {
                String action;
                Player player;
                if (this.testServer && !sender.isOp()) {
                    Player player2 = (Player)sender;
                    LocalUtils.send((CommandSender)player2, this.testReloadError.replace("{PLAYER}", sender.getName()));
                    player2.playSound(player2.getLocation(), Sounds.ANVIL_LAND.getSound(), 1.0f, 1.0f);
                    player2.playSound(player2.getLocation(), Sounds.ANVIL_LAND.getSound(), 1.0f, 1.0f);
                    return true;
                }
                if (args.length <= 1) {
                    LocalUtils.send(sender, "&cUsage: /alonsojoin testaction [ACTION]");
                    return true;
                }
                if (!(sender instanceof Player)) {
                    player = Bukkit.getPlayer((String)args[1]);
                    if (player == null) {
                        LocalUtils.send(sender, this.plugin.messages.invalidTarget);
                        return true;
                    }
                    if (args.length <= 2) {
                        LocalUtils.send(sender, "&cUsage: /alonsojoin testaction [player] [ACTION]");
                        return true;
                    }
                    action = String.join((CharSequence)" ", Arrays.copyOfRange(args, 2, args.length));
                } else {
                    player = (Player)sender;
                    action = String.join((CharSequence)" ", Arrays.copyOfRange(args, 1, args.length));
                }
                CommandData commandData = new CommandData(action);
                if (commandData.getCommandType().requiresOP() && !sender.isOp()) {
                    LocalUtils.send(sender, "&cTo test this 'command' OP is required as it makes possible to run commands on console or broadcast messages to the entire server.");
                    return true;
                }
                commandData.performCommand(player);
                return true;
            }
            if (args[0].equalsIgnoreCase("testformat") && sender.hasPermission(this.plugin.permissions.adminPermission)) {
                if (!(sender instanceof Player)) {
                    LocalUtils.send(sender, "&cConsole cannot execute this command.");
                    return true;
                }
                if (this.testServer && !sender.isOp()) {
                    Player player = (Player)sender;
                    LocalUtils.send((CommandSender)player, this.testError.replace("{PLAYER}", sender.getName()));
                    player.playSound(player.getLocation(), Sounds.ANVIL_LAND.getSound(), 1.0f, 1.0f);
                    player.playSound(player.getLocation(), Sounds.ANVIL_LAND.getSound(), 1.0f, 1.0f);
                    return true;
                }
                Player player = (Player)sender;
                if (this.testingMap.containsKey(player.getUniqueId())) {
                    sender.sendMessage(this.plugin.messages.alreadyTesting);
                    return true;
                }
                if (args.length >= 2) {
                    String identifier = args[1];
                    if (!this.plugin.joinMessagesMap.containsKey(identifier)) {
                        sender.sendMessage(this.plugin.messages.invalidIdentifier);
                        return true;
                    }
                    JoinMessage joinMessage = this.plugin.joinMessagesMap.get(identifier);
                    player.sendMessage(this.plugin.messages.testingJoin);
                    this.plugin.connectionListener.performJoinMessage(player, joinMessage, false);
                    player.sendMessage(this.plugin.messages.testingQuitDelay);
                    BukkitTask bukkitTask = Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
                        if (player.isOnline()) {
                            player.sendMessage(this.plugin.messages.testingQuit);
                            this.plugin.connectionListener.performQuitMessage(player, joinMessage, false);
                        }
                        this.testingMap.remove(player.getUniqueId());
                    }, 40L);
                    this.testingMap.put(player.getUniqueId(), bukkitTask);
                    return true;
                }
                sender.sendMessage(LocalUtils.colorize("&cUsage: /alonsojoin testformat <identifier>"));
                return true;
            }
            if (args[0].equalsIgnoreCase("testjoin") && sender.hasPermission(this.plugin.permissions.adminPermission)) {
                if (!(sender instanceof Player)) {
                    LocalUtils.send(sender, "&cConsole cannot execute this command.");
                    return true;
                }
                if (this.testServer && !sender.isOp()) {
                    Player player = (Player)sender;
                    LocalUtils.send((CommandSender)player, this.testError.replace("{PLAYER}", sender.getName()));
                    player.playSound(player.getLocation(), Sounds.ANVIL_LAND.getSound(), 1.0f, 1.0f);
                    player.playSound(player.getLocation(), Sounds.ANVIL_LAND.getSound(), 1.0f, 1.0f);
                    return true;
                }
                if (args.length >= 2) {
                    Player target = Bukkit.getPlayer((String)args[1]);
                    if (target == null) {
                        sender.sendMessage(this.plugin.messages.invalidTarget);
                        return true;
                    }
                    for (Map.Entry<String, JoinMessage> entry2 : this.plugin.joinMessagesMap.entrySet()) {
                        if (!entry2.getValue().hasPermission(target)) continue;
                        sender.sendMessage(this.plugin.messages.runningTestJoinForPlayer.replace("{IDENTIFIER}", entry2.getKey()).replace("{PLAYER}", target.getName()));
                        JoinMessage joinMessage = entry2.getValue();
                        Component component = joinMessage.buildJoinMessage(target);
                        Player player = (Player)sender;
                        if (component != null) {
                            AdventureUtils.player(player).sendMessage(component);
                        }
                        if (joinMessage.hasJoinSound()) {
                            player.playSound(player.getLocation(), joinMessage.getJoinSound(), 1.0f, 1.0f);
                        }
                        return true;
                    }
                    sender.sendMessage(this.plugin.messages.testNotAvailableForPlayer.replace("{PLAYER}", target.getName()));
                    return true;
                }
                sender.sendMessage(LocalUtils.colorize("&cUsage: /alonsojoin testjoin <player>"));
                return true;
            }
            if (args[0].equalsIgnoreCase("testquit") && sender.hasPermission(this.plugin.permissions.adminPermission)) {
                if (!(sender instanceof Player)) {
                    LocalUtils.send(sender, "&cConsole cannot execute this command.");
                    return true;
                }
                if (this.testServer && !sender.isOp()) {
                    Player player = (Player)sender;
                    LocalUtils.send((CommandSender)player, this.testError.replace("{PLAYER}", sender.getName()));
                    player.playSound(player.getLocation(), Sounds.ANVIL_LAND.getSound(), 1.0f, 1.0f);
                    player.playSound(player.getLocation(), Sounds.ANVIL_LAND.getSound(), 1.0f, 1.0f);
                    return true;
                }
                if (args.length >= 2) {
                    Player target = Bukkit.getPlayer((String)args[1]);
                    if (target == null) {
                        sender.sendMessage(this.plugin.messages.invalidTarget);
                        return true;
                    }
                    for (Map.Entry<String, JoinMessage> entry3 : this.plugin.joinMessagesMap.entrySet()) {
                        if (!entry3.getValue().hasPermission(target)) continue;
                        sender.sendMessage(this.plugin.messages.runningTestQuitForPlayer.replace("{IDENTIFIER}", entry3.getKey()).replace("{PLAYER}", target.getName()));
                        JoinMessage joinMessage = entry3.getValue();
                        Component component = joinMessage.buildQuitMessage(target);
                        Player player = (Player)sender;
                        if (component != null) {
                            AdventureUtils.player(player).sendMessage(component);
                        }
                        if (joinMessage.hasQuitSound()) {
                            player.playSound(player.getLocation(), joinMessage.getQuitSound(), 1.0f, 1.0f);
                        }
                        return true;
                    }
                    sender.sendMessage(this.plugin.messages.testNotAvailableForPlayer.replace("{PLAYER}", target.getName()));
                    return true;
                }
                sender.sendMessage(LocalUtils.colorize("&cUsage: /alonsojoin testquit <player>"));
                return true;
            }
            if (args[0].equalsIgnoreCase("broadcastjoin") && sender.hasPermission(this.plugin.permissions.adminPermission)) {
                if (this.testServer && !sender.isOp()) {
                    Player player = (Player)sender;
                    LocalUtils.send((CommandSender)player, this.testError.replace("{PLAYER}", sender.getName()));
                    player.playSound(player.getLocation(), Sounds.ANVIL_LAND.getSound(), 1.0f, 1.0f);
                    player.playSound(player.getLocation(), Sounds.ANVIL_LAND.getSound(), 1.0f, 1.0f);
                    return true;
                }
                if (args.length >= 2) {
                    Player target = Bukkit.getPlayer((String)args[1]);
                    if (target == null) {
                        sender.sendMessage(this.plugin.messages.invalidTarget);
                        return true;
                    }
                    int delayInTicks = this.plugin.delayTicks;
                    if (args.length >= 3) {
                        try {
                            delayInTicks = Math.max(0, Integer.parseInt(args[2]));
                        }
                        catch (Throwable entry3) {
                            // empty catch block
                        }
                    }
                    if (this.testServer && sender instanceof Player && !sender.isOp()) {
                        Player player = (Player)sender;
                        LocalUtils.send((CommandSender)player, this.errorBroadcast.replace("{PLAYER}", sender.getName()));
                        player.playSound(player.getLocation(), Sounds.ANVIL_LAND.getSound(), 1.0f, 1.0f);
                        player.playSound(player.getLocation(), Sounds.ANVIL_LAND.getSound(), 1.0f, 1.0f);
                        return true;
                    }
                    for (Map.Entry<String, JoinMessage> entry4 : this.plugin.joinMessagesMap.entrySet()) {
                        if (!entry4.getValue().hasPermission(target)) continue;
                        sender.sendMessage(this.plugin.messages.runningBroadcastJoinForPlayer.replace("{IDENTIFIER}", entry4.getKey()).replace("{PLAYER}", target.getName()));
                        if (delayInTicks <= 0) {
                            if (target.isOnline()) {
                                this.plugin.connectionListener.performJoinMessage(target, entry4.getValue(), false);
                            }
                        } else {
                            Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
                                if (target.isOnline()) {
                                    this.plugin.connectionListener.performJoinMessage(target, (JoinMessage)entry4.getValue(), false);
                                }
                            }, (long)delayInTicks);
                        }
                        return true;
                    }
                    sender.sendMessage(this.plugin.messages.broadcastNotAvailableForPlayer.replace("{PLAYER}", target.getName()));
                    return true;
                }
                sender.sendMessage(LocalUtils.colorize("&cUsage: /alonsojoin broadcastjoin <player> [delay]"));
                return true;
            }
            if (args[0].equalsIgnoreCase("broadcastquit") && sender.hasPermission(this.plugin.permissions.adminPermission)) {
                if (this.testServer && !sender.isOp()) {
                    Player player = (Player)sender;
                    LocalUtils.send((CommandSender)player, this.testError.replace("{PLAYER}", sender.getName()));
                    player.playSound(player.getLocation(), Sounds.ANVIL_LAND.getSound(), 1.0f, 1.0f);
                    player.playSound(player.getLocation(), Sounds.ANVIL_LAND.getSound(), 1.0f, 1.0f);
                    return true;
                }
                if (args.length >= 2) {
                    Player target = Bukkit.getPlayer((String)args[1]);
                    if (target == null) {
                        sender.sendMessage(this.plugin.messages.invalidTarget);
                        return true;
                    }
                    if (this.testServer && sender instanceof Player && !sender.isOp()) {
                        Player player = (Player)sender;
                        LocalUtils.send((CommandSender)player, this.errorBroadcast.replace("{PLAYER}", sender.getName()));
                        player.playSound(player.getLocation(), Sounds.ANVIL_LAND.getSound(), 1.0f, 1.0f);
                        player.playSound(player.getLocation(), Sounds.ANVIL_LAND.getSound(), 1.0f, 1.0f);
                        return true;
                    }
                    for (Map.Entry<String, JoinMessage> entry5 : this.plugin.joinMessagesMap.entrySet()) {
                        if (!entry5.getValue().hasPermission(target)) continue;
                        sender.sendMessage(this.plugin.messages.runningBroadcastQuitForPlayer.replace("{IDENTIFIER}", entry5.getKey()).replace("{PLAYER}", target.getName()));
                        if (target.isOnline()) {
                            this.plugin.connectionListener.performQuitMessage(target, entry5.getValue());
                        }
                        return true;
                    }
                    sender.sendMessage(this.plugin.messages.broadcastNotAvailableForPlayer.replace("{PLAYER}", target.getName()));
                    return true;
                }
                sender.sendMessage(LocalUtils.colorize("&cUsage: /alonsojoin broadcastquit <player>"));
                return true;
            }
            if (args[0].equalsIgnoreCase("reload") && sender.hasPermission(this.plugin.permissions.adminPermission)) {
                if (this.testServer && sender instanceof Player && !sender.isOp()) {
                    Player player = (Player)sender;
                    LocalUtils.send((CommandSender)player, this.testReloadError.replace("{PLAYER}", sender.getName()));
                    player.playSound(player.getLocation(), Sounds.ANVIL_LAND.getSound(), 1.0f, 1.0f);
                    return true;
                }
                this.plugin.getFiles().getConfig().reload();
                this.plugin.getFiles().getFormats().reload();
                this.plugin.reloadMessages();
                this.reloadMessages();
                this.plugin.messages.reloadMessages();
                this.plugin.permissions.reloadMessages();
                this.plugin.connectionListener.reloadMessages();
                if (this.plugin.authListener != null) {
                    this.plugin.authListener.reloadMessages();
                }
                this.plugin.damageListener.reloadMessages();
                sender.sendMessage(this.plugin.messages.reloaded);
                return true;
            }
        }
        LocalUtils.send(sender, " ");
        LocalUtils.send(sender, AlonsoUtils.second + "&l" + "AlonsoJoin" + " " + AlonsoUtils.first + "by " + AlonsoUtils.second + "&lAlonsoAliaga " + AlonsoUtils.first + "Version &6" + this.plugin.getDescription().getVersion());
        if (sender.hasPermission(this.plugin.permissions.adminPermission)) {
            for (String line : this.plugin.messages.adminHelpList) {
                sender.sendMessage(line);
            }
        } else {
            for (String line : this.plugin.messages.userHelpList) {
                sender.sendMessage(line);
            }
        }
        LocalUtils.send(sender, " ");
        if (sender instanceof Player) {
            Player player = (Player)sender;
            player.playSound(player.getLocation(), Sounds.PICKUP.getSound(), 1.0f, 1.0f);
        }
        return true;
    }

    @Override
    public List<String> onTabComplete(CommandSender sender, Command cmd, String label, String[] args) {
        if (args.length >= 1) {
            if (args.length == 1) {
                return sender.hasPermission(this.plugin.permissions.adminPermission) ? this.adminList : this.userList;
            }
            if (sender.hasPermission(this.plugin.permissions.adminPermission) && this.adminList.contains(args[0].toLowerCase())) {
                if (args[0].equalsIgnoreCase("testformat") && args.length == 2) {
                    return new ArrayList<String>(this.plugin.joinMessagesMap.keySet());
                }
                if (args[0].equalsIgnoreCase("broadcastjoin") && args.length == 3) {
                    return Arrays.asList("0", "10", "20", "30", "40", "50", "60", "70", "80", "90", "100");
                }
            }
        }
        return this.onlinePlayers(sender, args);
    }
}

