/*
 * Decompiled with CFR 0.152.
 */
package com.alonsoaliaga.alonsojoin.api;

import com.alonsoaliaga.alonsojoin.AlonsoJoin;
import com.alonsoaliaga.alonsojoin.others.JoinMessage;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.clip.placeholderapi.PlaceholderAPI;
import org.bukkit.entity.Player;

public class AlonsoJoinAPI {
    private static AlonsoJoin plugin = AlonsoJoin.getInstance();

    public static void sendJoinMessage(@Nonnull Player player, boolean isAsync) {
        if (player == null || !player.isOnline()) {
            return;
        }
        AlonsoJoinAPI.plugin.connectionListener.performJoinMessage(player, isAsync);
    }

    public static void sendJoinMessage(@Nonnull Player player, boolean runAsync, int delayInTicks) {
        if (player == null || !player.isOnline()) {
            return;
        }
        AlonsoJoinAPI.plugin.connectionListener.performJoinMessage(player, runAsync, delayInTicks);
    }

    public static void sendQuitMessage(@Nonnull Player player, boolean isAsync) {
        if (player == null || !player.isOnline()) {
            return;
        }
        AlonsoJoinAPI.plugin.connectionListener.performQuitMessage(player, isAsync);
    }

    @Nullable
    public static JoinMessage getJoinMessage(@Nonnull Player player) {
        for (Map.Entry<String, JoinMessage> entry : AlonsoJoinAPI.plugin.joinMessagesMap.entrySet()) {
            if (!entry.getValue().hasPermission(player)) continue;
            return entry.getValue();
        }
        return null;
    }

    @Nullable
    public static JoinMessage getJoinMessage(String identifier) {
        return AlonsoJoinAPI.plugin.joinMessagesMap.get(identifier);
    }

    @Nullable
    public static JoinMessage getJoinMessage(String identifier, boolean ignoreCase) {
        if (!ignoreCase) {
            return AlonsoJoinAPI.plugin.joinMessagesMap.get(identifier);
        }
        for (Map.Entry<String, JoinMessage> entry : AlonsoJoinAPI.plugin.joinMessagesMap.entrySet()) {
            if (!entry.getKey().equalsIgnoreCase(identifier)) continue;
            return entry.getValue();
        }
        return null;
    }

    public static boolean isInvisible(@Nonnull Player player) {
        if (player == null || !player.isOnline()) {
            return false;
        }
        if (player.hasPermission(AlonsoJoinAPI.plugin.permissions.staffPermission)) {
            for (String string : AlonsoJoinAPI.plugin.ignoreMetadatas) {
                if (!player.hasMetadata(string)) continue;
                return true;
            }
            if (plugin.getPluginUtils().isPlaceholderApiSupported()) {
                for (Map.Entry entry : AlonsoJoinAPI.plugin.exceptionPlaceholdersMap.entrySet()) {
                    if (!PlaceholderAPI.setPlaceholders((Player)player, (String)((String)entry.getValue())).equals(entry.getValue())) continue;
                    return true;
                }
            }
        }
        return false;
    }
}

