/*
 * Decompiled with CFR 0.152.
 */
package com.alonsoaliaga.alonsojoin;

import com.alonsoaliaga.alonsojoin.commands.MainCommand;
import com.alonsoaliaga.alonsojoin.enums.ActionType;
import com.alonsoaliaga.alonsojoin.hooks.PlaceholderAPIHook;
import com.alonsoaliaga.alonsojoin.listeners.AuthListener;
import com.alonsoaliaga.alonsojoin.listeners.BungeeMessageListener;
import com.alonsoaliaga.alonsojoin.listeners.ConnectionListener;
import com.alonsoaliaga.alonsojoin.listeners.DamageListener;
import com.alonsoaliaga.alonsojoin.metrics.Metrics;
import com.alonsoaliaga.alonsojoin.others.CommandData;
import com.alonsoaliaga.alonsojoin.others.FileManager;
import com.alonsoaliaga.alonsojoin.others.JoinMessage;
import com.alonsoaliaga.alonsojoin.others.Messages;
import com.alonsoaliaga.alonsojoin.others.PartBuilder;
import com.alonsoaliaga.alonsojoin.others.Permissions;
import com.alonsoaliaga.alonsojoin.utils.AdventureUtils;
import com.alonsoaliaga.alonsojoin.utils.AlonsoUtils;
import com.alonsoaliaga.alonsojoin.utils.BungeeUtils;
import com.alonsoaliaga.alonsojoin.utils.LocalUtils;
import com.alonsoaliaga.alonsojoin.utils.SafeLogger;
import java.io.File;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.Bukkit;
import org.bukkit.Sound;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class AlonsoJoin
extends JavaPlugin
implements AlonsoUtils.AlonsoPlugin {
    private static AlonsoJoin instance;
    private AlonsoUtils.PluginUtils pluginUtils;
    private FileManager fileManager;
    private BungeeMessageListener bungeeMessageListener = null;
    private AlonsoUtils.Updater updater = null;
    public MainCommand mainCommand;
    public Messages messages;
    public Permissions permissions;
    private int bStatsID = 10764;
    private String resourceID = "108505";
    public int delayTicks = 60;
    public boolean debugMode = false;
    public boolean authMeSupport = false;
    public boolean removeJoinDefault = true;
    public boolean removeQuitDefault = true;
    public boolean whitelistMode = false;
    public boolean asyncMode = false;
    public boolean preventSpam = true;
    public boolean fireworkNoDamage = true;
    public boolean notifySilentJoin = true;
    public boolean exceptionsEnabled = false;
    public List<String> whitelistedWorlds;
    public List<String> ignoreMetadatas;
    public LinkedHashMap<String, JoinMessage> joinMessagesMap;
    public LinkedHashMap<String, String> exceptionPlaceholdersMap;
    public HashMap<String, String> booksMap = new HashMap();
    public ConnectionListener connectionListener;
    public DamageListener damageListener;
    public AuthListener authListener = null;
    private final String HEADER = "                 _   _                     _     _                           Our plugins: https://alonsoaliaga.com/plugins\n                /_\\ | |___ _ _  ___ ___ _ | |___(_)_ _                       Support server: https://alonsoaliaga.com/discord\n               / _ \\| / _ \\ ' \\(_-</ _ \\ || / _ \\ | ' \\                      Youtube: https://alonsoaliaga.com/play\n              /_/ \\_\\_\\___/_||_/__/\\___/\\__/\\___/_|_||_|                     Test server: plugins.alonsoaliaga.com\n                           by AlonsoAliaga                                   Twitch: https://alonsoaliaga.com/twitch\n        Considering donating? https://alonsoaliaga.com/donate                Thanks for downloading my plugin <3.\n  ======================================================================================================================================\n  |              Downloaded this jar in a server setup? Tell the author he is NOT allowed to upload someone else work!                 |\n  |   Update to latest version as soon as possible. Support WON'T be given when using old versions. Specially from downloaded setups.  |\n  | Remember: Support is only provided for .jar files downloaded DIRECTLY from spigotmc.org! Other files will be considered as invalid |\n  |        as they are NOT the same .jar file the developer (me) uploaded and I cannot guarantee that the file is safe or not.         |\n  |                   If you have issues with setup configs. Tell the setup author to update his config file.                          |\n  ======================================================================================================================================";

    public void onEnable() {
        instance = this;
        if (!Bukkit.getPluginManager().isPluginEnabled("AlonsoLib")) {
            SafeLogger.loge("================================================================================");
            SafeLogger.loge("This plugin requires AlonsoLib. AlonsoLib is needed for this plugin to work.");
            SafeLogger.loge("AlonsoLib is a library with necessary classes for this plugin to work!");
            SafeLogger.loge("Download latest version of AlonsoLib in https://alonsoaliaga.com/AlonsoLib");
            SafeLogger.loge("Please install AlonsoLib to use this plugin or it won't work. Disabling plugin..");
            SafeLogger.loge("For more questions join us on https://alonsoaliaga.com/discord");
            SafeLogger.loge("================================================================================");
            Bukkit.getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        if (!Bukkit.getPluginManager().isPluginEnabled("NBTAPI")) {
            SafeLogger.loge("================================================================================");
            SafeLogger.loge("This plugin requires NBTAPI. NBTAPI is needed for this plugin to work.");
            SafeLogger.loge("NBTAPI is a library with necessary classes for this plugin to work!");
            SafeLogger.loge("Download latest version of NBTAPI in https://alonsoaliaga.com/NBTAPI");
            SafeLogger.loge("Please install NBTAPI to use this plugin or it won't work. Disabling plugin..");
            SafeLogger.loge("For more questions join us on https://alonsoaliaga.com/discord");
            SafeLogger.loge("================================================================================");
            Bukkit.getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        AlonsoUtils.sendEnableText(this);
        AlonsoUtils.isSupported();
        AdventureUtils.createAudience();
        this.joinMessagesMap = new LinkedHashMap();
        this.exceptionPlaceholdersMap = new LinkedHashMap();
        this.pluginUtils = new AlonsoUtils.PluginUtils(this);
        this.fileManager = new FileManager(this);
        this.updateConfigurations();
        this.reloadMessages();
        this.mainCommand = new MainCommand(this, "alonsojoin", this.getFiles().getConfig().get().getStringList("Options.Command.Aliases"), "AlonsoJoin main command.");
        this.messages = new Messages(this);
        this.permissions = new Permissions(this);
        this.connectionListener = new ConnectionListener(this);
        this.damageListener = new DamageListener(this);
        if (Bukkit.getPluginManager().getPlugin("AuthMe") != null) {
            this.authListener = new AuthListener(this);
        }
        if (this.pluginUtils.isPlaceholderApiSupported()) {
            new PlaceholderAPIHook(this, "alonsojoin");
        }
        if (this.bStatsID != 0) {
            Metrics metrics = new Metrics((Plugin)this, this.bStatsID);
            metrics.addCustomChart(new Metrics.SimplePie("server_type", () -> LocalUtils.firstCase(AlonsoUtils.serverType.name())));
            metrics.addCustomChart(new Metrics.SimplePie("protocollib_hooked", () -> this.pluginUtils.isProtocolLibSupported() ? "Yes" : "No"));
            metrics.addCustomChart(new Metrics.SimplePie("placeholderapi_hooked", () -> this.pluginUtils.isPlaceholderApiSupported() ? "Yes" : "No"));
            metrics.addCustomChart(new Metrics.SimplePie("nbtapi_hooked", () -> this.pluginUtils.isNbtApiSupported() ? "Yes" : "No"));
            Bukkit.getScheduler().runTaskLater((Plugin)this, () -> metrics.addCustomChart(new Metrics.AdvancedPie("plugins_from_alonsoaliaga", () -> {
                HashMap<String, Integer> pluginsFromAlonsoAliaga = new HashMap<String, Integer>();
                for (Plugin registeredPlugin : this.getServer().getPluginManager().getPlugins()) {
                    if (!registeredPlugin.getDescription().getAuthors().contains("AlonsoAliaga") || registeredPlugin.getName().equalsIgnoreCase(this.getDescription().getName())) continue;
                    pluginsFromAlonsoAliaga.put(registeredPlugin.getName(), 1);
                }
                return pluginsFromAlonsoAliaga;
            })), 1200L);
        }
        if (this.getFiles().getConfig().get().getBoolean("Updates.Check-updates", true)) {
            this.updater = new AlonsoUtils.Updater(this, this.resourceID, this.getFiles().getConfig().get().getBoolean("Updates.Notify-updates", true), this.getFiles().getConfig().get().getString("Updates.Permission", null), this.getFiles().getConfig().get().getString("Updates.Message", null));
        }
        if (BungeeUtils.isAvailable()) {
            this.bungeeMessageListener = new BungeeMessageListener(this);
            BungeeUtils.registerIncomingChannel(this.bungeeMessageListener);
            BungeeUtils.registerChannel();
        }
    }

    public void onDisable() {
        if (BungeeUtils.isAvailable()) {
            BungeeUtils.unregisterChannel();
        }
        try {
            if (Bukkit.getPluginManager().getPlugin("AlonsoLib") != null) {
                AdventureUtils.stopAudience();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        AlonsoUtils.sendDisableText();
    }

    @Override
    public AlonsoJoin getMain() {
        return this;
    }

    public void reloadMessages() {
        LocalUtils.setFixColors(this.getFiles().getConfig().get().getBoolean("Options.Colors.Fix", true));
        this.debugMode = this.getFiles().getConfig().get().getBoolean("Options.Debug", false);
        this.authMeSupport = Bukkit.getPluginManager().getPlugin("AuthMe") != null && this.getFiles().getConfig().get().getBoolean("Options.Hooks.AuthMe.Enabled", true);
        this.preventSpam = this.authMeSupport && this.getFiles().getConfig().get().getBoolean("Options.Hooks.AuthMe.Prevent-spam", true);
        this.delayTicks = Math.max(0, this.getFiles().getConfig().get().getInt("Options.Delay", 60));
        this.asyncMode = this.getFiles().getConfig().get().getBoolean("Options.Async-mode", false);
        this.removeJoinDefault = this.getFiles().getConfig().get().getBoolean("Options.Remove-default", true);
        this.exceptionsEnabled = this.getFiles().getConfig().get().getBoolean("Options.Exceptions.Enabled", false);
        this.whitelistMode = this.getFiles().getConfig().get().getBoolean("Options.Whitelist.Enabled", false);
        this.whitelistedWorlds = this.getFiles().getConfig().get().getStringList("Options.Whitelist.Worlds");
        this.notifySilentJoin = this.getFiles().getConfig().get().getBoolean("Options.Exceptions.Notify-player", true);
        this.fireworkNoDamage = !this.getFiles().getConfig().get().getBoolean("Options.Firework-damage", false);
        this.ignoreMetadatas = this.getFiles().getConfig().get().getStringList("Options.Exceptions.Metadatas");
        ConfigurationSection exceptionPlaceholderSection = this.getFiles().getConfig().get().getConfigurationSection("Options.Exceptions.Placeholders");
        this.exceptionPlaceholdersMap.clear();
        if (this.exceptionsEnabled) {
            if (exceptionPlaceholderSection != null) {
                for (String placeholderKey : exceptionPlaceholderSection.getKeys(false)) {
                    String expected = exceptionPlaceholderSection.getString(placeholderKey);
                    this.exceptionPlaceholdersMap.put(placeholderKey, expected);
                }
                LocalUtils.logp("Successfully loaded " + this.exceptionPlaceholdersMap.size() + " placeholders for exceptions feature.");
                LocalUtils.logp("PlaceholderAPI is required for this feature to work. If it's not installed it will be ignored.");
            } else {
                LocalUtils.logp("Section 'Options.Exceptions.Placeholder' is not available. Ignoring..");
            }
        } else {
            LocalUtils.logp("Exceptions are not enabled. Ignoring 'Staff' members..");
        }
        this.loadBooks();
        this.loadFormats();
    }

    private void loadBooks() {
        File[] files;
        this.booksMap.clear();
        File booksDirectory = new File(this.getDataFolder(), "books/");
        if (!booksDirectory.exists() && booksDirectory.mkdir()) {
            LocalUtils.logp("Creating datafolder '/AlonsoJoin/books/ ..'");
            this.saveResource("books/defaultbook.txt", false);
        }
        if ((files = booksDirectory.listFiles()) == null) {
            LocalUtils.logp("AlonsoJoin/books/ doesn't exist. Ignoring books..");
        } else {
            for (File bookFile : files) {
                if (this.debugMode) {
                    LocalUtils.logp("Loading AlonsoJoin/books/" + bookFile.getName() + "...");
                }
                if (bookFile.getName().endsWith(".txt")) {
                    try {
                        String bookData = new String(Files.readAllBytes(bookFile.toPath()));
                        Matcher matcher = Pattern.compile("\\{pages:.*}").matcher(bookData);
                        if (matcher.find()) {
                            String match = matcher.group(0);
                            if (this.pluginUtils.getServerVersion().isOlderEqualThan(AlonsoUtils.ServerVersion.v1_14)) {
                                if (match.equals("{pages:['[\"\",{\"text\":\"Thanks for downloading my plugin!\\\\n\\\\nDon\\'t forget we support \",\"color\":\"dark_gray\"},{\"text\":\"PlaceholderAPI \",\"color\":\"gold\"},{\"text\":\"%player_name%\",\"color\":\"light_purple\"},{\"text\":\"!\\\\n\\\\nWanna get creative?\",\"color\":\"dark_gray\"},{\"text\":\"\\\\n\",\"color\":\"reset\"},{\"text\":\"[\\\\u274c]\",\"color\":\"dark_red\",\"clickEvent\":{\"action\":\"run_command\",\"value\":\"/gamemode survival\"},\"hoverEvent\":{\"action\":\"show_text\",\"contents\":\"\u00a7cNo\"}},{\"text\":\"  \",\"color\":\"white\"},{\"text\":\"[\\\\u2714]\",\"color\":\"dark_green\",\"clickEvent\":{\"action\":\"run_command\",\"value\":\"/gamemode creative\"},\"hoverEvent\":{\"action\":\"show_text\",\"contents\":\"\u00a72Yes\"}},{\"text\":\"\\\\n\\\\n\",\"color\":\"reset\"},{\"text\":\"Don\\'t forget to rate us\",\"color\":\"dark_gray\"},{\"text\":\" \\\\u2605\\\\u2605\\\\u2605\\\\u2605\\\\u2605\",\"color\":\"gold\"},{\"text\":\" on SpigotMC!\",\"color\":\"dark_gray\"},{\"text\":\" \",\"color\":\"reset\"},{\"text\":\"Click here\",\"color\":\"dark_blue\",\"clickEvent\":{\"action\":\"open_url\",\"value\":\"https://alonsoaliaga.com/AlonsoJoin\"},\"hoverEvent\":{\"action\":\"show_text\",\"contents\":\"\u00a7eClick me!\"}},{\"text\":\".\",\"color\":\"reset\"}]'],title:\"\u00a76\u00a7lNews!\",author:\"http://alonsoaliaga.com/discord\",display:{Lore:[\"&7Our latest news!\"]}}")) {
                                    LocalUtils.logp("Default book detected. Attempting to adapt it to your current server version..");
                                    this.booksMap.put(bookFile.getName().substring(0, bookFile.getName().length() - 4), "{pages:[\"[\\\"\\\",{\\\"text\\\":\\\"Thanks for downloading my plugin!\\\\n\\\\nDon't forget we support \\\",\\\"color\\\":\\\"dark_gray\\\"},{\\\"text\\\":\\\"PlaceholderAPI\\\",\\\"color\\\":\\\"gold\\\"},{\\\"text\\\":\\\" %player_name%\\\",\\\"color\\\":\\\"light_purple\\\"},{\\\"text\\\":\\\"\\\\n\\\\n\\\",\\\"color\\\":\\\"reset\\\"},{\\\"text\\\":\\\"Wanna get creative?\\\\n    \\\",\\\"color\\\":\\\"dark_gray\\\"},{\\\"text\\\":\\\"[\\\\u2714]\\\",\\\"color\\\":\\\"dark_green\\\",\\\"clickEvent\\\":{\\\"action\\\":\\\"run_command\\\",\\\"value\\\":\\\"/gamemode creative\\\"},\\\"hoverEvent\\\":{\\\"action\\\":\\\"show_text\\\",\\\"value\\\":\\\"\u00a72Yes\\\"}},{\\\"text\\\":\\\"     \\\",\\\"color\\\":\\\"dark_gray\\\"},{\\\"text\\\":\\\"[\u2716]\\\",\\\"color\\\":\\\"dark_red\\\",\\\"clickEvent\\\":{\\\"action\\\":\\\"run_command\\\",\\\"value\\\":\\\"/gamemode survival\\\"},\\\"hoverEvent\\\":{\\\"action\\\":\\\"show_text\\\",\\\"value\\\":\\\"\u00a74No\\\"}},{\\\"text\\\":\\\"\\\\n\\\",\\\"color\\\":\\\"reset\\\"},{\\\"text\\\":\\\"Don't forget to rate us\\\",\\\"color\\\":\\\"dark_gray\\\"},{\\\"text\\\":\\\" \\\\u2b50\\\\u2b50\\\\u2b50\\\\u2b50\\\\u2b50\\\",\\\"color\\\":\\\"gold\\\"},{\\\"text\\\":\\\" on SpigotMC!\\\\n    \\\",\\\"color\\\":\\\"dark_gray\\\"},{\\\"text\\\":\\\"Click here!\\\",\\\"color\\\":\\\"dark_gray\\\",\\\"clickEvent\\\":{\\\"action\\\":\\\"open_url\\\",\\\"value\\\":\\\"https://alonsoaliaga.com/discord\\\"},\\\"hoverEvent\\\":{\\\"action\\\":\\\"show_text\\\",\\\"value\\\":\\\"\u00a79\u00a7lClick me now!\\\"}}]\"],title:\"\u00a76\u00a7lNews!\",author:\"http://alonsoaliaga.com/discord\",display:{Lore:[\"\u00a77Our latest news!\"]}}");
                                    continue;
                                }
                                this.booksMap.put(bookFile.getName().substring(0, bookFile.getName().length() - 4), match);
                                continue;
                            }
                            this.booksMap.put(bookFile.getName().substring(0, bookFile.getName().length() - 4), match);
                            continue;
                        }
                        LocalUtils.logp("Error loading file AlonsoJoin/books/" + bookFile.getName() + ". File doesn't contain valid book!");
                    }
                    catch (Throwable e) {
                        if (this.debugMode) {
                            LocalUtils.logp("Error loading file AlonsoJoin/books/" + bookFile.getName() + ". Stacktrace below is due to enabled debug mode.");
                            e.printStackTrace();
                            continue;
                        }
                        LocalUtils.logp("Error loading file AlonsoJoin/books/" + bookFile.getName() + ". Error: " + e.getMessage());
                    }
                    continue;
                }
                LocalUtils.logp("File AlonsoJoin/books/" + bookFile.getName() + " is not valid book file. Skipping..");
            }
            if (this.booksMap.isEmpty()) {
                LocalUtils.logp("Couldn't load any book from AlonsoJoin/books/ folder. Skipping books..");
            } else {
                if (!this.pluginUtils.isNbtApiSupported()) {
                    LocalUtils.logp("Remember that NBTAPI is necessary for books feature! Download on https://alonsoaliaga.com/NBTAPI");
                }
                LocalUtils.logp("Successfully loaded " + this.booksMap.size() + " books!");
            }
        }
    }

    private void loadFormats() {
        this.joinMessagesMap.clear();
        ConfigurationSection formatsSection = this.getFiles().getFormats().get().getConfigurationSection("Formats");
        if (formatsSection != null) {
            for (String sectionKey : formatsSection.getKeys(false)) {
                ConfigurationSection formatSection = formatsSection.getConfigurationSection(sectionKey);
                String permission = formatSection.getString("Permission", "alonsojoin.format." + sectionKey.toLowerCase(Locale.US).replace("\\s+", "-"));
                if (permission.equalsIgnoreCase("none")) {
                    permission = null;
                }
                Sound joinSound = null;
                if (formatSection.contains("Sounds.Join")) {
                    String soundString = formatSection.getString("Sounds.Join", "none");
                    if (!soundString.equalsIgnoreCase("none")) {
                        joinSound = LocalUtils.getSound(soundString);
                        if (joinSound == null) {
                            LocalUtils.logp("Sound for format '" + sectionKey + "' is not valid. Skipping joinSound effect..");
                        }
                    } else {
                        LocalUtils.logp("Sound for format '" + sectionKey + "' is 'none'. Skipping joinSound effect..");
                    }
                }
                Sound quitSound = null;
                if (formatSection.contains("Sounds.Quit")) {
                    String soundString = formatSection.getString("Sounds.Quit", "none");
                    if (!soundString.equalsIgnoreCase("none")) {
                        quitSound = LocalUtils.getSound(soundString);
                        if (quitSound == null) {
                            LocalUtils.logp("Sound for format '" + sectionKey + "' is not valid. Skipping quitSound effect..");
                        }
                    } else {
                        LocalUtils.logp("Sound for format '" + sectionKey + "' is 'none'. Skipping quitSound effect..");
                    }
                }
                LinkedHashMap<String, PartBuilder> joinParts = new LinkedHashMap<String, PartBuilder>();
                if (formatSection.contains("Join-messages")) {
                    ConfigurationSection messagesSection = formatSection.getConfigurationSection("Join-messages");
                    for (Object messageSectionKey : messagesSection.getKeys(false)) {
                        ConfigurationSection partSection = messagesSection.getConfigurationSection((String)messageSectionKey);
                        if (partSection.contains("Text")) {
                            String text = partSection.getString("Text");
                            List hover = null;
                            if (partSection.contains("Hover") && (hover = partSection.getStringList("Hover")).isEmpty()) {
                                hover = null;
                            }
                            ActionType action = null;
                            String value = null;
                            if (partSection.contains("Click")) {
                                ConfigurationSection clickSection = partSection.getConfigurationSection("Click");
                                String actionString = clickSection.getString("Type", "none");
                                action = ActionType.getActionType(actionString, null);
                                if (action != null) {
                                    if (clickSection.contains("Value")) {
                                        value = clickSection.getString("Value");
                                    } else {
                                        action = null;
                                        value = null;
                                        LocalUtils.logp("Format '" + sectionKey + "' part '" + (String)messageSectionKey + "' doesn't have a 'Value' specified. Skipping action..");
                                    }
                                } else {
                                    LocalUtils.logp("Format '" + sectionKey + "' part '" + (String)messageSectionKey + "' doesn't have a valid 'Action' specified (" + actionString + "). Skipping action..");
                                }
                            }
                            PartBuilder partBuilder = new PartBuilder(this, text, hover, action, value);
                            joinParts.put((String)messageSectionKey, partBuilder);
                            continue;
                        }
                        LocalUtils.logp("Format '" + sectionKey + "' part '" + (String)messageSectionKey + "' doesn't have 'Text' specified. Skipping..");
                    }
                    if (joinParts.isEmpty()) {
                        LocalUtils.logp("Format '" + sectionKey + "' doesn't have message parts loaded, make sure you specify messages. Format will not send join messages..");
                    }
                } else {
                    LocalUtils.logp("Format '" + sectionKey + "' doesn't have Messages section. Format will not send join messages..");
                }
                LinkedHashMap<String, PartBuilder> quitParts = new LinkedHashMap<String, PartBuilder>();
                if (formatSection.contains("Quit-messages")) {
                    Object messageSectionKey;
                    ConfigurationSection messagesSection = formatSection.getConfigurationSection("Quit-messages");
                    messageSectionKey = messagesSection.getKeys(false).iterator();
                    while (messageSectionKey.hasNext()) {
                        String messageSectionKey2 = (String)messageSectionKey.next();
                        ConfigurationSection partSection = messagesSection.getConfigurationSection(messageSectionKey2);
                        if (partSection.contains("Text")) {
                            String text = partSection.getString("Text");
                            List hover = null;
                            if (partSection.contains("Hover") && (hover = partSection.getStringList("Hover")).isEmpty()) {
                                hover = null;
                            }
                            ActionType action = null;
                            String value = null;
                            if (partSection.contains("Click")) {
                                ConfigurationSection clickSection = partSection.getConfigurationSection("Click");
                                String actionString = clickSection.getString("Type", "none");
                                action = ActionType.getActionType(actionString, null);
                                if (action != null) {
                                    if (clickSection.contains("Value")) {
                                        value = clickSection.getString("Value");
                                    } else {
                                        action = null;
                                        value = null;
                                        LocalUtils.logp("Format '" + sectionKey + "' part '" + (String)messageSectionKey2 + "' doesn't have a 'Value' specified. Skipping action..");
                                    }
                                } else {
                                    LocalUtils.logp("Format '" + sectionKey + "' part '" + (String)messageSectionKey2 + "' doesn't have a valid 'Action' specified (" + actionString + "). Skipping action..");
                                }
                            }
                            PartBuilder partBuilder = new PartBuilder(this, text, hover, action, value);
                            quitParts.put(messageSectionKey2, partBuilder);
                            continue;
                        }
                        LocalUtils.logp("Format '" + sectionKey + "' part '" + (String)messageSectionKey2 + "' doesn't have 'Text' specified. Skipping..");
                    }
                    if (quitParts.isEmpty()) {
                        LocalUtils.logp("Format '" + sectionKey + "' doesn't have message parts loaded, make sure you specify messages. Format will not send quit messages..");
                    }
                } else {
                    LocalUtils.logp("Format '" + sectionKey + "' doesn't have Messages section. Format will not send quit messages..");
                }
                ArrayList<CommandData> joinActions = new ArrayList<CommandData>();
                if (formatSection.contains("Actions.Join")) {
                    List actionsStringList = formatSection.getStringList("Actions.Join");
                    for (Object line : actionsStringList) {
                        joinActions.add(new CommandData((String)line));
                    }
                    LocalUtils.logp("Loaded '" + joinActions.size() + "' join actions in '" + sectionKey + "' format!");
                } else {
                    LocalUtils.logp("Format '" + sectionKey + "' doesn't have Actions section. Format will not perform join actions..");
                }
                ArrayList<CommandData> quitActions = new ArrayList<CommandData>();
                if (formatSection.contains("Actions.Quit")) {
                    Object line;
                    List actionsStringList = formatSection.getStringList("Actions.Quit");
                    line = actionsStringList.iterator();
                    while (line.hasNext()) {
                        String line2 = (String)line.next();
                        quitActions.add(new CommandData(line2));
                    }
                    LocalUtils.logp("Loaded '" + quitActions.size() + "' quit actions in '" + sectionKey + "' format!");
                } else {
                    LocalUtils.logp("Format '" + sectionKey + "' doesn't have Actions section. Format will not perform join actions..");
                }
                boolean relational = formatSection.getBoolean("Relational", false);
                JoinMessage joinMessage = new JoinMessage(joinParts, quitParts, sectionKey, permission, joinSound, quitSound, joinActions, quitActions, relational);
                this.joinMessagesMap.put(sectionKey, joinMessage);
                LocalUtils.logp("Format '" + sectionKey + "' has been loaded successfully!");
            }
        }
        LocalUtils.logp("Successfully loaded " + this.joinMessagesMap.size() + " join formats!");
    }

    public static AlonsoJoin getInstance() {
        return instance;
    }

    private void updateConfigurations() {
        this.updateConfiguration(this.getFiles().getConfig());
    }

    private void updateConfiguration(FileManager.Configuration config) {
        if (config.get().getBoolean("Updates.Auto-update-configuration", true)) {
            boolean updated = false;
            boolean bl = updated = this.addConfig(config.get(), "Updates.Auto-update-configuration", true) || updated;
            if (updated) {
                config.get().options().header("                 _   _                     _     _                           Our plugins: https://alonsoaliaga.com/plugins\n                /_\\ | |___ _ _  ___ ___ _ | |___(_)_ _                       Support server: https://alonsoaliaga.com/discord\n               / _ \\| / _ \\ ' \\(_-</ _ \\ || / _ \\ | ' \\                      Youtube: https://alonsoaliaga.com/play\n              /_/ \\_\\_\\___/_||_/__/\\___/\\__/\\___/_|_||_|                     Test server: plugins.alonsoaliaga.com\n                           by AlonsoAliaga                                   Twitch: https://alonsoaliaga.com/twitch\n        Considering donating? https://alonsoaliaga.com/donate                Thanks for downloading my plugin <3.\n  ======================================================================================================================================\n  |              Downloaded this jar in a server setup? Tell the author he is NOT allowed to upload someone else work!                 |\n  |   Update to latest version as soon as possible. Support WON'T be given when using old versions. Specially from downloaded setups.  |\n  | Remember: Support is only provided for .jar files downloaded DIRECTLY from spigotmc.org! Other files will be considered as invalid |\n  |        as they are NOT the same .jar file the developer (me) uploaded and I cannot guarantee that the file is safe or not.         |\n  |                   If you have issues with setup configs. Tell the setup author to update his config file.                          |\n  ======================================================================================================================================");
                config.save();
            }
            LocalUtils.log(AlonsoUtils.second + "[Auto-update] \u00a77Configuration " + config.getFileName() + " is up-to-date!");
        } else {
            LocalUtils.logp("&cConfiguration auto-update is not enabled! &7Ignoring " + config.getFileName() + " changes..");
            LocalUtils.logp("&cYou might get a lot of errors as you don't allow plugin to generate the new config");
            LocalUtils.logp("&cadded in new updates! Make sure you enable it and restart if you have errors.");
        }
    }

    private boolean addConfig(FileConfiguration configuration, String path, Object object) {
        if (!configuration.contains(path)) {
            configuration.set(path, object);
            LocalUtils.log(AlonsoUtils.second + "[Auto-update] \u00a77Adding default configuration in path: " + AlonsoUtils.first + path);
            return true;
        }
        return false;
    }

    private boolean delConfig(FileConfiguration configuration, String path) {
        if (configuration.contains(path)) {
            configuration.set(path, null);
            LocalUtils.log("\u00a7c[Auto-update] \u00a7cDeleting configuration in path: " + path);
            return true;
        }
        return false;
    }

    @Override
    public AlonsoUtils.PluginUtils getPluginUtils() {
        return this.pluginUtils;
    }

    @Override
    public FileManager getFiles() {
        return this.fileManager;
    }

    @Override
    public JavaPlugin getPlugin() {
        return this;
    }
}

