/*
 * Decompiled with CFR 0.152.
 */
package de.codecrafter47.taboverlay.libs.mineskin;

import de.codecrafter47.taboverlay.libs.mineskin.SkinOptions;
import de.codecrafter47.taboverlay.libs.mineskin.data.Skin;
import de.codecrafter47.taboverlay.libs.mineskin.data.SkinCallback;
import de.codecrafter47.taboverlay.libs.mineskin.libs.com.google.common.base.Preconditions;
import de.codecrafter47.taboverlay.libs.mineskin.libs.com.google.gson.Gson;
import de.codecrafter47.taboverlay.libs.mineskin.libs.com.google.gson.JsonElement;
import de.codecrafter47.taboverlay.libs.mineskin.libs.com.google.gson.JsonObject;
import de.codecrafter47.taboverlay.libs.mineskin.libs.com.google.gson.JsonParseException;
import de.codecrafter47.taboverlay.libs.mineskin.libs.com.google.gson.JsonParser;
import de.codecrafter47.taboverlay.libs.mineskin.libs.org.jsoup.Connection;
import de.codecrafter47.taboverlay.libs.mineskin.libs.org.jsoup.Jsoup;
import java.io.File;
import java.io.FileInputStream;
import java.util.UUID;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;

public class MineskinClient {
    private static final String ID_FORMAT = "https://api.mineskin.org/get/id/%s";
    private static final String URL_FORMAT = "https://api.mineskin.org/generate/url?url=%s&%s";
    private static final String UPLOAD_FORMAT = "https://api.mineskin.org/generate/upload?%s";
    private static final String USER_FORMAT = "https://api.mineskin.org/generate/user/%s?%s";
    private final Executor requestExecutor;
    private final String userAgent;
    private final JsonParser jsonParser = new JsonParser();
    private final Gson gson = new Gson();
    private long nextRequest = 0L;

    public MineskinClient() {
        this.requestExecutor = Executors.newSingleThreadExecutor();
        this.userAgent = "MineSkin-JavaClient";
    }

    public MineskinClient(Executor requestExecutor) {
        this.requestExecutor = Preconditions.checkNotNull(requestExecutor);
        this.userAgent = "MineSkin-JavaClient";
    }

    public MineskinClient(Executor requestExecutor, String userAgent) {
        this.requestExecutor = Preconditions.checkNotNull(requestExecutor);
        this.userAgent = Preconditions.checkNotNull(userAgent);
    }

    public long getNextRequest() {
        return this.nextRequest;
    }

    public void getSkin(int id, SkinCallback callback) {
        Preconditions.checkNotNull(callback);
        this.requestExecutor.execute(() -> {
            try {
                Connection connection = Jsoup.connect(String.format(ID_FORMAT, id)).userAgent(this.userAgent).method(Connection.Method.GET).ignoreContentType(true).ignoreHttpErrors(true).timeout(10000);
                String body = connection.execute().body();
                this.handleResponse(body, callback);
            }
            catch (Exception e) {
                callback.exception(e);
            }
            catch (Throwable throwable) {
                throw new RuntimeException(throwable);
            }
        });
    }

    public void generateUrl(String url, SkinCallback callback) {
        this.generateUrl(url, SkinOptions.none(), callback);
    }

    public void generateUrl(String url, SkinOptions options, SkinCallback callback) {
        Preconditions.checkNotNull(url);
        Preconditions.checkNotNull(options);
        Preconditions.checkNotNull(callback);
        this.requestExecutor.execute(() -> {
            try {
                if (System.currentTimeMillis() < this.nextRequest) {
                    long delay = this.nextRequest - System.currentTimeMillis();
                    callback.waiting(delay);
                    Thread.sleep(delay + 1000L);
                }
                callback.uploading();
                Connection connection = Jsoup.connect(String.format(URL_FORMAT, url, options.toUrlParam())).userAgent(this.userAgent).method(Connection.Method.POST).ignoreContentType(true).ignoreHttpErrors(true).timeout(40000);
                String body = connection.execute().body();
                this.handleResponse(body, callback);
            }
            catch (Exception e) {
                callback.exception(e);
            }
            catch (Throwable throwable) {
                throw new RuntimeException(throwable);
            }
        });
    }

    public void generateUpload(File file, SkinCallback callback) {
        this.generateUpload(file, SkinOptions.none(), callback);
    }

    public void generateUpload(File file, SkinOptions options, SkinCallback callback) {
        Preconditions.checkNotNull(file);
        Preconditions.checkNotNull(options);
        Preconditions.checkNotNull(callback);
        this.requestExecutor.execute(() -> {
            try {
                if (System.currentTimeMillis() < this.nextRequest) {
                    long delay = this.nextRequest - System.currentTimeMillis();
                    callback.waiting(delay);
                    Thread.sleep(delay + 1000L);
                }
                callback.uploading();
                Connection connection = Jsoup.connect(String.format(UPLOAD_FORMAT, options.toUrlParam())).userAgent(this.userAgent).method(Connection.Method.POST).data("file", file.getName(), new FileInputStream(file)).ignoreContentType(true).ignoreHttpErrors(true).timeout(40000);
                String body = connection.execute().body();
                this.handleResponse(body, callback);
            }
            catch (Exception e) {
                callback.exception(e);
            }
            catch (Throwable throwable) {
                throw new RuntimeException(throwable);
            }
        });
    }

    public void generateUser(UUID uuid, SkinCallback callback) {
        this.generateUser(uuid, SkinOptions.none(), callback);
    }

    public void generateUser(UUID uuid, SkinOptions options, SkinCallback callback) {
        Preconditions.checkNotNull(uuid);
        Preconditions.checkNotNull(options);
        Preconditions.checkNotNull(callback);
        this.requestExecutor.execute(() -> {
            try {
                if (System.currentTimeMillis() < this.nextRequest) {
                    long delay = this.nextRequest - System.currentTimeMillis();
                    callback.waiting(delay);
                    Thread.sleep(delay + 1000L);
                }
                callback.uploading();
                Connection connection = Jsoup.connect(String.format(USER_FORMAT, uuid.toString(), options.toUrlParam())).userAgent(this.userAgent).method(Connection.Method.GET).ignoreContentType(true).ignoreHttpErrors(true).timeout(40000);
                String body = connection.execute().body();
                this.handleResponse(body, callback);
            }
            catch (Exception e) {
                callback.exception(e);
            }
            catch (Throwable throwable) {
                throw new RuntimeException(throwable);
            }
        });
    }

    void handleResponse(String body, SkinCallback callback) {
        try {
            JsonObject jsonObject = this.jsonParser.parse(body).getAsJsonObject();
            if (jsonObject.has("error")) {
                callback.error(jsonObject.get("error").getAsString());
                return;
            }
            Skin skin = this.gson.fromJson((JsonElement)jsonObject, Skin.class);
            this.nextRequest = System.currentTimeMillis() + (long)((skin.nextRequest + 10.0) * 1000.0);
            callback.done(skin);
        }
        catch (JsonParseException e) {
            callback.parseException(e, body);
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
    }
}

