/*
 * Decompiled with CFR 0.152.
 */
package de.codecrafter47.taboverlay.handler;

import com.google.common.base.Preconditions;
import de.codecrafter47.taboverlay.Icon;
import de.codecrafter47.taboverlay.handler.TabOverlayHandle;
import java.util.Collection;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public interface RectangularTabOverlay
extends TabOverlayHandle.BatchModifiable,
TabOverlayHandle {
    public Dimension getSize();

    public Collection<Dimension> getSupportedSizes();

    public void setSize(@Nonnull Dimension var1);

    public void setSlot(int var1, int var2, @Nullable UUID var3, @Nonnull Icon var4, @Nonnull String var5, int var6);

    default public void setSlot(int column, int row, @Nonnull Icon icon, @Nonnull String text, int ping) {
        this.setSlot(column, row, null, icon, text, ping);
    }

    public void setUuid(int var1, int var2, UUID var3);

    public void setIcon(int var1, int var2, @Nonnull Icon var3);

    public void setText(int var1, int var2, @Nonnull String var3);

    public void setPing(int var1, int var2, int var3);

    public static final class Dimension {
        private final int columns;
        private final int rows;
        private final int size;

        public Dimension(int columns, int rows) {
            Preconditions.checkArgument((columns > 0 ? 1 : 0) != 0, (String)"columns must be positive (is {0})", (Object[])new Object[]{columns});
            Preconditions.checkArgument((rows >= 0 ? 1 : 0) != 0, (String)"rows must not be negative (is {0})", (Object[])new Object[]{rows});
            this.columns = columns;
            this.rows = rows;
            this.size = columns * rows;
        }

        public int getColumns() {
            return this.columns;
        }

        public int getRows() {
            return this.rows;
        }

        public int getSize() {
            return this.size;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Dimension)) {
                return false;
            }
            Dimension other = (Dimension)o;
            if (this.getColumns() != other.getColumns()) {
                return false;
            }
            if (this.getRows() != other.getRows()) {
                return false;
            }
            return this.getSize() == other.getSize();
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getColumns();
            result = result * 59 + this.getRows();
            result = result * 59 + this.getSize();
            return result;
        }

        public String toString() {
            return "RectangularTabOverlay.Dimension(columns=" + this.getColumns() + ", rows=" + this.getRows() + ", size=" + this.getSize() + ")";
        }
    }
}

