/*
 * Decompiled with CFR 0.152.
 */
package de.codecrafter47.taboverlay.config.view.text;

import de.codecrafter47.taboverlay.config.template.text.TextTemplate;
import de.codecrafter47.taboverlay.config.view.AbstractActiveElement;
import de.codecrafter47.taboverlay.config.view.text.TextView;
import de.codecrafter47.taboverlay.config.view.text.TextViewUpdateListener;
import java.util.List;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

public class TextViewAnimated
extends AbstractActiveElement<TextViewUpdateListener>
implements TextView {
    private Future<?> task;
    private final List<TextView> elements;
    private TextView activeElement;
    private int nextElementIndex;
    private final long intervalMS;

    public TextViewAnimated(float interval, List<TextTemplate> elements) {
        this.elements = elements.stream().map(TextTemplate::instantiate).collect(Collectors.toList());
        this.intervalMS = (long)(interval * 1000.0f);
    }

    @Override
    public String getText() {
        return this.activeElement.getText();
    }

    private void switchActiveElement() {
        this.activeElement.deactivate();
        if (this.nextElementIndex >= this.elements.size()) {
            this.nextElementIndex = 0;
        }
        this.activeElement = this.elements.get(this.nextElementIndex++);
        this.activeElement.activate(this.getContext(), this.hasListener() ? (TextViewUpdateListener)this.getListener() : null);
        if (this.hasListener()) {
            ((TextViewUpdateListener)this.getListener()).onTextUpdated();
        }
    }

    @Override
    protected void onActivation() {
        this.task = this.getContext().getTabEventQueue().scheduleAtFixedRate(this::switchActiveElement, this.intervalMS, this.intervalMS, TimeUnit.MILLISECONDS);
        this.activeElement = this.elements.get(0);
        this.activeElement.activate(this.getContext(), this.hasListener() ? (TextViewUpdateListener)this.getListener() : null);
        this.nextElementIndex = 1;
    }

    @Override
    protected void onDeactivation() {
        this.task.cancel(false);
        this.activeElement.deactivate();
    }
}

