/*
 * Decompiled with CFR 0.152.
 */
package de.codecrafter47.taboverlay.config.view.ping;

import de.codecrafter47.data.api.DataHolder;
import de.codecrafter47.data.api.DataKey;
import de.codecrafter47.taboverlay.config.context.Context;
import de.codecrafter47.taboverlay.config.placeholder.PlayerPlaceholderResolver;
import de.codecrafter47.taboverlay.config.player.Player;
import de.codecrafter47.taboverlay.config.view.AbstractActiveElement;
import de.codecrafter47.taboverlay.config.view.ping.PingView;
import de.codecrafter47.taboverlay.config.view.ping.PingViewUpdateListener;

public class PingViewPlayer
extends AbstractActiveElement<PingViewUpdateListener>
implements PingView,
Runnable {
    private DataHolder dataHolder;
    private final PlayerPlaceholderResolver.BindPoint bindPoint;
    private final DataKey<Integer> dataKey;

    public PingViewPlayer(PlayerPlaceholderResolver.BindPoint bindPoint, DataKey<Integer> dataKey) {
        this.bindPoint = bindPoint;
        this.dataKey = dataKey;
    }

    @Override
    public int getPing() {
        Integer ping = this.dataHolder.get(this.dataKey);
        return ping != null ? ping : 0;
    }

    @Override
    protected void onActivation() {
        this.dataHolder = PingViewPlayer.getDataHolder(this.getContext(), this.bindPoint);
        this.dataHolder.addDataChangeListener(this.dataKey, this);
    }

    @Override
    protected void onDeactivation() {
        this.dataHolder.removeDataChangeListener(this.dataKey, this);
        this.dataHolder = null;
    }

    @Override
    public void run() {
        if (this.hasListener()) {
            ((PingViewUpdateListener)this.getListener()).onPingUpdated();
        }
    }

    private static DataHolder getDataHolder(Context context, PlayerPlaceholderResolver.BindPoint bindPoint) {
        Player dataHolder;
        if (bindPoint == PlayerPlaceholderResolver.BindPoint.PLAYER) {
            dataHolder = context.getPlayer();
        } else if (bindPoint == PlayerPlaceholderResolver.BindPoint.VIEWER) {
            dataHolder = context.getViewer();
        } else {
            throw new AssertionError();
        }
        if (dataHolder == null) {
            throw new AssertionError((Object)(bindPoint.toString() + " not available"));
        }
        return dataHolder;
    }
}

