/*
 * Decompiled with CFR 0.152.
 */
package de.codecrafter47.taboverlay.config.view.icon;

import de.codecrafter47.taboverlay.Icon;
import de.codecrafter47.taboverlay.config.ErrorHandler;
import de.codecrafter47.taboverlay.config.icon.IconManager;
import de.codecrafter47.taboverlay.config.template.icon.IconTemplate;
import de.codecrafter47.taboverlay.config.view.AbstractActiveElement;
import de.codecrafter47.taboverlay.config.view.icon.IconView;
import de.codecrafter47.taboverlay.config.view.icon.IconViewUpdateListener;
import de.codecrafter47.taboverlay.config.view.text.TextView;
import lombok.NonNull;

public class VariableIconView
extends AbstractActiveElement<IconViewUpdateListener>
implements IconView {
    private static final ErrorHandler errorHandlerDummy = new ErrorHandler();
    private final TextView textView;
    private final IconManager iconManager;
    private IconView iconView;

    public VariableIconView(@NonNull TextView textView, IconManager iconManager) {
        if (textView == null) {
            throw new NullPointerException("textView is marked non-null but is null");
        }
        this.textView = textView;
        this.iconManager = iconManager;
    }

    @Override
    protected void onActivation() {
        this.textView.activate(this.getContext(), this::update);
        IconTemplate iconTemplate = this.iconManager.createIconTemplate(this.textView.getText(), null, errorHandlerDummy);
        this.iconView = iconTemplate.instantiate();
        this.iconView.activate(this.getContext(), (IconViewUpdateListener)this.getListener());
    }

    private void update() {
        this.iconView.deactivate();
        IconTemplate iconTemplate = this.iconManager.createIconTemplate(this.textView.getText(), null, errorHandlerDummy);
        this.iconView = iconTemplate.instantiate();
        this.iconView.activate(this.getContext(), (IconViewUpdateListener)this.getListener());
        if (this.hasListener()) {
            ((IconViewUpdateListener)this.getListener()).onIconUpdated();
        }
    }

    @Override
    protected void onDeactivation() {
        this.iconView.deactivate();
        this.textView.deactivate();
    }

    @Override
    public Icon getIcon() {
        return this.iconView.getIcon();
    }
}

