/*
 * Decompiled with CFR 0.152.
 */
package de.codecrafter47.taboverlay.config.view.components;

import de.codecrafter47.taboverlay.config.area.Area;
import de.codecrafter47.taboverlay.config.area.RectangularArea;
import de.codecrafter47.taboverlay.config.view.components.ComponentView;
import de.codecrafter47.taboverlay.config.view.components.DefaultSlotHandler;
import de.codecrafter47.taboverlay.config.view.icon.IconView;
import de.codecrafter47.taboverlay.config.view.ping.PingView;
import de.codecrafter47.taboverlay.config.view.text.TextView;
import java.util.List;
import java.util.concurrent.Future;

public final class TableComponentView
extends ComponentView
implements DefaultSlotHandler.Listener {
    private final List<Column> columns;
    private final int size;
    private final int columnCount;
    private final DefaultSlotHandler defaultSlotHandler;
    private Future<?> updateFuture = null;
    private int minSize;
    private int preferredSize;
    private int maxSize;

    public TableComponentView(List<Column> columns, int size, int columnCount, TextView defaultTextView, PingView defaultPingView, IconView defaultIconView) {
        this.columns = columns;
        this.size = size;
        this.columnCount = columnCount;
        this.defaultSlotHandler = new DefaultSlotHandler(defaultTextView, defaultPingView, defaultIconView);
    }

    @Override
    protected void onActivation() {
        super.onActivation();
        this.defaultSlotHandler.activate(this.getContext(), this);
        for (int i = 0; i < this.columns.size(); ++i) {
            Column column = this.columns.get(i);
            column.component.activate(this.getContext(), this);
        }
        this.updateLayoutRequirements(false);
    }

    private void update() {
        this.updateLayoutRequirements(true);
        this.updateLayout();
    }

    @Override
    protected void onAreaUpdated() {
        this.updateLayout();
    }

    private void updateLayout() {
        Area area = this.getArea();
        if (area != null) {
            RectangularArea rArea = area.asRectangularArea();
            for (int i = 0; i < this.columns.size(); ++i) {
                Column column = this.columns.get(i);
                column.component.updateArea(rArea.createRectangularChild(column.columnIndex, 0, column.width, rArea.getRows()));
            }
        }
        this.updateDefaultSlots();
    }

    @Override
    protected void requestLayoutUpdate(ComponentView source) {
        if (this.updateFuture == null || this.updateFuture.isDone()) {
            this.updateFuture = this.getContext().getTabEventQueue().submit(this::update);
        }
    }

    @Override
    public int getMinSize() {
        return this.minSize;
    }

    @Override
    public int getPreferredSize() {
        return this.preferredSize;
    }

    @Override
    public int getMaxSize() {
        return this.maxSize;
    }

    @Override
    public boolean isBlockAligned() {
        return true;
    }

    @Override
    protected void onDeactivation() {
        this.defaultSlotHandler.deactivate();
        for (Column column : this.columns) {
            column.component.deactivate();
        }
        super.onDeactivation();
    }

    private void updateLayoutRequirements(boolean notify) {
        if (this.size != -1) {
            this.minSize = this.size;
            this.preferredSize = this.size;
            this.maxSize = this.size;
        } else {
            int minSize = 0;
            int preferredSize = 0;
            int maxSize = 0;
            for (int i = 0; i < this.columns.size(); ++i) {
                Column column = this.columns.get(i);
                minSize = Integer.max(minSize, (column.component.getMinSize() + column.width - 1) / column.width);
                preferredSize = Integer.max(preferredSize, (column.component.getPreferredSize() + column.width - 1) / column.width);
                maxSize = Integer.max(maxSize, (column.component.getMaxSize() + column.width - 1) / column.width);
            }
            if ((minSize *= this.columnCount) != this.minSize || (preferredSize *= this.columnCount) != this.preferredSize || (maxSize *= this.columnCount) != this.maxSize) {
                this.minSize = minSize;
                this.preferredSize = preferredSize;
                this.maxSize = maxSize;
                if (notify && this.hasListener()) {
                    ((ComponentView)this.getListener()).requestLayoutUpdate(this);
                }
            }
        }
    }

    private void updateDefaultSlots() {
        this.updateDefaultSlots((area, column, row, defaultSlot) -> area.setSlot(column, row, defaultSlot.getIcon(), defaultSlot.getText(), defaultSlot.getPing()));
    }

    private void updateDefaultSlots(DefaultSlotUpdateFunction updateFunction) {
        Area area = this.getArea();
        if (area != null) {
            RectangularArea rArea = area.asRectangularArea();
            int i = 0;
            for (int column = 0; column < rArea.getColumns(); ++column) {
                int rowsUsed = 0;
                while (i < this.columns.size() && column >= this.columns.get(i).columnIndex + this.columns.get(i).width) {
                    ++i;
                }
                if (i < this.columns.size() && column >= this.columns.get(i).columnIndex) {
                    rowsUsed = this.columns.get(i).component.getArea().asRectangularArea().getRows();
                }
                for (int row = rowsUsed; row < rArea.getRows(); ++row) {
                    updateFunction.apply(rArea, column, row, this.defaultSlotHandler);
                }
            }
        }
    }

    @Override
    public void onDefaultSlotTextUpdated() {
        this.updateDefaultSlots((area, column, row, defaultSlot) -> area.setText(column, row, defaultSlot.getText()));
    }

    @Override
    public void onDefaultSlotPingUpdated() {
        this.updateDefaultSlots((area, column, row, defaultSlot) -> area.setPing(column, row, defaultSlot.getPing()));
    }

    @Override
    public void onDefaultSlotIconUpdated() {
        this.updateDefaultSlots((area, column, row, defaultSlot) -> area.setIcon(column, row, defaultSlot.getIcon()));
    }

    public static final class Column {
        private final int columnIndex;
        private final int width;
        private final ComponentView component;

        public Column(int columnIndex, int width, ComponentView component) {
            this.columnIndex = columnIndex;
            this.width = width;
            this.component = component;
        }

        public int getColumnIndex() {
            return this.columnIndex;
        }

        public int getWidth() {
            return this.width;
        }

        public ComponentView getComponent() {
            return this.component;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Column)) {
                return false;
            }
            Column other = (Column)o;
            if (this.getColumnIndex() != other.getColumnIndex()) {
                return false;
            }
            if (this.getWidth() != other.getWidth()) {
                return false;
            }
            ComponentView this$component = this.getComponent();
            ComponentView other$component = other.getComponent();
            return !(this$component == null ? other$component != null : !this$component.equals(other$component));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getColumnIndex();
            result = result * 59 + this.getWidth();
            ComponentView $component = this.getComponent();
            result = result * 59 + ($component == null ? 43 : $component.hashCode());
            return result;
        }

        public String toString() {
            return "TableComponentView.Column(columnIndex=" + this.getColumnIndex() + ", width=" + this.getWidth() + ", component=" + this.getComponent() + ")";
        }
    }

    static interface DefaultSlotUpdateFunction {
        public void apply(RectangularArea var1, int var2, int var3, DefaultSlotHandler var4);
    }
}

