/*
 * Decompiled with CFR 0.152.
 */
package de.codecrafter47.taboverlay.config.view.components;

import de.codecrafter47.taboverlay.Icon;
import de.codecrafter47.taboverlay.config.area.Area;
import de.codecrafter47.taboverlay.config.view.components.ComponentView;
import de.codecrafter47.taboverlay.config.view.components.DefaultSlotHandler;
import de.codecrafter47.taboverlay.config.view.icon.IconView;
import de.codecrafter47.taboverlay.config.view.ping.PingView;
import de.codecrafter47.taboverlay.config.view.text.TextView;

public final class SpacerComponentView
extends ComponentView
implements DefaultSlotHandler.Listener {
    private final DefaultSlotHandler defaultSlotHandler;

    public SpacerComponentView(TextView textView, PingView pingView, IconView iconView) {
        this.defaultSlotHandler = new DefaultSlotHandler(textView, pingView, iconView);
    }

    @Override
    protected void onActivation() {
        super.onActivation();
        this.defaultSlotHandler.activate(this.getContext(), this);
    }

    @Override
    protected void onAreaUpdated() {
        this.updateSlots();
    }

    @Override
    protected void requestLayoutUpdate(ComponentView source) {
        throw new AssertionError((Object)"There ain't no one calling this method");
    }

    private void updateSlots() {
        Area area = this.getArea();
        if (area != null) {
            String text = this.defaultSlotHandler.getText();
            int ping = this.defaultSlotHandler.getPing();
            Icon icon = this.defaultSlotHandler.getIcon();
            for (int i = area.getSize() - 1; i >= 0; --i) {
                area.setSlot(i, icon, text, ping);
            }
        }
    }

    @Override
    public int getMinSize() {
        return 0;
    }

    @Override
    public int getPreferredSize() {
        return 0;
    }

    @Override
    public int getMaxSize() {
        return 360;
    }

    @Override
    public boolean isBlockAligned() {
        return false;
    }

    @Override
    protected void onDeactivation() {
        super.onDeactivation();
        this.defaultSlotHandler.deactivate();
    }

    @Override
    public void onDefaultSlotTextUpdated() {
        Area area = this.getArea();
        if (area != null) {
            String text = this.defaultSlotHandler.getText();
            for (int i = area.getSize() - 1; i >= 0; --i) {
                area.setText(i, text);
            }
        }
    }

    @Override
    public void onDefaultSlotPingUpdated() {
        Area area = this.getArea();
        if (area != null) {
            int ping = this.defaultSlotHandler.getPing();
            for (int i = area.getSize() - 1; i >= 0; --i) {
                area.setPing(i, ping);
            }
        }
    }

    @Override
    public void onDefaultSlotIconUpdated() {
        Area area = this.getArea();
        if (area != null) {
            Icon icon = this.defaultSlotHandler.getIcon();
            for (int i = area.getSize() - 1; i >= 0; --i) {
                area.setIcon(i, icon);
            }
        }
    }
}

