/*
 * Decompiled with CFR 0.152.
 */
package de.codecrafter47.taboverlay.config.view.components;

import de.codecrafter47.taboverlay.config.area.Area;
import de.codecrafter47.taboverlay.config.context.Context;
import de.codecrafter47.taboverlay.config.context.ContextKeys;
import de.codecrafter47.taboverlay.config.player.OrderedPlayerSet;
import de.codecrafter47.taboverlay.config.player.Player;
import de.codecrafter47.taboverlay.config.template.PlayerOrderTemplate;
import de.codecrafter47.taboverlay.config.template.PlayerSetTemplate;
import de.codecrafter47.taboverlay.config.template.component.ComponentTemplate;
import de.codecrafter47.taboverlay.config.view.components.ComponentView;
import de.codecrafter47.taboverlay.config.view.components.DefaultSlotHandler;
import de.codecrafter47.taboverlay.config.view.icon.IconView;
import de.codecrafter47.taboverlay.config.view.ping.PingView;
import de.codecrafter47.taboverlay.config.view.text.TextView;
import java.util.ArrayList;
import java.util.List;

public final class PlayersComponentView
extends ComponentView
implements OrderedPlayerSet.Listener,
DefaultSlotHandler.Listener {
    private final PlayerSetTemplate playerSetTemplate;
    private final ComponentTemplate playerComponentTemplate;
    private final int playerComponentSize;
    private final ComponentTemplate morePlayerComponentTemplate;
    private final int morePlayerComponentSize;
    private final DefaultSlotHandler defaultSlotHandler;
    private final PlayerOrderTemplate playerOrderTemplate;
    private OrderedPlayerSet playerSet;
    private List<ComponentView> activePlayerComponents = new ArrayList<ComponentView>();
    private ComponentView morePlayersComponent;
    private int firstDefaultSlot;

    public PlayersComponentView(PlayerSetTemplate playerSetTemplate, ComponentTemplate playerComponentTemplate, int playerComponentSize, ComponentTemplate morePlayerComponentTemplate, int morePlayerComponentSize, IconView defaultIconView, TextView defaultTextView, PingView defaultPingView, PlayerOrderTemplate playerOrderTemplate) {
        this.playerSetTemplate = playerSetTemplate;
        this.playerComponentTemplate = playerComponentTemplate;
        this.playerComponentSize = playerComponentSize;
        this.morePlayerComponentTemplate = morePlayerComponentTemplate;
        this.morePlayerComponentSize = morePlayerComponentSize;
        this.playerOrderTemplate = playerOrderTemplate;
        this.defaultSlotHandler = new DefaultSlotHandler(defaultTextView, defaultPingView, defaultIconView);
    }

    PlayersComponentView(OrderedPlayerSet playerSet, ComponentTemplate playerComponentTemplate, int playerComponentSize, ComponentTemplate morePlayerComponentTemplate, int morePlayerComponentSize, IconView defaultIconView, TextView defaultTextView, PingView defaultPingView) {
        this.playerSetTemplate = null;
        this.playerSet = playerSet;
        this.playerComponentTemplate = playerComponentTemplate;
        this.playerComponentSize = playerComponentSize;
        this.morePlayerComponentTemplate = morePlayerComponentTemplate;
        this.morePlayerComponentSize = morePlayerComponentSize;
        this.playerOrderTemplate = null;
        this.defaultSlotHandler = new DefaultSlotHandler(defaultTextView, defaultPingView, defaultIconView);
    }

    @Override
    protected void onActivation() {
        super.onActivation();
        if (this.playerSetTemplate != null) {
            this.playerSet = this.getContext().getPlayerSetFactory().getInstance(this.playerSetTemplate).getOrderedPlayerSet(this.getContext(), this.playerOrderTemplate);
        }
        this.playerSet.addListener(this);
        this.morePlayersComponent = this.morePlayerComponentTemplate.instantiate();
        this.defaultSlotHandler.activate(this.getContext(), this);
    }

    @Override
    protected void onAreaUpdated() {
        Area area = this.getArea();
        if (area != null) {
            boolean allFit = area.getSize() >= this.playerSet.getCount() * this.playerComponentSize;
            int indexP = 0;
            int pos = 0;
            while (indexP < this.playerSet.getCount() && (allFit || pos + this.playerComponentSize + this.morePlayerComponentSize <= area.getSize())) {
                Area childArea = area.createChild(pos, this.playerComponentSize);
                if (indexP < this.activePlayerComponents.size()) {
                    Player player = this.playerSet.getPlayer(indexP);
                    if (player != this.activePlayerComponents.get(indexP).getContext().getPlayer()) {
                        this.activePlayerComponents.get(indexP).deactivate();
                        Context child = this.getContext().clone();
                        child.setPlayer(player);
                        ComponentView playerComponent = this.playerComponentTemplate.instantiate();
                        playerComponent.activate(child, this);
                        playerComponent.updateArea(childArea);
                        this.activePlayerComponents.set(indexP, playerComponent);
                    } else {
                        this.activePlayerComponents.get(indexP).updateArea(childArea);
                    }
                } else {
                    Context child = this.getContext().clone();
                    child.setPlayer(this.playerSet.getPlayer(indexP));
                    ComponentView playerComponent = this.playerComponentTemplate.instantiate();
                    playerComponent.activate(child, this);
                    playerComponent.updateArea(childArea);
                    this.activePlayerComponents.add(playerComponent);
                }
                ++indexP;
                pos += this.playerComponentSize;
            }
            for (int j = this.activePlayerComponents.size() - 1; j >= indexP; --j) {
                ComponentView playerComponent = this.activePlayerComponents.get(j);
                playerComponent.deactivate();
                this.activePlayerComponents.remove(j);
            }
            if (!allFit && this.morePlayerComponentSize != 0) {
                if (this.morePlayersComponent == null) {
                    this.morePlayersComponent = this.morePlayerComponentTemplate.instantiate();
                }
                if (this.morePlayersComponent.isActive()) {
                    this.morePlayersComponent.deactivate();
                }
                Context child = this.getContext().clone();
                child.setCustomObject(ContextKeys.OTHER_COUNT, this.playerSet.getCount() - indexP);
                this.morePlayersComponent.activate(child, this);
                this.morePlayersComponent.updateArea(area.createChild(pos, this.morePlayerComponentSize));
                pos += this.morePlayerComponentSize;
            }
            int upper = area.getSize();
            this.firstDefaultSlot = pos;
            while (pos < upper) {
                area.setSlot(pos, this.defaultSlotHandler.getIcon(), this.defaultSlotHandler.getText(), this.defaultSlotHandler.getPing());
                ++pos;
            }
        }
    }

    @Override
    protected void requestLayoutUpdate(ComponentView source) {
        throw new AssertionError((Object)"requestLayoutUpdate of PlayersComponentView should not be called");
    }

    @Override
    public void onPlayerRemoved(Player player) {
        int indexP;
        for (indexP = 0; indexP < this.activePlayerComponents.size(); ++indexP) {
            if (player != this.activePlayerComponents.get(indexP).getContext().getPlayer()) continue;
            ComponentView playerComponent = this.activePlayerComponents.remove(indexP);
            playerComponent.deactivate();
        }
        Area area = this.getArea();
        if (area != null) {
            ComponentView playerComponent;
            boolean allFit = area.getSize() >= this.playerSet.getCount() * this.playerComponentSize;
            int pos = indexP * this.playerComponentSize;
            while (indexP < this.playerSet.getCount() && (allFit || pos + this.playerComponentSize + this.morePlayerComponentSize <= area.getSize())) {
                if (indexP < this.activePlayerComponents.size()) {
                    this.activePlayerComponents.get(indexP).updateArea(area.createChild(pos, this.playerComponentSize));
                } else {
                    Context child = this.getContext().clone();
                    child.setPlayer(this.playerSet.getPlayer(indexP));
                    playerComponent = this.playerComponentTemplate.instantiate();
                    playerComponent.activate(child, this);
                    playerComponent.updateArea(area.createChild(pos, this.playerComponentSize));
                    this.activePlayerComponents.add(playerComponent);
                }
                ++indexP;
                pos += this.playerComponentSize;
            }
            for (int j = this.activePlayerComponents.size() - 1; j >= indexP; --j) {
                playerComponent = this.activePlayerComponents.get(j);
                playerComponent.deactivate();
                this.activePlayerComponents.remove(j);
            }
            if (!allFit && this.morePlayerComponentSize != 0 && pos + this.morePlayerComponentSize <= area.getSize()) {
                if (this.morePlayersComponent == null) {
                    this.morePlayersComponent = this.morePlayerComponentTemplate.instantiate();
                }
                if (this.morePlayersComponent.isActive()) {
                    this.morePlayersComponent.deactivate();
                }
                Context child = this.getContext().clone();
                child.setCustomObject(ContextKeys.OTHER_COUNT, this.playerSet.getCount() - indexP);
                this.morePlayersComponent.activate(child, this);
                this.morePlayersComponent.updateArea(area.createChild(pos, this.morePlayerComponentSize));
                pos += this.morePlayerComponentSize;
            }
            int upper = Integer.min(area.getSize(), this.firstDefaultSlot);
            this.firstDefaultSlot = pos;
            while (pos < upper) {
                area.setSlot(pos, this.defaultSlotHandler.getIcon(), this.defaultSlotHandler.getText(), this.defaultSlotHandler.getPing());
                ++pos;
            }
        }
        ((ComponentView)this.getListener()).requestLayoutUpdate(this);
    }

    @Override
    public void onUpdate(boolean newPlayers) {
        if (newPlayers) {
            ((ComponentView)this.getListener()).requestLayoutUpdate(this);
        } else {
            Area area = this.getArea();
            if (area != null) {
                for (int i = 0; i < this.activePlayerComponents.size(); ++i) {
                    Player player = this.playerSet.getPlayer(i);
                    if (player == this.activePlayerComponents.get(i).getContext().getPlayer()) continue;
                    Area childArea = this.activePlayerComponents.get(i).getArea();
                    this.activePlayerComponents.get(i).deactivate();
                    Context child = this.getContext().clone();
                    child.setPlayer(player);
                    ComponentView playerComponent = this.playerComponentTemplate.instantiate();
                    playerComponent.activate(child, this);
                    playerComponent.updateArea(childArea);
                    this.activePlayerComponents.set(i, playerComponent);
                }
            }
        }
    }

    @Override
    public int getMinSize() {
        return 0;
    }

    @Override
    public int getPreferredSize() {
        return this.playerSet.getCount() * this.playerComponentSize;
    }

    @Override
    public int getMaxSize() {
        return this.playerSet.getCount() * this.playerComponentSize;
    }

    @Override
    public boolean isBlockAligned() {
        return false;
    }

    @Override
    protected void onDeactivation() {
        super.onDeactivation();
        for (ComponentView playerComponent : this.activePlayerComponents) {
            playerComponent.deactivate();
        }
        this.activePlayerComponents.clear();
        if (this.morePlayersComponent.isActive()) {
            this.morePlayersComponent.deactivate();
        }
        this.morePlayersComponent = null;
        this.playerSet.removeListener(this);
        this.playerSet = null;
        this.defaultSlotHandler.deactivate();
    }

    @Override
    public void onDefaultSlotTextUpdated() {
        Area area = this.getArea();
        if (area != null) {
            int upper = area.getSize();
            for (int pos = this.firstDefaultSlot; pos < upper; ++pos) {
                area.setText(pos, this.defaultSlotHandler.getText());
            }
        }
    }

    @Override
    public void onDefaultSlotPingUpdated() {
        Area area = this.getArea();
        if (area != null) {
            int upper = area.getSize();
            for (int pos = this.firstDefaultSlot; pos < upper; ++pos) {
                area.setPing(pos, this.defaultSlotHandler.getPing());
            }
        }
    }

    @Override
    public void onDefaultSlotIconUpdated() {
        Area area = this.getArea();
        if (area != null) {
            int upper = area.getSize();
            for (int pos = this.firstDefaultSlot; pos < upper; ++pos) {
                area.setIcon(pos, this.defaultSlotHandler.getIcon());
            }
        }
    }
}

