/*
 * Decompiled with CFR 0.152.
 */
package de.codecrafter47.taboverlay.config.view.components;

import de.codecrafter47.taboverlay.config.context.Context;
import de.codecrafter47.taboverlay.config.expression.template.ExpressionTemplate;
import de.codecrafter47.taboverlay.config.player.PlayerSet;
import de.codecrafter47.taboverlay.config.player.PlayerSetPartition;
import de.codecrafter47.taboverlay.config.template.PlayerOrderTemplate;
import de.codecrafter47.taboverlay.config.template.PlayerSetTemplate;
import de.codecrafter47.taboverlay.config.template.component.ComponentTemplate;
import de.codecrafter47.taboverlay.config.template.icon.IconTemplate;
import de.codecrafter47.taboverlay.config.template.ping.PingTemplate;
import de.codecrafter47.taboverlay.config.template.text.TextTemplate;
import de.codecrafter47.taboverlay.config.view.components.ComponentView;
import de.codecrafter47.taboverlay.config.view.components.ContainerComponentView;
import de.codecrafter47.taboverlay.config.view.components.ListComponentView;
import de.codecrafter47.taboverlay.config.view.components.PlayersComponentView;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class PartitionedPlayersView
extends ListComponentView
implements PlayerSetPartition.Listener {
    private final PlayerSetTemplate playerSetTemplate;
    private final ComponentTemplate playerComponentTemplate;
    private final int playerComponentSize;
    private final ComponentTemplate morePlayerComponentTemplate;
    private final int morePlayerComponentSize;
    private final PlayerOrderTemplate playerOrderTemplate;
    protected final TextTemplate defaultTextTemplate;
    protected final PingTemplate defaultPingTemplate;
    protected final IconTemplate defaultIconTemplate;
    private final ExpressionTemplate partitionFunction;
    protected PlayerSetPartition playerSetPartition;
    protected final ComponentTemplate sectionHeader;
    protected final ComponentTemplate sectionFooter;
    protected final ComponentTemplate sectionSeparator;
    protected final int minSizePerSection;
    protected final int maxSizePerSection;
    protected final SectionContextFactory sectionContextFactory;
    protected final Map<String, ComponentView> sectionMap = new HashMap<String, ComponentView>();

    public PartitionedPlayersView(int columns, PlayerSetTemplate playerSetTemplate, ComponentTemplate playerComponentTemplate, int playerComponentSize, ComponentTemplate morePlayerComponentTemplate, int morePlayerComponentSize, PlayerOrderTemplate playerOrderTemplate, TextTemplate defaultTextTemplate, PingTemplate defaultPingTemplate, IconTemplate defaultIconTemplate, ExpressionTemplate partitionFunction, ComponentTemplate sectionHeader, ComponentTemplate sectionFooter, ComponentTemplate sectionSeparator, int minSizePerSection, int maxSizePerSection, SectionContextFactory sectionContextFactory) {
        super(new ArrayList<ComponentView>(), columns, defaultTextTemplate.instantiate(), defaultPingTemplate.instantiate(), defaultIconTemplate.instantiate());
        this.playerSetTemplate = playerSetTemplate;
        this.playerComponentTemplate = playerComponentTemplate;
        this.playerComponentSize = playerComponentSize;
        this.morePlayerComponentTemplate = morePlayerComponentTemplate;
        this.morePlayerComponentSize = morePlayerComponentSize;
        this.playerOrderTemplate = playerOrderTemplate;
        this.defaultTextTemplate = defaultTextTemplate;
        this.defaultPingTemplate = defaultPingTemplate;
        this.defaultIconTemplate = defaultIconTemplate;
        this.partitionFunction = partitionFunction;
        this.sectionHeader = sectionHeader;
        this.sectionFooter = sectionFooter;
        this.sectionSeparator = sectionSeparator;
        this.minSizePerSection = minSizePerSection;
        this.maxSizePerSection = maxSizePerSection;
        this.sectionContextFactory = sectionContextFactory;
    }

    @Override
    protected void onActivation() {
        super.onActivation();
        this.playerSetPartition = this.getContext().getPlayerSetFactory().getInstance(this.playerSetTemplate).getPartition(this.partitionFunction);
        this.playerSetPartition.addListener(this);
        for (Map.Entry<String, ? extends PlayerSet> entry : this.playerSetPartition.getPartitions()) {
            this.addPartition(entry.getKey(), entry.getValue(), false);
        }
        this.updateLayoutRequirements(false);
    }

    @Override
    protected void onDeactivation() {
        super.onDeactivation();
        this.playerSetPartition.removeListener(this);
    }

    @Override
    public int getMinSize() {
        return 0;
    }

    @Override
    public void onPartitionAdded(String id, PlayerSet playerSet) {
        this.addPartition(id, playerSet, true);
    }

    protected void addPartition(String id, PlayerSet playerSet, boolean notify) {
        Context sectionContext = this.sectionContextFactory.createSectionContext(this.getContext(), id, playerSet);
        ComponentView componentView = this.createSectionView(id, playerSet, sectionContext);
        componentView.activate(sectionContext, this);
        this.sectionMap.put(id, componentView);
        if (this.sectionSeparator != null && !this.components.isEmpty()) {
            ComponentView separator = this.sectionSeparator.instantiate();
            separator.activate(this.getContext(), this);
            this.components.add(separator);
        }
        this.components.add(componentView);
        if (notify) {
            this.requestLayoutUpdate(this);
        }
    }

    @Override
    public void onPartitionRemoved(String id) {
        ComponentView componentView = this.sectionMap.remove(id);
        int index = this.components.indexOf(componentView);
        if (this.sectionSeparator == null) {
            this.components.remove(index);
        } else if (index != 0 && this.components.size() > 1) {
            this.components.remove(index);
            ComponentView separator = this.components.remove(index - 1);
            separator.deactivate();
        } else if (index != this.components.size() - 1 && this.components.size() > 1) {
            this.components.remove(index);
            ComponentView separator = this.components.remove(index);
            separator.deactivate();
        } else {
            this.components.remove(index);
        }
        componentView.deactivate();
        this.requestLayoutUpdate(this);
    }

    private ComponentView createSectionView(String id, PlayerSet playerSet, Context sectionContext) {
        ArrayList<ComponentView> components = new ArrayList<ComponentView>();
        if (this.sectionHeader != null) {
            components.add(this.sectionHeader.instantiate());
        }
        components.add(new PlayersComponentView(playerSet.getOrderedPlayerSet(sectionContext, this.playerOrderTemplate), this.playerComponentTemplate, this.playerComponentSize, this.morePlayerComponentTemplate, this.morePlayerComponentSize, this.defaultIconTemplate.instantiate(), this.defaultTextTemplate.instantiate(), this.defaultPingTemplate.instantiate()));
        if (this.sectionFooter != null) {
            components.add(this.sectionFooter.instantiate());
        }
        return new ContainerComponentView(new ListComponentView(components, this.columns, this.defaultTextTemplate.instantiate(), this.defaultPingTemplate.instantiate(), this.defaultIconTemplate.instantiate()), false, this.minSizePerSection, this.maxSizePerSection, this.columns, true);
    }

    public static interface SectionContextFactory {
        public Context createSectionContext(Context var1, String var2, PlayerSet var3);
    }
}

