/*
 * Decompiled with CFR 0.152.
 */
package de.codecrafter47.taboverlay.config.view.components;

import de.codecrafter47.taboverlay.config.area.Area;
import de.codecrafter47.taboverlay.config.area.RectangularArea;
import de.codecrafter47.taboverlay.config.view.components.ComponentView;
import de.codecrafter47.taboverlay.config.view.icon.IconView;
import de.codecrafter47.taboverlay.config.view.icon.IconViewUpdateListener;
import de.codecrafter47.taboverlay.config.view.ping.PingView;
import de.codecrafter47.taboverlay.config.view.ping.PingViewUpdateListener;
import de.codecrafter47.taboverlay.config.view.text.TextView;
import de.codecrafter47.taboverlay.config.view.text.TextViewUpdateListener;
import java.util.List;
import java.util.concurrent.Future;

public class ListComponentView
extends ComponentView
implements TextViewUpdateListener,
PingViewUpdateListener,
IconViewUpdateListener {
    protected final List<ComponentView> components;
    protected final int columns;
    private final TextView defaultTextView;
    private final PingView defaultPingView;
    private final IconView defaultIconView;
    protected int minSize;
    protected int preferredSize;
    protected int maxSize;
    private boolean blockAligned;
    private Future<?> updateFuture = null;
    private int[] sectionSize;

    public ListComponentView(List<ComponentView> components, int columns, TextView defaultTextView, PingView defaultPingView, IconView defaultIconView) {
        this.components = components;
        this.columns = columns;
        this.defaultTextView = defaultTextView;
        this.defaultPingView = defaultPingView;
        this.defaultIconView = defaultIconView;
        this.sectionSize = new int[this.components.size()];
    }

    @Override
    protected void onActivation() {
        super.onActivation();
        this.defaultIconView.activate(this.getContext(), this);
        this.defaultTextView.activate(this.getContext(), this);
        this.defaultPingView.activate(this.getContext(), this);
        for (int i = 0; i < this.components.size(); ++i) {
            ComponentView component = this.components.get(i);
            component.activate(this.getContext(), this);
        }
        this.updateLayoutRequirements(false);
    }

    private void update() {
        this.updateLayoutRequirements(true);
        if (this.getArea() != null) {
            this.updateLayout();
        }
    }

    @Override
    protected void onAreaUpdated() {
        if (this.getArea() != null) {
            this.updateLayout();
        } else {
            for (ComponentView component : this.components) {
                component.updateArea(null);
            }
        }
    }

    @Override
    protected void requestLayoutUpdate(ComponentView source) {
        if (this.updateFuture == null || this.updateFuture.isDone()) {
            this.updateFuture = this.getContext().getTabEventQueue().submit(this::update);
        }
    }

    @Override
    public int getMinSize() {
        return this.minSize;
    }

    @Override
    public int getPreferredSize() {
        return this.preferredSize;
    }

    @Override
    public int getMaxSize() {
        return this.maxSize;
    }

    @Override
    public boolean isBlockAligned() {
        return this.blockAligned;
    }

    @Override
    protected void onDeactivation() {
        this.defaultIconView.deactivate();
        this.defaultTextView.deactivate();
        this.defaultPingView.deactivate();
        for (int i = 0; i < this.components.size(); ++i) {
            ComponentView component = this.components.get(i);
            component.deactivate();
        }
        if (this.updateFuture != null) {
            this.updateFuture.cancel(false);
        }
        super.onDeactivation();
    }

    protected void updateLayoutRequirements(boolean notify) {
        int minSize = 0;
        for (int i = 0; i < this.components.size(); ++i) {
            ComponentView component = this.components.get(i);
            if (component.isBlockAligned()) {
                minSize = (minSize + this.columns - 1) / this.columns * this.columns;
            }
            minSize += component.getMinSize();
        }
        int preferredSize = 0;
        for (int i = 0; i < this.components.size(); ++i) {
            ComponentView component = this.components.get(i);
            if (component.isBlockAligned()) {
                preferredSize = (preferredSize + this.columns - 1) / this.columns * this.columns;
            }
            preferredSize += component.getPreferredSize();
        }
        int maxSize = 0;
        for (int i = 0; i < this.components.size(); ++i) {
            ComponentView component = this.components.get(i);
            if (component.isBlockAligned()) {
                maxSize = (maxSize + this.columns - 1) / this.columns * this.columns;
            }
            maxSize += component.getMaxSize();
        }
        boolean blockAligned = false;
        for (int i = 0; i < this.components.size(); ++i) {
            ComponentView component = this.components.get(i);
            if (!component.isBlockAligned()) continue;
            blockAligned = true;
        }
        if (minSize != this.minSize || preferredSize != this.preferredSize || maxSize != this.maxSize || blockAligned != this.blockAligned) {
            this.minSize = minSize;
            this.preferredSize = preferredSize;
            this.maxSize = maxSize;
            this.blockAligned = blockAligned;
            if (notify && this.hasListener()) {
                ((ComponentView)this.getListener()).requestLayoutUpdate(this);
            }
        }
    }

    private void updateLayout() {
        boolean repeat;
        this.sectionSize = new int[this.components.size()];
        for (int i = 0; i < this.components.size(); ++i) {
            this.sectionSize[i] = this.getInitialSizeEstimate(this.components.get(i));
        }
        RectangularArea area = this.getArea().asRectangularArea();
        int sizeNeeded = 0;
        for (int i = 0; i < this.components.size(); ++i) {
            ComponentView component = this.components.get(i);
            if (component.isBlockAligned()) {
                sizeNeeded = (sizeNeeded + this.columns - 1) / this.columns * this.columns;
            }
            sizeNeeded += this.sectionSize[i];
        }
        boolean max = false;
        do {
            repeat = false;
            for (int i = 0; i < this.components.size(); ++i) {
                ComponentView component = this.components.get(i);
                int oldSectionSize = this.sectionSize[i];
                if (oldSectionSize >= (max ? component.getMaxSize() : component.getPreferredSize())) continue;
                int n = i;
                this.sectionSize[n] = this.sectionSize[n] + (component.isBlockAligned() ? this.columns : 1);
                sizeNeeded = 0;
                for (int j = 0; j < this.components.size(); ++j) {
                    ComponentView component1 = this.components.get(j);
                    if (component1.isBlockAligned()) {
                        sizeNeeded = (sizeNeeded + this.columns - 1) / this.columns * this.columns;
                    }
                    sizeNeeded += this.sectionSize[j];
                }
                if (sizeNeeded <= area.getSize()) {
                    repeat = true;
                    continue;
                }
                this.sectionSize[i] = oldSectionSize;
            }
            if (repeat || max) continue;
            max = true;
            repeat = true;
        } while (repeat);
        int pos = 0;
        for (int i = 0; i < this.components.size(); ++i) {
            ComponentView component = this.components.get(i);
            if (component.isBlockAligned()) {
                int posNext = (pos + this.columns - 1) / this.columns * this.columns;
                this.setSlotsToDefault(pos, posNext);
                pos = posNext;
                if (pos < area.getSize() && pos + this.sectionSize[i] <= area.getSize()) {
                    component.updateArea(area.createRectangularChild(0, pos / this.columns, area.getColumns(), this.sectionSize[i] / this.columns));
                } else if (pos < area.getSize() && pos + component.getMinSize() <= area.getSize()) {
                    this.sectionSize[i] = area.getSize() - pos;
                    component.updateArea(area.createRectangularChild(0, pos / this.columns, area.getColumns(), this.sectionSize[i] / this.columns));
                } else {
                    this.sectionSize[i] = 0;
                    component.updateArea(null);
                }
            } else if (pos < area.getSize() && pos + this.sectionSize[i] <= area.getSize()) {
                component.updateArea(area.createChild(pos, this.sectionSize[i]));
            } else if (pos < area.getSize() && pos + component.getMinSize() <= area.getSize()) {
                this.sectionSize[i] = area.getSize() - pos;
                component.updateArea(area.createChild(pos, this.sectionSize[i]));
            } else {
                this.sectionSize[i] = 0;
                component.updateArea(null);
            }
            pos += this.sectionSize[i];
        }
        this.setSlotsToDefault(pos, area.getSize());
    }

    protected int getInitialSizeEstimate(ComponentView componentView) {
        int size = componentView.getMinSize();
        if (componentView.isBlockAligned()) {
            size = (size + this.columns - 1) / this.columns * this.columns;
        }
        return size;
    }

    private void updateDefaultSlots() {
        Area area = this.getArea();
        if (area != null) {
            int pos = 0;
            for (int i = 0; i < this.components.size(); ++i) {
                ComponentView component = this.components.get(i);
                if (component.isBlockAligned()) {
                    int posNext = (pos + this.columns - 1) / this.columns * this.columns;
                    this.setSlotsToDefault(pos, posNext);
                    pos = posNext;
                }
                pos += this.sectionSize[i];
            }
            this.setSlotsToDefault(pos, area.getSize());
        }
    }

    private void setSlotsToDefault(int start, int end) {
        for (int i = start; i < end; ++i) {
            this.getArea().setSlot(i, this.defaultIconView.getIcon(), this.defaultTextView.getText(), this.defaultPingView.getPing());
        }
    }

    @Override
    public void onIconUpdated() {
        this.updateDefaultSlots();
    }

    @Override
    public void onPingUpdated() {
        this.updateDefaultSlots();
    }

    @Override
    public void onTextUpdated() {
        this.updateDefaultSlots();
    }
}

