/*
 * Decompiled with CFR 0.152.
 */
package de.codecrafter47.taboverlay.config.view.components;

import de.codecrafter47.taboverlay.Icon;
import de.codecrafter47.taboverlay.config.view.AbstractActiveElement;
import de.codecrafter47.taboverlay.config.view.ActiveElement;
import de.codecrafter47.taboverlay.config.view.icon.IconView;
import de.codecrafter47.taboverlay.config.view.icon.IconViewUpdateListener;
import de.codecrafter47.taboverlay.config.view.ping.PingView;
import de.codecrafter47.taboverlay.config.view.ping.PingViewUpdateListener;
import de.codecrafter47.taboverlay.config.view.text.TextView;
import de.codecrafter47.taboverlay.config.view.text.TextViewUpdateListener;

class DefaultSlotHandler
extends AbstractActiveElement<Listener>
implements ActiveElement,
TextViewUpdateListener,
PingViewUpdateListener,
IconViewUpdateListener {
    private final TextView defaultTextView;
    private final PingView defaultPingView;
    private final IconView defaultIconView;

    DefaultSlotHandler(TextView defaultTextView, PingView defaultPingView, IconView defaultIconView) {
        this.defaultTextView = defaultTextView;
        this.defaultPingView = defaultPingView;
        this.defaultIconView = defaultIconView;
    }

    @Override
    protected void onActivation() {
        this.defaultTextView.activate(this.getContext(), this);
        this.defaultPingView.activate(this.getContext(), this);
        this.defaultIconView.activate(this.getContext(), this);
    }

    @Override
    protected void onDeactivation() {
        this.defaultTextView.deactivate();
        this.defaultPingView.deactivate();
        this.defaultIconView.deactivate();
    }

    String getText() {
        return this.defaultTextView.getText();
    }

    int getPing() {
        return this.defaultPingView.getPing();
    }

    Icon getIcon() {
        return this.defaultIconView.getIcon();
    }

    @Override
    public void onTextUpdated() {
        ((Listener)this.getListener()).onDefaultSlotTextUpdated();
    }

    @Override
    public void onPingUpdated() {
        ((Listener)this.getListener()).onDefaultSlotPingUpdated();
    }

    @Override
    public void onIconUpdated() {
        ((Listener)this.getListener()).onDefaultSlotIconUpdated();
    }

    static interface Listener {
        public void onDefaultSlotTextUpdated();

        public void onDefaultSlotPingUpdated();

        public void onDefaultSlotIconUpdated();
    }
}

