/*
 * Decompiled with CFR 0.152.
 */
package de.codecrafter47.taboverlay.config.view.components;

import de.codecrafter47.taboverlay.Icon;
import de.codecrafter47.taboverlay.config.area.Area;
import de.codecrafter47.taboverlay.config.area.RectangularArea;
import de.codecrafter47.taboverlay.config.view.components.ComponentView;
import java.util.UUID;

public final class ContainerComponentView
extends ComponentView {
    private final ComponentView content;
    private final boolean fillSlotsVertical;
    private final int minSize;
    private final int maxSize;
    private final int columns;
    private final boolean forceBlock;

    public ContainerComponentView(ComponentView content, boolean fillSlotsVertical, int minSize, int maxSize, int columns, boolean forceBlock) {
        this.content = content;
        this.fillSlotsVertical = fillSlotsVertical;
        this.minSize = minSize;
        this.maxSize = maxSize;
        this.columns = columns;
        this.forceBlock = forceBlock;
    }

    @Override
    protected void onActivation() {
        super.onActivation();
        this.content.activate(this.getContext(), this);
    }

    @Override
    protected void onAreaUpdated() {
        Area area = this.getArea();
        if (area != null) {
            if (this.fillSlotsVertical) {
                this.content.updateArea(new TransformedArea(area.asRectangularArea()));
            } else {
                this.content.updateArea(area);
            }
        } else {
            this.content.updateArea(null);
        }
    }

    @Override
    protected void requestLayoutUpdate(ComponentView source) {
        if (this.hasListener()) {
            ((ComponentView)this.getListener()).requestLayoutUpdate(this);
        }
    }

    @Override
    public int getMinSize() {
        int minSize = this.content.getMinSize();
        if (this.forceBlock || this.fillSlotsVertical) {
            minSize = (minSize + this.columns - 1) / this.columns * this.columns;
        }
        if (this.minSize >= 0) {
            minSize = Integer.max(minSize, this.minSize);
        }
        return minSize;
    }

    @Override
    public int getPreferredSize() {
        int preferredSize = this.content.getPreferredSize();
        if (this.forceBlock) {
            preferredSize = (preferredSize + this.columns - 1) / this.columns * this.columns;
        }
        if (this.fillSlotsVertical) {
            preferredSize *= this.columns;
        }
        if (this.minSize >= 0) {
            preferredSize = Integer.max(preferredSize, this.minSize);
        }
        if (this.maxSize >= 0) {
            preferredSize = Integer.min(preferredSize, this.maxSize);
        }
        return preferredSize;
    }

    @Override
    public int getMaxSize() {
        int maxSize = this.content.getMaxSize();
        if (this.forceBlock) {
            maxSize = (maxSize + this.columns - 1) / this.columns * this.columns;
        }
        if (this.fillSlotsVertical) {
            maxSize *= this.columns;
        }
        if (this.maxSize >= 0) {
            maxSize = Integer.min(maxSize, this.maxSize);
        }
        return maxSize;
    }

    @Override
    public boolean isBlockAligned() {
        return this.forceBlock || this.fillSlotsVertical || this.content.isBlockAligned();
    }

    @Override
    protected void onDeactivation() {
        this.content.deactivate();
        super.onDeactivation();
    }

    private static class TransformedArea
    implements Area {
        private final RectangularArea delegate;
        private final RectangularArea rectangularView;

        private TransformedArea(RectangularArea delegate) {
            this.delegate = delegate;
            this.rectangularView = new RectangularView();
        }

        @Override
        public void setSlot(int index, UUID uuid, Icon icon, String text, int ping) {
            this.delegate.setSlot(index / this.delegate.getRows(), index % this.delegate.getRows(), uuid, icon, text, ping);
        }

        @Override
        public void setUuid(int index, UUID uuid) {
            this.delegate.setUuid(index / this.delegate.getRows(), index % this.delegate.getRows(), uuid);
        }

        @Override
        public void setIcon(int index, Icon icon) {
            this.delegate.setIcon(index / this.delegate.getRows(), index % this.delegate.getRows(), icon);
        }

        @Override
        public void setText(int index, String text) {
            this.delegate.setText(index / this.delegate.getRows(), index % this.delegate.getRows(), text);
        }

        @Override
        public void setPing(int index, int ping) {
            this.delegate.setPing(index / this.delegate.getRows(), index % this.delegate.getRows(), ping);
        }

        @Override
        public void setSlot(int index, Icon icon, String text, int ping) {
            this.delegate.setSlot(index / this.delegate.getRows(), index % this.delegate.getRows(), icon, text, ping);
        }

        @Override
        public int getSize() {
            return this.delegate.getSize();
        }

        @Override
        public int getSlotWidth() {
            return this.delegate.getSlotWidth();
        }

        @Override
        public RectangularArea asRectangularArea() {
            return this.rectangularView;
        }

        private class RectangularView
        implements RectangularArea {
            private RectangularView() {
            }

            @Override
            public void setSlot(int index, UUID uuid, Icon icon, String text, int ping) {
                TransformedArea.this.setSlot(index, uuid, icon, text, ping);
            }

            @Override
            public void setSlot(int column, int row, UUID uuid, Icon icon, String text, int ping) {
                if (column == 0) {
                    TransformedArea.this.setSlot(row, uuid, icon, text, ping);
                }
            }

            @Override
            public void setUuid(int column, int row, UUID uuid) {
                if (column == 0) {
                    TransformedArea.this.setUuid(row, uuid);
                }
            }

            @Override
            public void setIcon(int column, int row, Icon icon) {
                if (column == 0) {
                    TransformedArea.this.setIcon(row, icon);
                }
            }

            @Override
            public void setText(int column, int row, String text) {
                if (column == 0) {
                    TransformedArea.this.setText(row, text);
                }
            }

            @Override
            public void setPing(int column, int row, int ping) {
                if (column == 0) {
                    TransformedArea.this.setPing(row, ping);
                }
            }

            @Override
            public int getRows() {
                return TransformedArea.this.delegate.getSize();
            }

            @Override
            public int getColumns() {
                return 1;
            }

            @Override
            public int getSize() {
                return TransformedArea.this.delegate.getSize();
            }

            @Override
            public int getSlotWidth() {
                return TransformedArea.this.delegate.getSlotWidth();
            }

            @Override
            public Area createChild(int firstIndex, int size) {
                return TransformedArea.this.createChild(firstIndex, size);
            }
        }
    }
}

