/*
 * Decompiled with CFR 0.152.
 */
package de.codecrafter47.taboverlay.config.view.components;

import de.codecrafter47.taboverlay.config.area.Area;
import de.codecrafter47.taboverlay.config.expression.ExpressionUpdateListener;
import de.codecrafter47.taboverlay.config.expression.ToBooleanExpression;
import de.codecrafter47.taboverlay.config.template.component.ComponentTemplate;
import de.codecrafter47.taboverlay.config.view.components.ComponentView;
import java.util.concurrent.Future;

public final class ConditionalComponentView
extends ComponentView
implements ExpressionUpdateListener {
    private final ToBooleanExpression condition;
    private final ComponentTemplate trueReplacement;
    private final ComponentTemplate falseReplacement;
    private ComponentView activeReplacement = null;
    private boolean previousResult = false;
    private int minSize;
    private int preferredSize;
    private int maxSize;
    private boolean blockAligned;
    private Future<?> updateFuture = null;

    public ConditionalComponentView(ToBooleanExpression condition, ComponentTemplate trueReplacement, ComponentTemplate falseReplacement) {
        this.condition = condition;
        this.trueReplacement = trueReplacement;
        this.falseReplacement = falseReplacement;
    }

    @Override
    protected void onActivation() {
        super.onActivation();
        this.condition.activate(this.getContext(), this);
        boolean result = this.condition.evaluate();
        if (this.activeReplacement != null) {
            this.activeReplacement.deactivate();
        }
        this.activeReplacement = result ? this.trueReplacement.instantiate() : this.falseReplacement.instantiate();
        this.activeReplacement.activate(this.getContext(), this);
        this.previousResult = result;
        this.minSize = this.activeReplacement.getMinSize();
        this.preferredSize = this.activeReplacement.getPreferredSize();
        this.maxSize = this.activeReplacement.getMaxSize();
        this.blockAligned = this.activeReplacement.isBlockAligned();
    }

    @Override
    public void onExpressionUpdate() {
        if (this.updateFuture == null || this.updateFuture.isDone()) {
            this.updateFuture = this.getContext().getTabEventQueue().submit(this::update);
        }
    }

    private void update() {
        boolean result = this.condition.evaluate();
        if (this.previousResult != result) {
            if (this.activeReplacement != null) {
                this.activeReplacement.deactivate();
            }
            this.activeReplacement = result ? this.trueReplacement.instantiate() : this.falseReplacement.instantiate();
            this.activeReplacement.activate(this.getContext(), this);
        }
        this.previousResult = result;
        this.updateLayout();
    }

    private void updateLayout() {
        int minSize = this.activeReplacement.getMinSize();
        int preferredSize = this.activeReplacement.getPreferredSize();
        int maxSize = this.activeReplacement.getMaxSize();
        boolean blockAligned = this.activeReplacement.isBlockAligned();
        if (minSize != this.minSize || preferredSize != this.preferredSize || maxSize != this.maxSize || blockAligned != this.blockAligned) {
            this.minSize = minSize;
            this.preferredSize = preferredSize;
            this.maxSize = maxSize;
            this.blockAligned = blockAligned;
            if (this.hasListener()) {
                ((ComponentView)this.getListener()).requestLayoutUpdate(this);
            }
        } else {
            Area area = this.getArea();
            if (area != null) {
                this.activeReplacement.updateArea(area);
            }
        }
    }

    @Override
    protected void onAreaUpdated() {
        this.activeReplacement.updateArea(this.getArea());
    }

    @Override
    protected void requestLayoutUpdate(ComponentView source) {
        this.updateLayout();
    }

    @Override
    public int getMinSize() {
        return this.minSize;
    }

    @Override
    public int getPreferredSize() {
        return this.preferredSize;
    }

    @Override
    public int getMaxSize() {
        return this.maxSize;
    }

    @Override
    public boolean isBlockAligned() {
        return this.blockAligned;
    }

    @Override
    protected void onDeactivation() {
        this.condition.deactivate();
        this.activeReplacement.deactivate();
        if (this.updateFuture != null) {
            this.updateFuture.cancel(false);
        }
        super.onDeactivation();
    }
}

