/*
 * Decompiled with CFR 0.152.
 */
package de.codecrafter47.taboverlay.config.view.components;

import de.codecrafter47.taboverlay.config.area.Area;
import de.codecrafter47.taboverlay.config.dsl.components.BasicComponentConfiguration;
import de.codecrafter47.taboverlay.config.misc.ChatFormat;
import de.codecrafter47.taboverlay.config.player.Player;
import de.codecrafter47.taboverlay.config.view.components.ComponentView;
import de.codecrafter47.taboverlay.config.view.icon.IconView;
import de.codecrafter47.taboverlay.config.view.icon.IconViewUpdateListener;
import de.codecrafter47.taboverlay.config.view.ping.PingView;
import de.codecrafter47.taboverlay.config.view.ping.PingViewUpdateListener;
import de.codecrafter47.taboverlay.config.view.text.TextView;
import de.codecrafter47.taboverlay.config.view.text.TextViewUpdateListener;
import java.util.UUID;
import javax.annotation.Nullable;

public final class BasicComponentView
extends ComponentView
implements TextViewUpdateListener,
PingViewUpdateListener,
IconViewUpdateListener {
    private final TextView leftTextView;
    private final TextView centerTextView;
    private final TextView rightTextView;
    private final PingView pingView;
    private final IconView iconView;
    private final BasicComponentConfiguration.LongTextBehaviour longText;
    private int slotWidth;
    @Nullable
    private UUID uuid;
    @Nullable
    private String textAfterAlignment;

    public BasicComponentView(TextView leftTextView, TextView centerTextView, TextView rightTextView, PingView pingView, IconView iconView, BasicComponentConfiguration.LongTextBehaviour longText) {
        this.leftTextView = leftTextView;
        this.centerTextView = centerTextView;
        this.rightTextView = rightTextView;
        this.pingView = pingView;
        this.iconView = iconView;
        this.longText = longText;
    }

    @Override
    protected void onActivation() {
        super.onActivation();
        Player player = this.getContext().getPlayer();
        UUID uUID = this.uuid = player != null ? player.getUniqueID() : null;
        if (this.leftTextView != null) {
            this.leftTextView.activate(this.getContext(), this);
        }
        if (this.centerTextView != null) {
            this.centerTextView.activate(this.getContext(), this);
        }
        if (this.rightTextView != null) {
            this.rightTextView.activate(this.getContext(), this);
        }
        this.pingView.activate(this.getContext(), this);
        this.iconView.activate(this.getContext(), this);
    }

    private void updateSlot() {
        Area area = this.getArea();
        if (area != null) {
            area.setSlot(0, this.uuid, this.iconView.getIcon(), this.textAfterAlignment, this.pingView.getPing());
        }
    }

    private void updateText() {
        String leftText;
        String string = leftText = this.leftTextView != null ? this.leftTextView.getText() : "";
        if (this.centerTextView != null || this.rightTextView != null || this.longText != BasicComponentConfiguration.LongTextBehaviour.DISPLAY_ALL) {
            float leftTextLength = ChatFormat.formattedTextLength(leftText);
            if (this.centerTextView != null) {
                String centerText = this.centerTextView.getText();
                float centerTextLength = ChatFormat.formattedTextLength(centerText);
                leftText = leftText + ChatFormat.createSpaces(Math.max(4.0f, (float)this.slotWidth / 2.0f - leftTextLength - centerTextLength / 2.0f)) + centerText;
                leftTextLength = ChatFormat.formattedTextLength(leftText);
            }
            String rightText = this.rightTextView != null ? this.rightTextView.getText() : "";
            float rightTextLength = ChatFormat.formattedTextLength(rightText);
            float totalTextLength = leftTextLength + (this.rightTextView != null ? 4.0f : 0.0f) + rightTextLength;
            if (this.longText != BasicComponentConfiguration.LongTextBehaviour.DISPLAY_ALL && totalTextLength > (float)this.slotWidth) {
                String suffix = "";
                if (this.longText == BasicComponentConfiguration.LongTextBehaviour.CROP_2DOTS) {
                    suffix = "..";
                } else if (this.longText == BasicComponentConfiguration.LongTextBehaviour.CROP_3DOTS) {
                    suffix = "...";
                }
                float suffixLength = ChatFormat.formattedTextLength(suffix);
                leftText = ChatFormat.cropFormattedText(leftText, (float)this.slotWidth - ((this.rightTextView != null ? 4.0f : 0.0f) + rightTextLength) - suffixLength) + suffix;
                leftTextLength = ChatFormat.formattedTextLength(leftText);
            }
            if (this.rightTextView != null) {
                leftText = leftText + ChatFormat.createSpacesExact(Math.max(4.0f, (float)this.slotWidth - rightTextLength - leftTextLength)) + rightText;
            } else if (this.centerTextView != null) {
                leftText = leftText + ChatFormat.createSpaces(Math.max(0.0f, (float)this.slotWidth - leftTextLength));
            }
        }
        this.textAfterAlignment = leftText;
    }

    @Override
    protected void onAreaUpdated() {
        if (this.getArea() != null) {
            this.slotWidth = this.getArea().getSlotWidth();
            this.updateText();
            this.updateSlot();
        }
    }

    @Override
    protected void requestLayoutUpdate(ComponentView source) {
        throw new AssertionError();
    }

    @Override
    public void onTextUpdated() {
        Area area = this.getArea();
        if (area != null) {
            this.updateText();
            area.setText(0, this.textAfterAlignment);
        }
    }

    @Override
    public void onPingUpdated() {
        Area area = this.getArea();
        if (area != null) {
            area.setPing(0, this.pingView.getPing());
        }
    }

    @Override
    public void onIconUpdated() {
        Area area = this.getArea();
        if (area != null) {
            area.setIcon(0, this.iconView.getIcon());
        }
    }

    @Override
    public int getMinSize() {
        return 1;
    }

    @Override
    public int getPreferredSize() {
        return 1;
    }

    @Override
    public int getMaxSize() {
        return 1;
    }

    @Override
    public boolean isBlockAligned() {
        return false;
    }

    @Override
    protected void onDeactivation() {
        if (this.leftTextView != null) {
            this.leftTextView.deactivate();
        }
        if (this.centerTextView != null) {
            this.centerTextView.deactivate();
        }
        if (this.rightTextView != null) {
            this.rightTextView.deactivate();
        }
        this.pingView.deactivate();
        this.iconView.deactivate();
        super.onDeactivation();
    }
}

