/*
 * Decompiled with CFR 0.152.
 */
package de.codecrafter47.taboverlay.config.view.components;

import de.codecrafter47.taboverlay.config.area.Area;
import de.codecrafter47.taboverlay.config.view.components.ComponentView;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

public final class AnimatedComponentView
extends ComponentView {
    private final List<ComponentView> components;
    private final long intervalMS;
    private final int size;
    private final boolean randomize;
    private ComponentView activeView;
    private Future<?> task;
    private int nextElementIndex;

    public AnimatedComponentView(List<ComponentView> components, float interval, int size, boolean randomize) {
        this.components = components;
        this.intervalMS = (long)(interval * 1000.0f);
        this.size = size;
        this.randomize = randomize;
        if (randomize) {
            Collections.shuffle(components);
        }
    }

    @Override
    protected void onActivation() {
        super.onActivation();
        this.task = this.getContext().getTabEventQueue().scheduleAtFixedRate(this::switchActiveElement, this.intervalMS, this.intervalMS, TimeUnit.MILLISECONDS);
        this.activeView = this.components.get(0);
        this.activeView.activate(this.getContext(), this);
        this.nextElementIndex = 1;
    }

    private void switchActiveElement() {
        this.activeView.deactivate();
        if (this.nextElementIndex >= this.components.size()) {
            this.nextElementIndex = 0;
            if (this.randomize) {
                Collections.shuffle(this.components);
            }
        }
        this.activeView = this.components.get(this.nextElementIndex++);
        this.activeView.activate(this.getContext(), this);
        Area area = this.getArea();
        if (area != null) {
            this.activeView.updateArea(area);
        }
    }

    @Override
    protected void onAreaUpdated() {
        this.activeView.updateArea(this.getArea());
    }

    @Override
    protected void requestLayoutUpdate(ComponentView source) {
    }

    @Override
    public int getMinSize() {
        return this.size;
    }

    @Override
    public int getPreferredSize() {
        return this.size;
    }

    @Override
    public int getMaxSize() {
        return this.size;
    }

    @Override
    public boolean isBlockAligned() {
        return this.activeView.isBlockAligned();
    }

    @Override
    protected void onDeactivation() {
        super.onDeactivation();
        this.task.cancel(false);
        this.activeView.deactivate();
    }
}

