/*
 * Decompiled with CFR 0.152.
 */
package de.codecrafter47.taboverlay.config.view;

import de.codecrafter47.taboverlay.TabView;
import de.codecrafter47.taboverlay.config.area.RectangularArea;
import de.codecrafter47.taboverlay.config.template.RectangularTabOverlayTemplate;
import de.codecrafter47.taboverlay.config.view.components.ComponentView;
import de.codecrafter47.taboverlay.handler.RectangularTabOverlay;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class RectangularContentView
extends ComponentView {
    private final ComponentView content;
    private final RectangularTabOverlay contentHandle;
    private List<RectangularTabOverlay.Dimension> possibleSizes = null;

    public RectangularContentView(TabView tabView, RectangularTabOverlayTemplate template, RectangularTabOverlay contentHandle) {
        this.contentHandle = contentHandle;
        if (template.getSize() != -1) {
            for (RectangularTabOverlay.Dimension dimension : contentHandle.getSupportedSizes()) {
                if (dimension.getSize() != template.getSize()) continue;
                this.possibleSizes = Collections.singletonList(dimension);
                break;
            }
            if (this.possibleSizes == null) {
                tabView.getLogger().severe("Size " + template.getSize() + " defined in " + template.getPath().getFileName().toString() + " is not supported by client.");
                this.possibleSizes = Collections.emptyList();
            }
        } else {
            this.possibleSizes = new ArrayList<RectangularTabOverlay.Dimension>();
            for (RectangularTabOverlay.Dimension dimension : contentHandle.getSupportedSizes()) {
                if (dimension.getColumns() != template.getColumns()) continue;
                this.possibleSizes.add(dimension);
            }
        }
        this.content = template.getContentRoot().instantiate();
    }

    @Override
    protected void onActivation() {
        this.content.activate(this.getContext(), this);
        if (!this.updateTabListSize()) {
            this.updateArea(RectangularArea.of(this.contentHandle));
        }
    }

    @Override
    protected void onAreaUpdated() {
        this.content.updateArea(this.getArea());
    }

    private boolean updateTabListSize() {
        RectangularTabOverlay.Dimension bestFit = this.contentHandle.getSize();
        for (RectangularTabOverlay.Dimension size : this.possibleSizes) {
            if (size.getSize() < this.getPreferredSize() && size.getSize() > bestFit.getSize()) {
                bestFit = size;
            }
            if (size.getSize() >= this.getPreferredSize() && bestFit.getSize() < this.getPreferredSize()) {
                bestFit = size;
            }
            if (size.getSize() >= bestFit.getSize() || size.getSize() < this.getPreferredSize()) continue;
            bestFit = size;
        }
        if (bestFit != this.contentHandle.getSize()) {
            this.contentHandle.setSize(bestFit);
            this.updateArea(RectangularArea.of(this.contentHandle));
            return true;
        }
        return false;
    }

    @Override
    protected void requestLayoutUpdate(ComponentView source) {
        if (!this.updateTabListSize()) {
            this.updateArea(this.getArea());
        }
    }

    @Override
    public int getMinSize() {
        return this.content.getMinSize();
    }

    @Override
    public int getPreferredSize() {
        return this.content.getPreferredSize();
    }

    @Override
    public int getMaxSize() {
        return this.content.getMaxSize();
    }

    @Override
    public boolean isBlockAligned() {
        return this.content.isBlockAligned();
    }

    @Override
    protected void onDeactivation() {
        this.content.deactivate();
    }
}

