/*
 * Decompiled with CFR 0.152.
 */
package de.codecrafter47.taboverlay.config.view;

import de.codecrafter47.taboverlay.config.template.AbstractTabOverlayTemplate;
import de.codecrafter47.taboverlay.config.template.text.TextTemplate;
import de.codecrafter47.taboverlay.config.view.AbstractActiveElement;
import de.codecrafter47.taboverlay.config.view.text.TextView;
import de.codecrafter47.taboverlay.config.view.text.TextViewAnimated;
import de.codecrafter47.taboverlay.config.view.text.TextViewUpdateListener;
import de.codecrafter47.taboverlay.handler.HeaderAndFooterHandle;
import java.util.List;

class HeaderAndFooterView
extends AbstractActiveElement<Void>
implements TextViewUpdateListener {
    private final TextView header;
    private final TextView footer;
    private final HeaderAndFooterHandle headerAndFooterHandle;

    public HeaderAndFooterView(AbstractTabOverlayTemplate tabOverlayTemplate, HeaderAndFooterHandle headerAndFooterHandle) {
        this.headerAndFooterHandle = headerAndFooterHandle;
        this.header = tabOverlayTemplate.getHeader() != null ? HeaderAndFooterView.constructTextView(tabOverlayTemplate.getHeader(), tabOverlayTemplate.getHeaderAnimationUpdateInterval()) : null;
        this.footer = tabOverlayTemplate.getFooter() != null ? HeaderAndFooterView.constructTextView(tabOverlayTemplate.getFooter(), tabOverlayTemplate.getFooterAnimationUpdateInterval()) : null;
    }

    @Override
    protected void onActivation() {
        if (this.header != null) {
            this.header.activate(this.getContext(), this);
        }
        if (this.footer != null) {
            this.footer.activate(this.getContext(), this);
        }
        this.updateHeaderAndFooter();
    }

    @Override
    protected void onDeactivation() {
        if (this.header != null) {
            this.header.deactivate();
        }
        if (this.footer != null) {
            this.footer.deactivate();
        }
    }

    private void updateHeaderAndFooter() {
        this.headerAndFooterHandle.setHeaderFooter(this.header != null ? this.header.getText() : null, this.footer != null ? this.footer.getText() : null);
    }

    private static TextView constructTextView(List<TextTemplate> templates, float interval) {
        if (templates == null || templates.isEmpty()) {
            return TextView.EMPTY;
        }
        if (templates.size() == 1) {
            return templates.get(0).instantiate();
        }
        return new TextViewAnimated(interval, templates);
    }

    @Override
    public void onTextUpdated() {
        this.updateHeaderAndFooter();
    }
}

