/*
 * Decompiled with CFR 0.152.
 */
package de.codecrafter47.taboverlay.config.view;

import de.codecrafter47.taboverlay.config.area.RectangularArea;
import de.codecrafter47.taboverlay.config.template.DynamicSizeTabOverlayTemplate;
import de.codecrafter47.taboverlay.config.template.icon.IconTemplate;
import de.codecrafter47.taboverlay.config.template.ping.PingTemplate;
import de.codecrafter47.taboverlay.config.template.text.TextTemplate;
import de.codecrafter47.taboverlay.config.view.components.ComponentView;
import de.codecrafter47.taboverlay.config.view.components.PlayersComponentView;
import de.codecrafter47.taboverlay.handler.SimpleTabOverlay;
import java.util.concurrent.Future;

public class DynamicSizeContentView
extends ComponentView {
    private final SimpleTabOverlay contentHandle;
    private final ComponentView content;
    private Future<?> updateFuture = null;

    public DynamicSizeContentView(DynamicSizeTabOverlayTemplate template, SimpleTabOverlay contentHandle) {
        this.contentHandle = contentHandle;
        this.content = new PlayersComponentView(template.getPlayerSet(), template.getPlayerComponent(), template.getPlayerComponent().getLayoutInfo().getMinSize(), template.getMorePlayersComponent(), template.getMorePlayersComponent().getLayoutInfo().getMinSize(), IconTemplate.STEVE.instantiate(), TextTemplate.EMPTY.instantiate(), PingTemplate.ZERO.instantiate(), template.getPlayerOrder());
    }

    @Override
    protected void onActivation() {
        this.content.activate(this.getContext(), this);
        if (!this.updateTabListSize()) {
            this.updateArea(RectangularArea.of(this.contentHandle));
        }
    }

    @Override
    protected void onAreaUpdated() {
        this.content.updateArea(this.getArea());
    }

    @Override
    protected void requestLayoutUpdate(ComponentView source) {
        if (this.updateFuture == null || this.updateFuture.isDone()) {
            this.updateFuture = this.getContext().getTabEventQueue().submit(this::update);
        }
    }

    private boolean updateTabListSize() {
        int newSize = Integer.min(this.getPreferredSize(), this.contentHandle.getMaxSize());
        if (newSize != this.contentHandle.getSize()) {
            this.contentHandle.setSize(newSize);
            this.updateArea(RectangularArea.of(this.contentHandle));
            return true;
        }
        return false;
    }

    private void update() {
        if (!this.updateTabListSize()) {
            this.updateArea(this.getArea());
        }
    }

    @Override
    public int getMinSize() {
        return this.content.getMinSize();
    }

    @Override
    public int getPreferredSize() {
        return this.content.getPreferredSize();
    }

    @Override
    public int getMaxSize() {
        return this.content.getMaxSize();
    }

    @Override
    public boolean isBlockAligned() {
        return this.content.isBlockAligned();
    }

    @Override
    protected void onDeactivation() {
        this.content.deactivate();
        if (this.updateFuture != null) {
            this.updateFuture.cancel(false);
        }
    }
}

