/*
 * Decompiled with CFR 0.152.
 */
package de.codecrafter47.taboverlay.config.view;

import de.codecrafter47.taboverlay.config.context.Context;
import de.codecrafter47.taboverlay.config.view.ActiveElement;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class AbstractActiveElement<L>
implements ActiveElement {
    private Context context = null;
    private L listener = null;

    public final boolean isActive() {
        return this.context != null;
    }

    @Nonnull
    public final Context getContext() {
        if (!this.isActive()) {
            throw new IllegalStateException("not active");
        }
        return this.context;
    }

    public final boolean hasListener() {
        if (!this.isActive()) {
            throw new IllegalStateException("not active");
        }
        return this.listener != null;
    }

    @Nonnull
    public final L getListener() {
        if (!this.isActive()) {
            throw new IllegalStateException("not active");
        }
        if (!this.hasListener()) {
            throw new IllegalStateException("no listener");
        }
        return this.listener;
    }

    public final void activate(@Nonnull Context context, @Nullable L listener) {
        if (this.isActive()) {
            throw new IllegalStateException("already active");
        }
        this.context = context;
        this.listener = listener;
        this.onActivation();
    }

    protected abstract void onActivation();

    @Override
    public final void deactivate() {
        if (!this.isActive()) {
            return;
        }
        try {
            this.onDeactivation();
        }
        catch (Throwable th) {
            th.printStackTrace();
        }
        this.context = null;
        this.listener = null;
    }

    protected abstract void onDeactivation();
}

