/*
 * Decompiled with CFR 0.152.
 */
package de.codecrafter47.taboverlay.config.template.text;

import de.codecrafter47.taboverlay.config.placeholder.PlaceholderParser;
import de.codecrafter47.taboverlay.config.template.TemplateCreationContext;
import de.codecrafter47.taboverlay.config.template.text.ConstantTextTemplate;
import de.codecrafter47.taboverlay.config.template.text.ListTextTemplate;
import de.codecrafter47.taboverlay.config.template.text.PlaceholderTextTemplate;
import de.codecrafter47.taboverlay.config.view.text.TextView;
import de.codecrafter47.taboverlay.libs.snakeyaml.error.Mark;
import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import lombok.NonNull;

public interface TextTemplate {
    public static final TextTemplate EMPTY = new ConstantTextTemplate("");
    public static final Pattern PATTERN_PLACEHOLDER_START = Pattern.compile("(?ms)\\$\\{");

    public static TextTemplate parse(String text, Mark mark, TemplateCreationContext tcc) {
        ArrayList<TextTemplate> templates = new ArrayList<TextTemplate>();
        Matcher matcher = PATTERN_PLACEHOLDER_START.matcher(text);
        ParsePosition position = new ParsePosition(0);
        while (matcher.find(position.getIndex())) {
            templates.add(new ConstantTextTemplate(text.substring(position.getIndex(), matcher.start())));
            position.setIndex(matcher.end());
            templates.add(new PlaceholderTextTemplate(PlaceholderParser.parse(text, position, mark, tcc)));
        }
        templates.add(new ConstantTextTemplate(text.substring(position.getIndex())));
        if (templates.size() == 1) {
            return (TextTemplate)templates.get(0);
        }
        return new ListTextTemplate(templates);
    }

    @Nonnull
    @NonNull
    public TextView instantiate();

    public boolean requiresViewerContext();
}

