/*
 * Decompiled with CFR 0.152.
 */
package de.codecrafter47.taboverlay.config.template.text;

import de.codecrafter47.taboverlay.config.template.text.TextTemplate;
import de.codecrafter47.taboverlay.config.view.text.TextView;
import de.codecrafter47.taboverlay.config.view.text.TextViewList;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import lombok.NonNull;

public class ListTextTemplate
implements TextTemplate {
    private final List<TextTemplate> templates;

    public ListTextTemplate(List<TextTemplate> templates) {
        this.templates = templates;
    }

    @Override
    @Nonnull
    @NonNull
    public TextView instantiate() {
        ArrayList<TextView> list = new ArrayList<TextView>(this.templates.size());
        for (TextTemplate template : this.templates) {
            list.add(Objects.requireNonNull(template.instantiate()));
        }
        return new TextViewList(list);
    }

    @Override
    public boolean requiresViewerContext() {
        return this.templates.stream().anyMatch(TextTemplate::requiresViewerContext);
    }
}

