/*
 * Decompiled with CFR 0.152.
 */
package de.codecrafter47.taboverlay.config.template.component;

import de.codecrafter47.taboverlay.config.template.component.ComponentTemplate;
import de.codecrafter47.taboverlay.config.template.icon.IconTemplate;
import de.codecrafter47.taboverlay.config.template.ping.PingTemplate;
import de.codecrafter47.taboverlay.config.template.text.TextTemplate;
import de.codecrafter47.taboverlay.config.view.components.ComponentView;
import de.codecrafter47.taboverlay.config.view.components.TableComponentView;
import java.util.ArrayList;
import java.util.List;

public final class TableComponentTemplate
implements ComponentTemplate {
    private final List<Column> columns;
    private final int size;
    private final int columnCount;
    private final TextTemplate defaultText;
    private final PingTemplate defaultPing;
    private final IconTemplate defaultIcon;

    @Override
    public ComponentTemplate.LayoutInfo getLayoutInfo() {
        return ComponentTemplate.LayoutInfo.builder().constantSize(this.size != -1).minSize(this.size != -1 ? this.size : this.columns.stream().mapToInt(rec$ -> ((Column)rec$).getMinSize()).max().orElse(0)).blockAligned(true).build();
    }

    @Override
    public ComponentView instantiate() {
        ArrayList<TableComponentView.Column> columns = new ArrayList<TableComponentView.Column>(this.columns.size());
        for (Column column : this.columns) {
            columns.add(column.instantiate());
        }
        return new TableComponentView(columns, this.size, this.columnCount, this.defaultText.instantiate(), this.defaultPing.instantiate(), this.defaultIcon.instantiate());
    }

    TableComponentTemplate(List<Column> columns, int size, int columnCount, TextTemplate defaultText, PingTemplate defaultPing, IconTemplate defaultIcon) {
        this.columns = columns;
        this.size = size;
        this.columnCount = columnCount;
        this.defaultText = defaultText;
        this.defaultPing = defaultPing;
        this.defaultIcon = defaultIcon;
    }

    public static TableComponentTemplateBuilder builder() {
        return new TableComponentTemplateBuilder();
    }

    public List<Column> getColumns() {
        return this.columns;
    }

    public int getSize() {
        return this.size;
    }

    public int getColumnCount() {
        return this.columnCount;
    }

    public TextTemplate getDefaultText() {
        return this.defaultText;
    }

    public PingTemplate getDefaultPing() {
        return this.defaultPing;
    }

    public IconTemplate getDefaultIcon() {
        return this.defaultIcon;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TableComponentTemplate)) {
            return false;
        }
        TableComponentTemplate other = (TableComponentTemplate)o;
        if (this.getSize() != other.getSize()) {
            return false;
        }
        if (this.getColumnCount() != other.getColumnCount()) {
            return false;
        }
        List<Column> this$columns = this.getColumns();
        List<Column> other$columns = other.getColumns();
        if (this$columns == null ? other$columns != null : !((Object)this$columns).equals(other$columns)) {
            return false;
        }
        TextTemplate this$defaultText = this.getDefaultText();
        TextTemplate other$defaultText = other.getDefaultText();
        if (this$defaultText == null ? other$defaultText != null : !this$defaultText.equals(other$defaultText)) {
            return false;
        }
        PingTemplate this$defaultPing = this.getDefaultPing();
        PingTemplate other$defaultPing = other.getDefaultPing();
        if (this$defaultPing == null ? other$defaultPing != null : !this$defaultPing.equals(other$defaultPing)) {
            return false;
        }
        IconTemplate this$defaultIcon = this.getDefaultIcon();
        IconTemplate other$defaultIcon = other.getDefaultIcon();
        return !(this$defaultIcon == null ? other$defaultIcon != null : !this$defaultIcon.equals(other$defaultIcon));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getSize();
        result = result * 59 + this.getColumnCount();
        List<Column> $columns = this.getColumns();
        result = result * 59 + ($columns == null ? 43 : ((Object)$columns).hashCode());
        TextTemplate $defaultText = this.getDefaultText();
        result = result * 59 + ($defaultText == null ? 43 : $defaultText.hashCode());
        PingTemplate $defaultPing = this.getDefaultPing();
        result = result * 59 + ($defaultPing == null ? 43 : $defaultPing.hashCode());
        IconTemplate $defaultIcon = this.getDefaultIcon();
        result = result * 59 + ($defaultIcon == null ? 43 : $defaultIcon.hashCode());
        return result;
    }

    public String toString() {
        return "TableComponentTemplate(columns=" + this.getColumns() + ", size=" + this.getSize() + ", columnCount=" + this.getColumnCount() + ", defaultText=" + this.getDefaultText() + ", defaultPing=" + this.getDefaultPing() + ", defaultIcon=" + this.getDefaultIcon() + ")";
    }

    public static final class Column {
        private final int columnIndex;
        private final int width;
        private final ComponentTemplate component;

        private TableComponentView.Column instantiate() {
            return new TableComponentView.Column(this.columnIndex, this.width, this.component.instantiate());
        }

        private int getMinSize() {
            return this.component.getLayoutInfo().getMinSize();
        }

        Column(int columnIndex, int width, ComponentTemplate component) {
            this.columnIndex = columnIndex;
            this.width = width;
            this.component = component;
        }

        public static ColumnBuilder builder() {
            return new ColumnBuilder();
        }

        public int getColumnIndex() {
            return this.columnIndex;
        }

        public int getWidth() {
            return this.width;
        }

        public ComponentTemplate getComponent() {
            return this.component;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Column)) {
                return false;
            }
            Column other = (Column)o;
            if (this.getColumnIndex() != other.getColumnIndex()) {
                return false;
            }
            if (this.getWidth() != other.getWidth()) {
                return false;
            }
            ComponentTemplate this$component = this.getComponent();
            ComponentTemplate other$component = other.getComponent();
            return !(this$component == null ? other$component != null : !this$component.equals(other$component));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getColumnIndex();
            result = result * 59 + this.getWidth();
            ComponentTemplate $component = this.getComponent();
            result = result * 59 + ($component == null ? 43 : $component.hashCode());
            return result;
        }

        public String toString() {
            return "TableComponentTemplate.Column(columnIndex=" + this.getColumnIndex() + ", width=" + this.getWidth() + ", component=" + this.getComponent() + ")";
        }

        public static class ColumnBuilder {
            private int columnIndex;
            private int width;
            private ComponentTemplate component;

            ColumnBuilder() {
            }

            public ColumnBuilder columnIndex(int columnIndex) {
                this.columnIndex = columnIndex;
                return this;
            }

            public ColumnBuilder width(int width) {
                this.width = width;
                return this;
            }

            public ColumnBuilder component(ComponentTemplate component) {
                this.component = component;
                return this;
            }

            public Column build() {
                return new Column(this.columnIndex, this.width, this.component);
            }

            public String toString() {
                return "TableComponentTemplate.Column.ColumnBuilder(columnIndex=" + this.columnIndex + ", width=" + this.width + ", component=" + this.component + ")";
            }
        }
    }

    public static class TableComponentTemplateBuilder {
        private List<Column> columns;
        private int size;
        private int columnCount;
        private TextTemplate defaultText;
        private PingTemplate defaultPing;
        private IconTemplate defaultIcon;

        TableComponentTemplateBuilder() {
        }

        public TableComponentTemplateBuilder columns(List<Column> columns) {
            this.columns = columns;
            return this;
        }

        public TableComponentTemplateBuilder size(int size) {
            this.size = size;
            return this;
        }

        public TableComponentTemplateBuilder columnCount(int columnCount) {
            this.columnCount = columnCount;
            return this;
        }

        public TableComponentTemplateBuilder defaultText(TextTemplate defaultText) {
            this.defaultText = defaultText;
            return this;
        }

        public TableComponentTemplateBuilder defaultPing(PingTemplate defaultPing) {
            this.defaultPing = defaultPing;
            return this;
        }

        public TableComponentTemplateBuilder defaultIcon(IconTemplate defaultIcon) {
            this.defaultIcon = defaultIcon;
            return this;
        }

        public TableComponentTemplate build() {
            return new TableComponentTemplate(this.columns, this.size, this.columnCount, this.defaultText, this.defaultPing, this.defaultIcon);
        }

        public String toString() {
            return "TableComponentTemplate.TableComponentTemplateBuilder(columns=" + this.columns + ", size=" + this.size + ", columnCount=" + this.columnCount + ", defaultText=" + this.defaultText + ", defaultPing=" + this.defaultPing + ", defaultIcon=" + this.defaultIcon + ")";
        }
    }
}

