/*
 * Decompiled with CFR 0.152.
 */
package de.codecrafter47.taboverlay.config.template.component;

import de.codecrafter47.taboverlay.config.player.PlayerSetFactory;
import de.codecrafter47.taboverlay.config.template.PlayerOrderTemplate;
import de.codecrafter47.taboverlay.config.template.PlayerSetTemplate;
import de.codecrafter47.taboverlay.config.template.component.ComponentTemplate;
import de.codecrafter47.taboverlay.config.template.icon.IconTemplate;
import de.codecrafter47.taboverlay.config.template.ping.PingTemplate;
import de.codecrafter47.taboverlay.config.template.text.TextTemplate;
import de.codecrafter47.taboverlay.config.view.components.ComponentView;
import de.codecrafter47.taboverlay.config.view.components.ContainerComponentView;
import de.codecrafter47.taboverlay.config.view.components.PlayersComponentView;
import javax.annotation.Nonnull;
import lombok.NonNull;

public final class PlayersComponentTemplate
implements ComponentTemplate {
    private final PlayerSetTemplate playerSet;
    private final PlayerSetFactory playerSetFactory;
    private final PlayerOrderTemplate playerOrder;
    private final ComponentTemplate playerComponent;
    @Nonnull
    @NonNull
    private final ComponentTemplate morePlayersComponent;
    private final boolean fillSlotsVertical;
    private final int minSize;
    private final int maxSize;
    private final int columns;
    private final TextTemplate defaultText;
    private final PingTemplate defaultPing;
    private final IconTemplate defaultIcon;

    @Override
    public ComponentTemplate.LayoutInfo getLayoutInfo() {
        return ComponentTemplate.LayoutInfo.builder().constantSize(false).minSize(0).blockAligned(false).build();
    }

    @Override
    public ComponentView instantiate() {
        return new ContainerComponentView(new PlayersComponentView(this.playerSet, this.playerComponent, this.playerComponent.getLayoutInfo().getMinSize(), this.morePlayersComponent, this.morePlayersComponent.getLayoutInfo().getMinSize(), this.defaultIcon.instantiate(), this.defaultText.instantiate(), this.defaultPing.instantiate(), this.playerOrder), this.fillSlotsVertical, this.minSize, this.maxSize, this.columns, false);
    }

    PlayersComponentTemplate(PlayerSetTemplate playerSet, PlayerSetFactory playerSetFactory, PlayerOrderTemplate playerOrder, ComponentTemplate playerComponent, @Nonnull @NonNull ComponentTemplate morePlayersComponent, boolean fillSlotsVertical, int minSize, int maxSize, int columns, TextTemplate defaultText, PingTemplate defaultPing, IconTemplate defaultIcon) {
        if (morePlayersComponent == null) {
            throw new NullPointerException("morePlayersComponent is marked non-null but is null");
        }
        this.playerSet = playerSet;
        this.playerSetFactory = playerSetFactory;
        this.playerOrder = playerOrder;
        this.playerComponent = playerComponent;
        this.morePlayersComponent = morePlayersComponent;
        this.fillSlotsVertical = fillSlotsVertical;
        this.minSize = minSize;
        this.maxSize = maxSize;
        this.columns = columns;
        this.defaultText = defaultText;
        this.defaultPing = defaultPing;
        this.defaultIcon = defaultIcon;
    }

    public static PlayersComponentTemplateBuilder builder() {
        return new PlayersComponentTemplateBuilder();
    }

    public PlayerSetTemplate getPlayerSet() {
        return this.playerSet;
    }

    public PlayerSetFactory getPlayerSetFactory() {
        return this.playerSetFactory;
    }

    public PlayerOrderTemplate getPlayerOrder() {
        return this.playerOrder;
    }

    public ComponentTemplate getPlayerComponent() {
        return this.playerComponent;
    }

    @Nonnull
    @NonNull
    public ComponentTemplate getMorePlayersComponent() {
        return this.morePlayersComponent;
    }

    public boolean isFillSlotsVertical() {
        return this.fillSlotsVertical;
    }

    public int getMinSize() {
        return this.minSize;
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public int getColumns() {
        return this.columns;
    }

    public TextTemplate getDefaultText() {
        return this.defaultText;
    }

    public PingTemplate getDefaultPing() {
        return this.defaultPing;
    }

    public IconTemplate getDefaultIcon() {
        return this.defaultIcon;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PlayersComponentTemplate)) {
            return false;
        }
        PlayersComponentTemplate other = (PlayersComponentTemplate)o;
        if (this.isFillSlotsVertical() != other.isFillSlotsVertical()) {
            return false;
        }
        if (this.getMinSize() != other.getMinSize()) {
            return false;
        }
        if (this.getMaxSize() != other.getMaxSize()) {
            return false;
        }
        if (this.getColumns() != other.getColumns()) {
            return false;
        }
        PlayerSetTemplate this$playerSet = this.getPlayerSet();
        PlayerSetTemplate other$playerSet = other.getPlayerSet();
        if (this$playerSet == null ? other$playerSet != null : !((Object)this$playerSet).equals(other$playerSet)) {
            return false;
        }
        PlayerSetFactory this$playerSetFactory = this.getPlayerSetFactory();
        PlayerSetFactory other$playerSetFactory = other.getPlayerSetFactory();
        if (this$playerSetFactory == null ? other$playerSetFactory != null : !this$playerSetFactory.equals(other$playerSetFactory)) {
            return false;
        }
        PlayerOrderTemplate this$playerOrder = this.getPlayerOrder();
        PlayerOrderTemplate other$playerOrder = other.getPlayerOrder();
        if (this$playerOrder == null ? other$playerOrder != null : !((Object)this$playerOrder).equals(other$playerOrder)) {
            return false;
        }
        ComponentTemplate this$playerComponent = this.getPlayerComponent();
        ComponentTemplate other$playerComponent = other.getPlayerComponent();
        if (this$playerComponent == null ? other$playerComponent != null : !this$playerComponent.equals(other$playerComponent)) {
            return false;
        }
        ComponentTemplate this$morePlayersComponent = this.getMorePlayersComponent();
        ComponentTemplate other$morePlayersComponent = other.getMorePlayersComponent();
        if (this$morePlayersComponent == null ? other$morePlayersComponent != null : !this$morePlayersComponent.equals(other$morePlayersComponent)) {
            return false;
        }
        TextTemplate this$defaultText = this.getDefaultText();
        TextTemplate other$defaultText = other.getDefaultText();
        if (this$defaultText == null ? other$defaultText != null : !this$defaultText.equals(other$defaultText)) {
            return false;
        }
        PingTemplate this$defaultPing = this.getDefaultPing();
        PingTemplate other$defaultPing = other.getDefaultPing();
        if (this$defaultPing == null ? other$defaultPing != null : !this$defaultPing.equals(other$defaultPing)) {
            return false;
        }
        IconTemplate this$defaultIcon = this.getDefaultIcon();
        IconTemplate other$defaultIcon = other.getDefaultIcon();
        return !(this$defaultIcon == null ? other$defaultIcon != null : !this$defaultIcon.equals(other$defaultIcon));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isFillSlotsVertical() ? 79 : 97);
        result = result * 59 + this.getMinSize();
        result = result * 59 + this.getMaxSize();
        result = result * 59 + this.getColumns();
        PlayerSetTemplate $playerSet = this.getPlayerSet();
        result = result * 59 + ($playerSet == null ? 43 : ((Object)$playerSet).hashCode());
        PlayerSetFactory $playerSetFactory = this.getPlayerSetFactory();
        result = result * 59 + ($playerSetFactory == null ? 43 : $playerSetFactory.hashCode());
        PlayerOrderTemplate $playerOrder = this.getPlayerOrder();
        result = result * 59 + ($playerOrder == null ? 43 : ((Object)$playerOrder).hashCode());
        ComponentTemplate $playerComponent = this.getPlayerComponent();
        result = result * 59 + ($playerComponent == null ? 43 : $playerComponent.hashCode());
        ComponentTemplate $morePlayersComponent = this.getMorePlayersComponent();
        result = result * 59 + ($morePlayersComponent == null ? 43 : $morePlayersComponent.hashCode());
        TextTemplate $defaultText = this.getDefaultText();
        result = result * 59 + ($defaultText == null ? 43 : $defaultText.hashCode());
        PingTemplate $defaultPing = this.getDefaultPing();
        result = result * 59 + ($defaultPing == null ? 43 : $defaultPing.hashCode());
        IconTemplate $defaultIcon = this.getDefaultIcon();
        result = result * 59 + ($defaultIcon == null ? 43 : $defaultIcon.hashCode());
        return result;
    }

    public String toString() {
        return "PlayersComponentTemplate(playerSet=" + this.getPlayerSet() + ", playerSetFactory=" + this.getPlayerSetFactory() + ", playerOrder=" + this.getPlayerOrder() + ", playerComponent=" + this.getPlayerComponent() + ", morePlayersComponent=" + this.getMorePlayersComponent() + ", fillSlotsVertical=" + this.isFillSlotsVertical() + ", minSize=" + this.getMinSize() + ", maxSize=" + this.getMaxSize() + ", columns=" + this.getColumns() + ", defaultText=" + this.getDefaultText() + ", defaultPing=" + this.getDefaultPing() + ", defaultIcon=" + this.getDefaultIcon() + ")";
    }

    public static class PlayersComponentTemplateBuilder {
        private PlayerSetTemplate playerSet;
        private PlayerSetFactory playerSetFactory;
        private PlayerOrderTemplate playerOrder;
        private ComponentTemplate playerComponent;
        private ComponentTemplate morePlayersComponent;
        private boolean fillSlotsVertical;
        private int minSize;
        private int maxSize;
        private int columns;
        private TextTemplate defaultText;
        private PingTemplate defaultPing;
        private IconTemplate defaultIcon;

        PlayersComponentTemplateBuilder() {
        }

        public PlayersComponentTemplateBuilder playerSet(PlayerSetTemplate playerSet) {
            this.playerSet = playerSet;
            return this;
        }

        public PlayersComponentTemplateBuilder playerSetFactory(PlayerSetFactory playerSetFactory) {
            this.playerSetFactory = playerSetFactory;
            return this;
        }

        public PlayersComponentTemplateBuilder playerOrder(PlayerOrderTemplate playerOrder) {
            this.playerOrder = playerOrder;
            return this;
        }

        public PlayersComponentTemplateBuilder playerComponent(ComponentTemplate playerComponent) {
            this.playerComponent = playerComponent;
            return this;
        }

        public PlayersComponentTemplateBuilder morePlayersComponent(@Nonnull @NonNull ComponentTemplate morePlayersComponent) {
            if (morePlayersComponent == null) {
                throw new NullPointerException("morePlayersComponent is marked non-null but is null");
            }
            this.morePlayersComponent = morePlayersComponent;
            return this;
        }

        public PlayersComponentTemplateBuilder fillSlotsVertical(boolean fillSlotsVertical) {
            this.fillSlotsVertical = fillSlotsVertical;
            return this;
        }

        public PlayersComponentTemplateBuilder minSize(int minSize) {
            this.minSize = minSize;
            return this;
        }

        public PlayersComponentTemplateBuilder maxSize(int maxSize) {
            this.maxSize = maxSize;
            return this;
        }

        public PlayersComponentTemplateBuilder columns(int columns) {
            this.columns = columns;
            return this;
        }

        public PlayersComponentTemplateBuilder defaultText(TextTemplate defaultText) {
            this.defaultText = defaultText;
            return this;
        }

        public PlayersComponentTemplateBuilder defaultPing(PingTemplate defaultPing) {
            this.defaultPing = defaultPing;
            return this;
        }

        public PlayersComponentTemplateBuilder defaultIcon(IconTemplate defaultIcon) {
            this.defaultIcon = defaultIcon;
            return this;
        }

        public PlayersComponentTemplate build() {
            return new PlayersComponentTemplate(this.playerSet, this.playerSetFactory, this.playerOrder, this.playerComponent, this.morePlayersComponent, this.fillSlotsVertical, this.minSize, this.maxSize, this.columns, this.defaultText, this.defaultPing, this.defaultIcon);
        }

        public String toString() {
            return "PlayersComponentTemplate.PlayersComponentTemplateBuilder(playerSet=" + this.playerSet + ", playerSetFactory=" + this.playerSetFactory + ", playerOrder=" + this.playerOrder + ", playerComponent=" + this.playerComponent + ", morePlayersComponent=" + this.morePlayersComponent + ", fillSlotsVertical=" + this.fillSlotsVertical + ", minSize=" + this.minSize + ", maxSize=" + this.maxSize + ", columns=" + this.columns + ", defaultText=" + this.defaultText + ", defaultPing=" + this.defaultPing + ", defaultIcon=" + this.defaultIcon + ")";
        }
    }
}

