/*
 * Decompiled with CFR 0.152.
 */
package de.codecrafter47.taboverlay.config.template.component;

import de.codecrafter47.taboverlay.config.template.component.ComponentTemplate;
import de.codecrafter47.taboverlay.config.template.icon.IconTemplate;
import de.codecrafter47.taboverlay.config.template.ping.PingTemplate;
import de.codecrafter47.taboverlay.config.template.text.TextTemplate;
import de.codecrafter47.taboverlay.config.view.components.ComponentView;
import de.codecrafter47.taboverlay.config.view.components.ListComponentView;
import java.util.List;
import java.util.stream.Collectors;

public final class ListComponentTemplate
implements ComponentTemplate {
    private final List<ComponentTemplate> components;
    private final int columns;
    private final TextTemplate defaultText;
    private final PingTemplate defaultPing;
    private final IconTemplate defaultIcon;

    @Override
    public ComponentTemplate.LayoutInfo getLayoutInfo() {
        return ComponentTemplate.LayoutInfo.builder().constantSize(this.components.stream().map(ComponentTemplate::getLayoutInfo).allMatch(ComponentTemplate.LayoutInfo::isConstantSize)).minSize(this.components.stream().map(ComponentTemplate::getLayoutInfo).mapToInt(ComponentTemplate.LayoutInfo::getMinSize).sum()).blockAligned(this.components.stream().map(ComponentTemplate::getLayoutInfo).anyMatch(ComponentTemplate.LayoutInfo::isBlockAligned)).build();
    }

    @Override
    public ComponentView instantiate() {
        return new ListComponentView(this.components.stream().map(ComponentTemplate::instantiate).collect(Collectors.toList()), this.columns, this.defaultText.instantiate(), this.defaultPing.instantiate(), this.defaultIcon.instantiate());
    }

    ListComponentTemplate(List<ComponentTemplate> components, int columns, TextTemplate defaultText, PingTemplate defaultPing, IconTemplate defaultIcon) {
        this.components = components;
        this.columns = columns;
        this.defaultText = defaultText;
        this.defaultPing = defaultPing;
        this.defaultIcon = defaultIcon;
    }

    public static ListComponentTemplateBuilder builder() {
        return new ListComponentTemplateBuilder();
    }

    public List<ComponentTemplate> getComponents() {
        return this.components;
    }

    public int getColumns() {
        return this.columns;
    }

    public TextTemplate getDefaultText() {
        return this.defaultText;
    }

    public PingTemplate getDefaultPing() {
        return this.defaultPing;
    }

    public IconTemplate getDefaultIcon() {
        return this.defaultIcon;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ListComponentTemplate)) {
            return false;
        }
        ListComponentTemplate other = (ListComponentTemplate)o;
        if (this.getColumns() != other.getColumns()) {
            return false;
        }
        List<ComponentTemplate> this$components = this.getComponents();
        List<ComponentTemplate> other$components = other.getComponents();
        if (this$components == null ? other$components != null : !((Object)this$components).equals(other$components)) {
            return false;
        }
        TextTemplate this$defaultText = this.getDefaultText();
        TextTemplate other$defaultText = other.getDefaultText();
        if (this$defaultText == null ? other$defaultText != null : !this$defaultText.equals(other$defaultText)) {
            return false;
        }
        PingTemplate this$defaultPing = this.getDefaultPing();
        PingTemplate other$defaultPing = other.getDefaultPing();
        if (this$defaultPing == null ? other$defaultPing != null : !this$defaultPing.equals(other$defaultPing)) {
            return false;
        }
        IconTemplate this$defaultIcon = this.getDefaultIcon();
        IconTemplate other$defaultIcon = other.getDefaultIcon();
        return !(this$defaultIcon == null ? other$defaultIcon != null : !this$defaultIcon.equals(other$defaultIcon));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getColumns();
        List<ComponentTemplate> $components = this.getComponents();
        result = result * 59 + ($components == null ? 43 : ((Object)$components).hashCode());
        TextTemplate $defaultText = this.getDefaultText();
        result = result * 59 + ($defaultText == null ? 43 : $defaultText.hashCode());
        PingTemplate $defaultPing = this.getDefaultPing();
        result = result * 59 + ($defaultPing == null ? 43 : $defaultPing.hashCode());
        IconTemplate $defaultIcon = this.getDefaultIcon();
        result = result * 59 + ($defaultIcon == null ? 43 : $defaultIcon.hashCode());
        return result;
    }

    public String toString() {
        return "ListComponentTemplate(components=" + this.getComponents() + ", columns=" + this.getColumns() + ", defaultText=" + this.getDefaultText() + ", defaultPing=" + this.getDefaultPing() + ", defaultIcon=" + this.getDefaultIcon() + ")";
    }

    public static class ListComponentTemplateBuilder {
        private List<ComponentTemplate> components;
        private int columns;
        private TextTemplate defaultText;
        private PingTemplate defaultPing;
        private IconTemplate defaultIcon;

        ListComponentTemplateBuilder() {
        }

        public ListComponentTemplateBuilder components(List<ComponentTemplate> components) {
            this.components = components;
            return this;
        }

        public ListComponentTemplateBuilder columns(int columns) {
            this.columns = columns;
            return this;
        }

        public ListComponentTemplateBuilder defaultText(TextTemplate defaultText) {
            this.defaultText = defaultText;
            return this;
        }

        public ListComponentTemplateBuilder defaultPing(PingTemplate defaultPing) {
            this.defaultPing = defaultPing;
            return this;
        }

        public ListComponentTemplateBuilder defaultIcon(IconTemplate defaultIcon) {
            this.defaultIcon = defaultIcon;
            return this;
        }

        public ListComponentTemplate build() {
            return new ListComponentTemplate(this.components, this.columns, this.defaultText, this.defaultPing, this.defaultIcon);
        }

        public String toString() {
            return "ListComponentTemplate.ListComponentTemplateBuilder(components=" + this.components + ", columns=" + this.columns + ", defaultText=" + this.defaultText + ", defaultPing=" + this.defaultPing + ", defaultIcon=" + this.defaultIcon + ")";
        }
    }
}

