/*
 * Decompiled with CFR 0.152.
 */
package de.codecrafter47.taboverlay.config.template.component;

import de.codecrafter47.taboverlay.config.template.component.ComponentTemplate;
import de.codecrafter47.taboverlay.config.view.components.ComponentView;
import de.codecrafter47.taboverlay.config.view.components.ContainerComponentView;

public final class ContainerComponentTemplate
implements ComponentTemplate {
    private final ComponentTemplate content;
    private final boolean fillSlotsVertical;
    private final int minSize;
    private final int maxSize;
    private final int columns;

    @Override
    public ComponentTemplate.LayoutInfo getLayoutInfo() {
        return ComponentTemplate.LayoutInfo.builder().constantSize(this.content.getLayoutInfo().isConstantSize() || this.minSize == this.maxSize).minSize(this.maxSize != -1 ? Integer.max(this.content.getLayoutInfo().getMinSize(), this.maxSize) : this.content.getLayoutInfo().getMinSize()).blockAligned(this.fillSlotsVertical || this.content.getLayoutInfo().isBlockAligned()).build();
    }

    @Override
    public ComponentView instantiate() {
        return new ContainerComponentView(this.content.instantiate(), this.fillSlotsVertical, this.minSize, this.maxSize, this.columns, false);
    }

    ContainerComponentTemplate(ComponentTemplate content, boolean fillSlotsVertical, int minSize, int maxSize, int columns) {
        this.content = content;
        this.fillSlotsVertical = fillSlotsVertical;
        this.minSize = minSize;
        this.maxSize = maxSize;
        this.columns = columns;
    }

    public static ContainerComponentTemplateBuilder builder() {
        return new ContainerComponentTemplateBuilder();
    }

    public ComponentTemplate getContent() {
        return this.content;
    }

    public boolean isFillSlotsVertical() {
        return this.fillSlotsVertical;
    }

    public int getMinSize() {
        return this.minSize;
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public int getColumns() {
        return this.columns;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ContainerComponentTemplate)) {
            return false;
        }
        ContainerComponentTemplate other = (ContainerComponentTemplate)o;
        if (this.isFillSlotsVertical() != other.isFillSlotsVertical()) {
            return false;
        }
        if (this.getMinSize() != other.getMinSize()) {
            return false;
        }
        if (this.getMaxSize() != other.getMaxSize()) {
            return false;
        }
        if (this.getColumns() != other.getColumns()) {
            return false;
        }
        ComponentTemplate this$content = this.getContent();
        ComponentTemplate other$content = other.getContent();
        return !(this$content == null ? other$content != null : !this$content.equals(other$content));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isFillSlotsVertical() ? 79 : 97);
        result = result * 59 + this.getMinSize();
        result = result * 59 + this.getMaxSize();
        result = result * 59 + this.getColumns();
        ComponentTemplate $content = this.getContent();
        result = result * 59 + ($content == null ? 43 : $content.hashCode());
        return result;
    }

    public String toString() {
        return "ContainerComponentTemplate(content=" + this.getContent() + ", fillSlotsVertical=" + this.isFillSlotsVertical() + ", minSize=" + this.getMinSize() + ", maxSize=" + this.getMaxSize() + ", columns=" + this.getColumns() + ")";
    }

    public static class ContainerComponentTemplateBuilder {
        private ComponentTemplate content;
        private boolean fillSlotsVertical;
        private int minSize;
        private int maxSize;
        private int columns;

        ContainerComponentTemplateBuilder() {
        }

        public ContainerComponentTemplateBuilder content(ComponentTemplate content) {
            this.content = content;
            return this;
        }

        public ContainerComponentTemplateBuilder fillSlotsVertical(boolean fillSlotsVertical) {
            this.fillSlotsVertical = fillSlotsVertical;
            return this;
        }

        public ContainerComponentTemplateBuilder minSize(int minSize) {
            this.minSize = minSize;
            return this;
        }

        public ContainerComponentTemplateBuilder maxSize(int maxSize) {
            this.maxSize = maxSize;
            return this;
        }

        public ContainerComponentTemplateBuilder columns(int columns) {
            this.columns = columns;
            return this;
        }

        public ContainerComponentTemplate build() {
            return new ContainerComponentTemplate(this.content, this.fillSlotsVertical, this.minSize, this.maxSize, this.columns);
        }

        public String toString() {
            return "ContainerComponentTemplate.ContainerComponentTemplateBuilder(content=" + this.content + ", fillSlotsVertical=" + this.fillSlotsVertical + ", minSize=" + this.minSize + ", maxSize=" + this.maxSize + ", columns=" + this.columns + ")";
        }
    }
}

