/*
 * Decompiled with CFR 0.152.
 */
package de.codecrafter47.taboverlay.config.template.component;

import de.codecrafter47.taboverlay.config.expression.template.ExpressionTemplate;
import de.codecrafter47.taboverlay.config.template.component.ComponentTemplate;
import de.codecrafter47.taboverlay.config.view.components.ComponentView;
import de.codecrafter47.taboverlay.config.view.components.ConditionalComponentView;

public final class ConditionalComponentTemplate
implements ComponentTemplate {
    private final ExpressionTemplate condition;
    private final ComponentTemplate trueReplacement;
    private final ComponentTemplate falseReplacement;

    @Override
    public ComponentTemplate.LayoutInfo getLayoutInfo() {
        ComponentTemplate.LayoutInfo layout1 = this.trueReplacement.getLayoutInfo();
        ComponentTemplate.LayoutInfo layout2 = this.falseReplacement.getLayoutInfo();
        return ComponentTemplate.LayoutInfo.builder().constantSize(layout1.isConstantSize() && layout2.isConstantSize() && layout1.getMinSize() == layout2.getMinSize()).minSize(Integer.max(layout1.getMinSize(), layout2.getMinSize())).blockAligned(layout1.isBlockAligned() || layout2.isBlockAligned()).build();
    }

    @Override
    public ComponentView instantiate() {
        return new ConditionalComponentView(this.condition.instantiateWithBooleanResult(), this.trueReplacement, this.falseReplacement);
    }

    ConditionalComponentTemplate(ExpressionTemplate condition, ComponentTemplate trueReplacement, ComponentTemplate falseReplacement) {
        this.condition = condition;
        this.trueReplacement = trueReplacement;
        this.falseReplacement = falseReplacement;
    }

    public static ConditionalComponentTemplateBuilder builder() {
        return new ConditionalComponentTemplateBuilder();
    }

    public ExpressionTemplate getCondition() {
        return this.condition;
    }

    public ComponentTemplate getTrueReplacement() {
        return this.trueReplacement;
    }

    public ComponentTemplate getFalseReplacement() {
        return this.falseReplacement;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ConditionalComponentTemplate)) {
            return false;
        }
        ConditionalComponentTemplate other = (ConditionalComponentTemplate)o;
        ExpressionTemplate this$condition = this.getCondition();
        ExpressionTemplate other$condition = other.getCondition();
        if (this$condition == null ? other$condition != null : !this$condition.equals(other$condition)) {
            return false;
        }
        ComponentTemplate this$trueReplacement = this.getTrueReplacement();
        ComponentTemplate other$trueReplacement = other.getTrueReplacement();
        if (this$trueReplacement == null ? other$trueReplacement != null : !this$trueReplacement.equals(other$trueReplacement)) {
            return false;
        }
        ComponentTemplate this$falseReplacement = this.getFalseReplacement();
        ComponentTemplate other$falseReplacement = other.getFalseReplacement();
        return !(this$falseReplacement == null ? other$falseReplacement != null : !this$falseReplacement.equals(other$falseReplacement));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ExpressionTemplate $condition = this.getCondition();
        result = result * 59 + ($condition == null ? 43 : $condition.hashCode());
        ComponentTemplate $trueReplacement = this.getTrueReplacement();
        result = result * 59 + ($trueReplacement == null ? 43 : $trueReplacement.hashCode());
        ComponentTemplate $falseReplacement = this.getFalseReplacement();
        result = result * 59 + ($falseReplacement == null ? 43 : $falseReplacement.hashCode());
        return result;
    }

    public String toString() {
        return "ConditionalComponentTemplate(condition=" + this.getCondition() + ", trueReplacement=" + this.getTrueReplacement() + ", falseReplacement=" + this.getFalseReplacement() + ")";
    }

    public static class ConditionalComponentTemplateBuilder {
        private ExpressionTemplate condition;
        private ComponentTemplate trueReplacement;
        private ComponentTemplate falseReplacement;

        ConditionalComponentTemplateBuilder() {
        }

        public ConditionalComponentTemplateBuilder condition(ExpressionTemplate condition) {
            this.condition = condition;
            return this;
        }

        public ConditionalComponentTemplateBuilder trueReplacement(ComponentTemplate trueReplacement) {
            this.trueReplacement = trueReplacement;
            return this;
        }

        public ConditionalComponentTemplateBuilder falseReplacement(ComponentTemplate falseReplacement) {
            this.falseReplacement = falseReplacement;
            return this;
        }

        public ConditionalComponentTemplate build() {
            return new ConditionalComponentTemplate(this.condition, this.trueReplacement, this.falseReplacement);
        }

        public String toString() {
            return "ConditionalComponentTemplate.ConditionalComponentTemplateBuilder(condition=" + this.condition + ", trueReplacement=" + this.trueReplacement + ", falseReplacement=" + this.falseReplacement + ")";
        }
    }
}

