/*
 * Decompiled with CFR 0.152.
 */
package de.codecrafter47.taboverlay.config.template.component;

import de.codecrafter47.taboverlay.config.view.components.ComponentView;

public interface ComponentTemplate {
    public LayoutInfo getLayoutInfo();

    public ComponentView instantiate();

    public static final class LayoutInfo {
        private final boolean constantSize;
        private final boolean blockAligned;
        private final int minSize;

        LayoutInfo(boolean constantSize, boolean blockAligned, int minSize) {
            this.constantSize = constantSize;
            this.blockAligned = blockAligned;
            this.minSize = minSize;
        }

        public static LayoutInfoBuilder builder() {
            return new LayoutInfoBuilder();
        }

        public boolean isConstantSize() {
            return this.constantSize;
        }

        public boolean isBlockAligned() {
            return this.blockAligned;
        }

        public int getMinSize() {
            return this.minSize;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof LayoutInfo)) {
                return false;
            }
            LayoutInfo other = (LayoutInfo)o;
            if (this.isConstantSize() != other.isConstantSize()) {
                return false;
            }
            if (this.isBlockAligned() != other.isBlockAligned()) {
                return false;
            }
            return this.getMinSize() == other.getMinSize();
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isConstantSize() ? 79 : 97);
            result = result * 59 + (this.isBlockAligned() ? 79 : 97);
            result = result * 59 + this.getMinSize();
            return result;
        }

        public String toString() {
            return "ComponentTemplate.LayoutInfo(constantSize=" + this.isConstantSize() + ", blockAligned=" + this.isBlockAligned() + ", minSize=" + this.getMinSize() + ")";
        }

        public static class LayoutInfoBuilder {
            private boolean constantSize;
            private boolean blockAligned;
            private int minSize;

            LayoutInfoBuilder() {
            }

            public LayoutInfoBuilder constantSize(boolean constantSize) {
                this.constantSize = constantSize;
                return this;
            }

            public LayoutInfoBuilder blockAligned(boolean blockAligned) {
                this.blockAligned = blockAligned;
                return this;
            }

            public LayoutInfoBuilder minSize(int minSize) {
                this.minSize = minSize;
                return this;
            }

            public LayoutInfo build() {
                return new LayoutInfo(this.constantSize, this.blockAligned, this.minSize);
            }

            public String toString() {
                return "ComponentTemplate.LayoutInfo.LayoutInfoBuilder(constantSize=" + this.constantSize + ", blockAligned=" + this.blockAligned + ", minSize=" + this.minSize + ")";
            }
        }
    }
}

