/*
 * Decompiled with CFR 0.152.
 */
package de.codecrafter47.taboverlay.config.template.component;

import de.codecrafter47.taboverlay.config.template.component.ComponentTemplate;
import de.codecrafter47.taboverlay.config.view.components.AnimatedComponentView;
import de.codecrafter47.taboverlay.config.view.components.ComponentView;
import java.util.ArrayList;
import java.util.List;

public final class AnimatedComponentTemplate
implements ComponentTemplate {
    private final List<ComponentTemplate> components;
    private final float interval;
    private final boolean randomize;

    @Override
    public ComponentTemplate.LayoutInfo getLayoutInfo() {
        return ComponentTemplate.LayoutInfo.builder().constantSize(true).minSize(this.components.get(0).getLayoutInfo().getMinSize()).blockAligned(this.components.get(0).getLayoutInfo().isBlockAligned()).build();
    }

    @Override
    public ComponentView instantiate() {
        ArrayList<ComponentView> componentViews = new ArrayList<ComponentView>(this.components.size());
        for (ComponentTemplate component : this.components) {
            componentViews.add(component.instantiate());
        }
        return new AnimatedComponentView(componentViews, this.interval, this.components.get(0).getLayoutInfo().getMinSize(), this.randomize);
    }

    AnimatedComponentTemplate(List<ComponentTemplate> components, float interval, boolean randomize) {
        this.components = components;
        this.interval = interval;
        this.randomize = randomize;
    }

    public static AnimatedComponentTemplateBuilder builder() {
        return new AnimatedComponentTemplateBuilder();
    }

    public List<ComponentTemplate> getComponents() {
        return this.components;
    }

    public float getInterval() {
        return this.interval;
    }

    public boolean isRandomize() {
        return this.randomize;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AnimatedComponentTemplate)) {
            return false;
        }
        AnimatedComponentTemplate other = (AnimatedComponentTemplate)o;
        if (Float.compare(this.getInterval(), other.getInterval()) != 0) {
            return false;
        }
        if (this.isRandomize() != other.isRandomize()) {
            return false;
        }
        List<ComponentTemplate> this$components = this.getComponents();
        List<ComponentTemplate> other$components = other.getComponents();
        return !(this$components == null ? other$components != null : !((Object)this$components).equals(other$components));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Float.floatToIntBits(this.getInterval());
        result = result * 59 + (this.isRandomize() ? 79 : 97);
        List<ComponentTemplate> $components = this.getComponents();
        result = result * 59 + ($components == null ? 43 : ((Object)$components).hashCode());
        return result;
    }

    public String toString() {
        return "AnimatedComponentTemplate(components=" + this.getComponents() + ", interval=" + this.getInterval() + ", randomize=" + this.isRandomize() + ")";
    }

    public static class AnimatedComponentTemplateBuilder {
        private List<ComponentTemplate> components;
        private float interval;
        private boolean randomize;

        AnimatedComponentTemplateBuilder() {
        }

        public AnimatedComponentTemplateBuilder components(List<ComponentTemplate> components) {
            this.components = components;
            return this;
        }

        public AnimatedComponentTemplateBuilder interval(float interval) {
            this.interval = interval;
            return this;
        }

        public AnimatedComponentTemplateBuilder randomize(boolean randomize) {
            this.randomize = randomize;
            return this;
        }

        public AnimatedComponentTemplate build() {
            return new AnimatedComponentTemplate(this.components, this.interval, this.randomize);
        }

        public String toString() {
            return "AnimatedComponentTemplate.AnimatedComponentTemplateBuilder(components=" + this.components + ", interval=" + this.interval + ", randomize=" + this.randomize + ")";
        }
    }
}

