/*
 * Decompiled with CFR 0.152.
 */
package de.codecrafter47.taboverlay.config.template;

import de.codecrafter47.data.api.DataKey;
import de.codecrafter47.taboverlay.Icon;
import de.codecrafter47.taboverlay.config.ErrorHandler;
import de.codecrafter47.taboverlay.config.SortingRulePreprocessor;
import de.codecrafter47.taboverlay.config.context.Context;
import de.codecrafter47.taboverlay.config.dsl.PlayerSetConfiguration;
import de.codecrafter47.taboverlay.config.dsl.components.BasicComponentConfiguration;
import de.codecrafter47.taboverlay.config.dsl.customplaceholder.CustomPlaceholderConfiguration;
import de.codecrafter47.taboverlay.config.expression.ExpressionEngine;
import de.codecrafter47.taboverlay.config.icon.IconManager;
import de.codecrafter47.taboverlay.config.misc.Unchecked;
import de.codecrafter47.taboverlay.config.placeholder.AbstractPlaceholderResolver;
import de.codecrafter47.taboverlay.config.placeholder.PlaceholderResolver;
import de.codecrafter47.taboverlay.config.placeholder.PlaceholderResolverChain;
import de.codecrafter47.taboverlay.config.player.Player;
import de.codecrafter47.taboverlay.config.template.PlayerSetTemplate;
import de.codecrafter47.taboverlay.config.template.component.BasicComponentTemplate;
import de.codecrafter47.taboverlay.config.template.component.ComponentTemplate;
import de.codecrafter47.taboverlay.config.template.component.ListComponentTemplate;
import de.codecrafter47.taboverlay.config.template.icon.IconTemplate;
import de.codecrafter47.taboverlay.config.template.ping.PingTemplate;
import de.codecrafter47.taboverlay.config.template.text.TextTemplate;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import javax.annotation.Nonnull;
import lombok.NonNull;

public class TemplateCreationContext
implements Cloneable {
    private final ExpressionEngine expressionEngine;
    private final IconManager iconManager;
    private final DataKey<Icon> playerIconDataKey;
    private final DataKey<Integer> playerPingDataKey;
    private final ErrorHandler errorHandler;
    private final SortingRulePreprocessor sortingRulePreprocessor;
    private Map<String, CustomPlaceholderConfiguration> customPlaceholders;
    private Map<String, PlayerSetTemplate> playerSets;
    private TextTemplate defaultText;
    private PingTemplate defaultPing;
    private IconTemplate defaultIcon;
    private PlaceholderResolverChain placeholderResolverChain;
    private AbstractPlaceholderResolver<Player> playerPlaceholderResolver;
    private PlayerSetConfiguration.Visibility defaultHiddenPlayerVisibility = PlayerSetConfiguration.Visibility.VISIBLE_TO_ADMINS;
    private BasicComponentConfiguration.LongTextBehaviour defaultLongTextBehaviour = null;
    private boolean viewerAvailable = false;
    private boolean playerAvailable = false;
    private int columns = -1;
    private HashSet<String> visitedCustomPlaceholders = new HashSet();

    public OptionalInt getColumns() {
        return this.columns != -1 ? OptionalInt.of(this.columns) : OptionalInt.empty();
    }

    public Optional<BasicComponentConfiguration.LongTextBehaviour> getDefaultLongTextBehaviour() {
        return Optional.ofNullable(this.defaultLongTextBehaviour);
    }

    public ComponentTemplate emptySlot() {
        return BasicComponentTemplate.builder().icon(this.defaultIcon).leftText(this.defaultText).ping(this.defaultPing).build();
    }

    public ComponentTemplate emptyComponent() {
        return ListComponentTemplate.builder().components(Collections.emptyList()).columns(this.getColumns().orElse(1)).defaultIcon(this.getDefaultIcon()).defaultText(this.getDefaultText()).defaultPing(this.getDefaultPing()).build();
    }

    public void addPlaceholderResolver(@Nonnull @NonNull PlaceholderResolver<Context> resolver) {
        if (resolver == null) {
            throw new NullPointerException("resolver is marked non-null but is null");
        }
        this.placeholderResolverChain = this.placeholderResolverChain.clone();
        this.placeholderResolverChain.addResolver(resolver);
    }

    public boolean hasVisitedCustomPlaceholder(@Nonnull @NonNull String id) {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        return this.visitedCustomPlaceholders.contains(id);
    }

    public void visitCustomPlaceholder(@Nonnull @NonNull String id) {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        this.visitedCustomPlaceholders = (HashSet)Unchecked.cast(this.visitedCustomPlaceholders.clone());
        this.visitedCustomPlaceholders.add(id);
    }

    public TemplateCreationContext clone() {
        TemplateCreationContext clone;
        try {
            clone = (TemplateCreationContext)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
        return clone;
    }

    public TemplateCreationContext(ExpressionEngine expressionEngine, IconManager iconManager, DataKey<Icon> playerIconDataKey, DataKey<Integer> playerPingDataKey, ErrorHandler errorHandler, SortingRulePreprocessor sortingRulePreprocessor) {
        this.expressionEngine = expressionEngine;
        this.iconManager = iconManager;
        this.playerIconDataKey = playerIconDataKey;
        this.playerPingDataKey = playerPingDataKey;
        this.errorHandler = errorHandler;
        this.sortingRulePreprocessor = sortingRulePreprocessor;
    }

    public ExpressionEngine getExpressionEngine() {
        return this.expressionEngine;
    }

    public IconManager getIconManager() {
        return this.iconManager;
    }

    public DataKey<Icon> getPlayerIconDataKey() {
        return this.playerIconDataKey;
    }

    public DataKey<Integer> getPlayerPingDataKey() {
        return this.playerPingDataKey;
    }

    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    public SortingRulePreprocessor getSortingRulePreprocessor() {
        return this.sortingRulePreprocessor;
    }

    public Map<String, CustomPlaceholderConfiguration> getCustomPlaceholders() {
        return this.customPlaceholders;
    }

    public Map<String, PlayerSetTemplate> getPlayerSets() {
        return this.playerSets;
    }

    public TextTemplate getDefaultText() {
        return this.defaultText;
    }

    public PingTemplate getDefaultPing() {
        return this.defaultPing;
    }

    public IconTemplate getDefaultIcon() {
        return this.defaultIcon;
    }

    public PlaceholderResolverChain getPlaceholderResolverChain() {
        return this.placeholderResolverChain;
    }

    public AbstractPlaceholderResolver<Player> getPlayerPlaceholderResolver() {
        return this.playerPlaceholderResolver;
    }

    public PlayerSetConfiguration.Visibility getDefaultHiddenPlayerVisibility() {
        return this.defaultHiddenPlayerVisibility;
    }

    public boolean isViewerAvailable() {
        return this.viewerAvailable;
    }

    public boolean isPlayerAvailable() {
        return this.playerAvailable;
    }

    public HashSet<String> getVisitedCustomPlaceholders() {
        return this.visitedCustomPlaceholders;
    }

    public void setCustomPlaceholders(Map<String, CustomPlaceholderConfiguration> customPlaceholders) {
        this.customPlaceholders = customPlaceholders;
    }

    public void setPlayerSets(Map<String, PlayerSetTemplate> playerSets) {
        this.playerSets = playerSets;
    }

    public void setDefaultText(TextTemplate defaultText) {
        this.defaultText = defaultText;
    }

    public void setDefaultPing(PingTemplate defaultPing) {
        this.defaultPing = defaultPing;
    }

    public void setDefaultIcon(IconTemplate defaultIcon) {
        this.defaultIcon = defaultIcon;
    }

    public void setPlaceholderResolverChain(PlaceholderResolverChain placeholderResolverChain) {
        this.placeholderResolverChain = placeholderResolverChain;
    }

    public void setPlayerPlaceholderResolver(AbstractPlaceholderResolver<Player> playerPlaceholderResolver) {
        this.playerPlaceholderResolver = playerPlaceholderResolver;
    }

    public void setDefaultHiddenPlayerVisibility(PlayerSetConfiguration.Visibility defaultHiddenPlayerVisibility) {
        this.defaultHiddenPlayerVisibility = defaultHiddenPlayerVisibility;
    }

    public void setDefaultLongTextBehaviour(BasicComponentConfiguration.LongTextBehaviour defaultLongTextBehaviour) {
        this.defaultLongTextBehaviour = defaultLongTextBehaviour;
    }

    public void setViewerAvailable(boolean viewerAvailable) {
        this.viewerAvailable = viewerAvailable;
    }

    public void setPlayerAvailable(boolean playerAvailable) {
        this.playerAvailable = playerAvailable;
    }

    public void setColumns(int columns) {
        this.columns = columns;
    }

    public void setVisitedCustomPlaceholders(HashSet<String> visitedCustomPlaceholders) {
        this.visitedCustomPlaceholders = visitedCustomPlaceholders;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TemplateCreationContext)) {
            return false;
        }
        TemplateCreationContext other = (TemplateCreationContext)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isViewerAvailable() != other.isViewerAvailable()) {
            return false;
        }
        if (this.isPlayerAvailable() != other.isPlayerAvailable()) {
            return false;
        }
        OptionalInt this$columns = this.getColumns();
        OptionalInt other$columns = other.getColumns();
        if (this$columns == null ? other$columns != null : !((Object)this$columns).equals(other$columns)) {
            return false;
        }
        ExpressionEngine this$expressionEngine = this.getExpressionEngine();
        ExpressionEngine other$expressionEngine = other.getExpressionEngine();
        if (this$expressionEngine == null ? other$expressionEngine != null : !this$expressionEngine.equals(other$expressionEngine)) {
            return false;
        }
        IconManager this$iconManager = this.getIconManager();
        IconManager other$iconManager = other.getIconManager();
        if (this$iconManager == null ? other$iconManager != null : !this$iconManager.equals(other$iconManager)) {
            return false;
        }
        DataKey<Icon> this$playerIconDataKey = this.getPlayerIconDataKey();
        DataKey<Icon> other$playerIconDataKey = other.getPlayerIconDataKey();
        if (this$playerIconDataKey == null ? other$playerIconDataKey != null : !((Object)this$playerIconDataKey).equals(other$playerIconDataKey)) {
            return false;
        }
        DataKey<Integer> this$playerPingDataKey = this.getPlayerPingDataKey();
        DataKey<Integer> other$playerPingDataKey = other.getPlayerPingDataKey();
        if (this$playerPingDataKey == null ? other$playerPingDataKey != null : !((Object)this$playerPingDataKey).equals(other$playerPingDataKey)) {
            return false;
        }
        ErrorHandler this$errorHandler = this.getErrorHandler();
        ErrorHandler other$errorHandler = other.getErrorHandler();
        if (this$errorHandler == null ? other$errorHandler != null : !this$errorHandler.equals(other$errorHandler)) {
            return false;
        }
        SortingRulePreprocessor this$sortingRulePreprocessor = this.getSortingRulePreprocessor();
        SortingRulePreprocessor other$sortingRulePreprocessor = other.getSortingRulePreprocessor();
        if (this$sortingRulePreprocessor == null ? other$sortingRulePreprocessor != null : !this$sortingRulePreprocessor.equals(other$sortingRulePreprocessor)) {
            return false;
        }
        Map<String, CustomPlaceholderConfiguration> this$customPlaceholders = this.getCustomPlaceholders();
        Map<String, CustomPlaceholderConfiguration> other$customPlaceholders = other.getCustomPlaceholders();
        if (this$customPlaceholders == null ? other$customPlaceholders != null : !((Object)this$customPlaceholders).equals(other$customPlaceholders)) {
            return false;
        }
        Map<String, PlayerSetTemplate> this$playerSets = this.getPlayerSets();
        Map<String, PlayerSetTemplate> other$playerSets = other.getPlayerSets();
        if (this$playerSets == null ? other$playerSets != null : !((Object)this$playerSets).equals(other$playerSets)) {
            return false;
        }
        TextTemplate this$defaultText = this.getDefaultText();
        TextTemplate other$defaultText = other.getDefaultText();
        if (this$defaultText == null ? other$defaultText != null : !this$defaultText.equals(other$defaultText)) {
            return false;
        }
        PingTemplate this$defaultPing = this.getDefaultPing();
        PingTemplate other$defaultPing = other.getDefaultPing();
        if (this$defaultPing == null ? other$defaultPing != null : !this$defaultPing.equals(other$defaultPing)) {
            return false;
        }
        IconTemplate this$defaultIcon = this.getDefaultIcon();
        IconTemplate other$defaultIcon = other.getDefaultIcon();
        if (this$defaultIcon == null ? other$defaultIcon != null : !this$defaultIcon.equals(other$defaultIcon)) {
            return false;
        }
        PlaceholderResolverChain this$placeholderResolverChain = this.getPlaceholderResolverChain();
        PlaceholderResolverChain other$placeholderResolverChain = other.getPlaceholderResolverChain();
        if (this$placeholderResolverChain == null ? other$placeholderResolverChain != null : !this$placeholderResolverChain.equals(other$placeholderResolverChain)) {
            return false;
        }
        AbstractPlaceholderResolver<Player> this$playerPlaceholderResolver = this.getPlayerPlaceholderResolver();
        AbstractPlaceholderResolver<Player> other$playerPlaceholderResolver = other.getPlayerPlaceholderResolver();
        if (this$playerPlaceholderResolver == null ? other$playerPlaceholderResolver != null : !this$playerPlaceholderResolver.equals(other$playerPlaceholderResolver)) {
            return false;
        }
        PlayerSetConfiguration.Visibility this$defaultHiddenPlayerVisibility = this.getDefaultHiddenPlayerVisibility();
        PlayerSetConfiguration.Visibility other$defaultHiddenPlayerVisibility = other.getDefaultHiddenPlayerVisibility();
        if (this$defaultHiddenPlayerVisibility == null ? other$defaultHiddenPlayerVisibility != null : !((Object)((Object)this$defaultHiddenPlayerVisibility)).equals((Object)other$defaultHiddenPlayerVisibility)) {
            return false;
        }
        Optional<BasicComponentConfiguration.LongTextBehaviour> this$defaultLongTextBehaviour = this.getDefaultLongTextBehaviour();
        Optional<BasicComponentConfiguration.LongTextBehaviour> other$defaultLongTextBehaviour = other.getDefaultLongTextBehaviour();
        if (this$defaultLongTextBehaviour == null ? other$defaultLongTextBehaviour != null : !((Object)this$defaultLongTextBehaviour).equals(other$defaultLongTextBehaviour)) {
            return false;
        }
        HashSet<String> this$visitedCustomPlaceholders = this.getVisitedCustomPlaceholders();
        HashSet<String> other$visitedCustomPlaceholders = other.getVisitedCustomPlaceholders();
        return !(this$visitedCustomPlaceholders == null ? other$visitedCustomPlaceholders != null : !((Object)this$visitedCustomPlaceholders).equals(other$visitedCustomPlaceholders));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TemplateCreationContext;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isViewerAvailable() ? 79 : 97);
        result = result * 59 + (this.isPlayerAvailable() ? 79 : 97);
        OptionalInt $columns = this.getColumns();
        result = result * 59 + ($columns == null ? 43 : ((Object)$columns).hashCode());
        ExpressionEngine $expressionEngine = this.getExpressionEngine();
        result = result * 59 + ($expressionEngine == null ? 43 : $expressionEngine.hashCode());
        IconManager $iconManager = this.getIconManager();
        result = result * 59 + ($iconManager == null ? 43 : $iconManager.hashCode());
        DataKey<Icon> $playerIconDataKey = this.getPlayerIconDataKey();
        result = result * 59 + ($playerIconDataKey == null ? 43 : ((Object)$playerIconDataKey).hashCode());
        DataKey<Integer> $playerPingDataKey = this.getPlayerPingDataKey();
        result = result * 59 + ($playerPingDataKey == null ? 43 : ((Object)$playerPingDataKey).hashCode());
        ErrorHandler $errorHandler = this.getErrorHandler();
        result = result * 59 + ($errorHandler == null ? 43 : $errorHandler.hashCode());
        SortingRulePreprocessor $sortingRulePreprocessor = this.getSortingRulePreprocessor();
        result = result * 59 + ($sortingRulePreprocessor == null ? 43 : $sortingRulePreprocessor.hashCode());
        Map<String, CustomPlaceholderConfiguration> $customPlaceholders = this.getCustomPlaceholders();
        result = result * 59 + ($customPlaceholders == null ? 43 : ((Object)$customPlaceholders).hashCode());
        Map<String, PlayerSetTemplate> $playerSets = this.getPlayerSets();
        result = result * 59 + ($playerSets == null ? 43 : ((Object)$playerSets).hashCode());
        TextTemplate $defaultText = this.getDefaultText();
        result = result * 59 + ($defaultText == null ? 43 : $defaultText.hashCode());
        PingTemplate $defaultPing = this.getDefaultPing();
        result = result * 59 + ($defaultPing == null ? 43 : $defaultPing.hashCode());
        IconTemplate $defaultIcon = this.getDefaultIcon();
        result = result * 59 + ($defaultIcon == null ? 43 : $defaultIcon.hashCode());
        PlaceholderResolverChain $placeholderResolverChain = this.getPlaceholderResolverChain();
        result = result * 59 + ($placeholderResolverChain == null ? 43 : $placeholderResolverChain.hashCode());
        AbstractPlaceholderResolver<Player> $playerPlaceholderResolver = this.getPlayerPlaceholderResolver();
        result = result * 59 + ($playerPlaceholderResolver == null ? 43 : $playerPlaceholderResolver.hashCode());
        PlayerSetConfiguration.Visibility $defaultHiddenPlayerVisibility = this.getDefaultHiddenPlayerVisibility();
        result = result * 59 + ($defaultHiddenPlayerVisibility == null ? 43 : ((Object)((Object)$defaultHiddenPlayerVisibility)).hashCode());
        Optional<BasicComponentConfiguration.LongTextBehaviour> $defaultLongTextBehaviour = this.getDefaultLongTextBehaviour();
        result = result * 59 + ($defaultLongTextBehaviour == null ? 43 : ((Object)$defaultLongTextBehaviour).hashCode());
        HashSet<String> $visitedCustomPlaceholders = this.getVisitedCustomPlaceholders();
        result = result * 59 + ($visitedCustomPlaceholders == null ? 43 : ((Object)$visitedCustomPlaceholders).hashCode());
        return result;
    }

    public String toString() {
        return "TemplateCreationContext(expressionEngine=" + this.getExpressionEngine() + ", iconManager=" + this.getIconManager() + ", playerIconDataKey=" + this.getPlayerIconDataKey() + ", playerPingDataKey=" + this.getPlayerPingDataKey() + ", errorHandler=" + this.getErrorHandler() + ", sortingRulePreprocessor=" + this.getSortingRulePreprocessor() + ", customPlaceholders=" + this.getCustomPlaceholders() + ", playerSets=" + this.getPlayerSets() + ", defaultText=" + this.getDefaultText() + ", defaultPing=" + this.getDefaultPing() + ", defaultIcon=" + this.getDefaultIcon() + ", placeholderResolverChain=" + this.getPlaceholderResolverChain() + ", playerPlaceholderResolver=" + this.getPlayerPlaceholderResolver() + ", defaultHiddenPlayerVisibility=" + (Object)((Object)this.getDefaultHiddenPlayerVisibility()) + ", defaultLongTextBehaviour=" + this.getDefaultLongTextBehaviour() + ", viewerAvailable=" + this.isViewerAvailable() + ", playerAvailable=" + this.isPlayerAvailable() + ", columns=" + this.getColumns() + ", visitedCustomPlaceholders=" + this.getVisitedCustomPlaceholders() + ")";
    }
}

