/*
 * Decompiled with CFR 0.152.
 */
package de.codecrafter47.taboverlay.config.template;

import de.codecrafter47.taboverlay.config.dsl.PlayerSetConfiguration;
import de.codecrafter47.taboverlay.config.expression.template.ExpressionTemplate;
import javax.annotation.Nonnull;
import lombok.NonNull;

public final class PlayerSetTemplate {
    @Nonnull
    @NonNull
    private final PlayerSetConfiguration.Visibility hiddenPlayersVisibility;
    @Nonnull
    @NonNull
    private final ExpressionTemplate predicate;
    private final boolean requiresViewerContext;

    public PlayerSetTemplate(@Nonnull PlayerSetConfiguration.Visibility hiddenPlayersVisibility, @Nonnull ExpressionTemplate predicate) {
        this.hiddenPlayersVisibility = hiddenPlayersVisibility;
        this.predicate = predicate;
        this.requiresViewerContext = predicate.requiresViewerContext() || hiddenPlayersVisibility == PlayerSetConfiguration.Visibility.VISIBLE_TO_ADMINS;
    }

    public static PlayerSetTemplateBuilder builder() {
        return new PlayerSetTemplateBuilder();
    }

    @Nonnull
    @NonNull
    public PlayerSetConfiguration.Visibility getHiddenPlayersVisibility() {
        return this.hiddenPlayersVisibility;
    }

    @Nonnull
    @NonNull
    public ExpressionTemplate getPredicate() {
        return this.predicate;
    }

    public boolean isRequiresViewerContext() {
        return this.requiresViewerContext;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PlayerSetTemplate)) {
            return false;
        }
        PlayerSetTemplate other = (PlayerSetTemplate)o;
        if (this.isRequiresViewerContext() != other.isRequiresViewerContext()) {
            return false;
        }
        PlayerSetConfiguration.Visibility this$hiddenPlayersVisibility = this.getHiddenPlayersVisibility();
        PlayerSetConfiguration.Visibility other$hiddenPlayersVisibility = other.getHiddenPlayersVisibility();
        if (this$hiddenPlayersVisibility == null ? other$hiddenPlayersVisibility != null : !((Object)((Object)this$hiddenPlayersVisibility)).equals((Object)other$hiddenPlayersVisibility)) {
            return false;
        }
        ExpressionTemplate this$predicate = this.getPredicate();
        ExpressionTemplate other$predicate = other.getPredicate();
        return !(this$predicate == null ? other$predicate != null : !this$predicate.equals(other$predicate));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isRequiresViewerContext() ? 79 : 97);
        PlayerSetConfiguration.Visibility $hiddenPlayersVisibility = this.getHiddenPlayersVisibility();
        result = result * 59 + ($hiddenPlayersVisibility == null ? 43 : ((Object)((Object)$hiddenPlayersVisibility)).hashCode());
        ExpressionTemplate $predicate = this.getPredicate();
        result = result * 59 + ($predicate == null ? 43 : $predicate.hashCode());
        return result;
    }

    public String toString() {
        return "PlayerSetTemplate(hiddenPlayersVisibility=" + (Object)((Object)this.getHiddenPlayersVisibility()) + ", predicate=" + this.getPredicate() + ", requiresViewerContext=" + this.isRequiresViewerContext() + ")";
    }

    public static class PlayerSetTemplateBuilder {
        private PlayerSetConfiguration.Visibility hiddenPlayersVisibility;
        private ExpressionTemplate predicate;

        PlayerSetTemplateBuilder() {
        }

        public PlayerSetTemplateBuilder hiddenPlayersVisibility(@Nonnull PlayerSetConfiguration.Visibility hiddenPlayersVisibility) {
            this.hiddenPlayersVisibility = hiddenPlayersVisibility;
            return this;
        }

        public PlayerSetTemplateBuilder predicate(@Nonnull ExpressionTemplate predicate) {
            this.predicate = predicate;
            return this;
        }

        public PlayerSetTemplate build() {
            return new PlayerSetTemplate(this.hiddenPlayersVisibility, this.predicate);
        }

        public String toString() {
            return "PlayerSetTemplate.PlayerSetTemplateBuilder(hiddenPlayersVisibility=" + (Object)((Object)this.hiddenPlayersVisibility) + ", predicate=" + this.predicate + ")";
        }
    }
}

