/*
 * Decompiled with CFR 0.152.
 */
package de.codecrafter47.taboverlay.config.template;

import de.codecrafter47.data.api.DataHolder;
import de.codecrafter47.taboverlay.config.placeholder.DataHolderPlaceholderDataProviderSupplier;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.NonNull;

public final class PlayerOrderTemplate {
    @Nonnull
    @NonNull
    private final List<Entry> entries;

    public boolean requiresViewerContext() {
        for (Entry entry : this.entries) {
            if (!entry.requiresViewerContext()) continue;
            return true;
        }
        return false;
    }

    public PlayerOrderTemplate(@Nonnull @NonNull List<Entry> entries) {
        if (entries == null) {
            throw new NullPointerException("entries is marked non-null but is null");
        }
        this.entries = entries;
    }

    @Nonnull
    @NonNull
    public List<Entry> getEntries() {
        return this.entries;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PlayerOrderTemplate)) {
            return false;
        }
        PlayerOrderTemplate other = (PlayerOrderTemplate)o;
        List<Entry> this$entries = this.getEntries();
        List<Entry> other$entries = other.getEntries();
        return !(this$entries == null ? other$entries != null : !((Object)this$entries).equals(other$entries));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<Entry> $entries = this.getEntries();
        result = result * 59 + ($entries == null ? 43 : ((Object)$entries).hashCode());
        return result;
    }

    public String toString() {
        return "PlayerOrderTemplate(entries=" + this.getEntries() + ")";
    }

    public static final class Entry {
        @Nonnull
        @NonNull
        private final DataHolderPlaceholderDataProviderSupplier<DataHolder, ?, ?> placeholder;
        @Nonnull
        @NonNull
        private final Direction direction;
        @Nonnull
        @NonNull
        private final Type type;
        @Nullable
        private final List<String> customOrder;

        boolean requiresViewerContext() {
            return this.direction == Direction.VIEWER_FIRST;
        }

        public Entry(@Nonnull @NonNull DataHolderPlaceholderDataProviderSupplier<DataHolder, ?, ?> placeholder, @Nonnull @NonNull Direction direction, @Nonnull @NonNull Type type, @Nullable List<String> customOrder) {
            if (placeholder == null) {
                throw new NullPointerException("placeholder is marked non-null but is null");
            }
            if (direction == null) {
                throw new NullPointerException("direction is marked non-null but is null");
            }
            if (type == null) {
                throw new NullPointerException("type is marked non-null but is null");
            }
            this.placeholder = placeholder;
            this.direction = direction;
            this.type = type;
            this.customOrder = customOrder;
        }

        @Nonnull
        @NonNull
        public DataHolderPlaceholderDataProviderSupplier<DataHolder, ?, ?> getPlaceholder() {
            return this.placeholder;
        }

        @Nonnull
        @NonNull
        public Direction getDirection() {
            return this.direction;
        }

        @Nonnull
        @NonNull
        public Type getType() {
            return this.type;
        }

        @Nullable
        public List<String> getCustomOrder() {
            return this.customOrder;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Entry)) {
                return false;
            }
            Entry other = (Entry)o;
            DataHolderPlaceholderDataProviderSupplier<DataHolder, ?, ?> this$placeholder = this.getPlaceholder();
            DataHolderPlaceholderDataProviderSupplier<DataHolder, ?, ?> other$placeholder = other.getPlaceholder();
            if (this$placeholder == null ? other$placeholder != null : !this$placeholder.equals(other$placeholder)) {
                return false;
            }
            Direction this$direction = this.getDirection();
            Direction other$direction = other.getDirection();
            if (this$direction == null ? other$direction != null : !((Object)((Object)this$direction)).equals((Object)other$direction)) {
                return false;
            }
            Type this$type = this.getType();
            Type other$type = other.getType();
            if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
                return false;
            }
            List<String> this$customOrder = this.getCustomOrder();
            List<String> other$customOrder = other.getCustomOrder();
            return !(this$customOrder == null ? other$customOrder != null : !((Object)this$customOrder).equals(other$customOrder));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            DataHolderPlaceholderDataProviderSupplier<DataHolder, ?, ?> $placeholder = this.getPlaceholder();
            result = result * 59 + ($placeholder == null ? 43 : $placeholder.hashCode());
            Direction $direction = this.getDirection();
            result = result * 59 + ($direction == null ? 43 : ((Object)((Object)$direction)).hashCode());
            Type $type = this.getType();
            result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
            List<String> $customOrder = this.getCustomOrder();
            result = result * 59 + ($customOrder == null ? 43 : ((Object)$customOrder).hashCode());
            return result;
        }

        public String toString() {
            return "PlayerOrderTemplate.Entry(placeholder=" + this.getPlaceholder() + ", direction=" + (Object)((Object)this.getDirection()) + ", type=" + (Object)((Object)this.getType()) + ", customOrder=" + this.getCustomOrder() + ")";
        }
    }

    public static enum Type {
        TEXT,
        NUMBER;

    }

    public static enum Direction {
        ASCENDING,
        DESCENDING,
        VIEWER_FIRST,
        CUSTOM;

    }
}

