/*
 * Decompiled with CFR 0.152.
 */
package de.codecrafter47.taboverlay.config.template;

import de.codecrafter47.taboverlay.TabView;
import de.codecrafter47.taboverlay.config.expression.template.ExpressionTemplate;
import de.codecrafter47.taboverlay.config.template.PlayerSetTemplate;
import de.codecrafter47.taboverlay.config.template.text.TextTemplate;
import de.codecrafter47.taboverlay.config.view.AbstractActiveElement;
import de.codecrafter47.taboverlay.handler.TabOverlayHandler;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

public abstract class AbstractTabOverlayTemplate {
    private Path path;
    private ExpressionTemplate viewerPredicate;
    private int priority;
    @Nullable
    private List<TextTemplate> header;
    private float headerAnimationUpdateInterval = Float.NaN;
    @Nullable
    private List<TextTemplate> footer;
    private float footerAnimationUpdateInterval = Float.NaN;
    private Map<String, PlayerSetTemplate> playerSets;

    public boolean showHeaderAndFooter() {
        return this.getHeader() != null || this.getFooter() != null;
    }

    public abstract AbstractActiveElement<?> createContentView(TabView var1, TabOverlayHandler var2);

    public Path getPath() {
        return this.path;
    }

    public ExpressionTemplate getViewerPredicate() {
        return this.viewerPredicate;
    }

    public int getPriority() {
        return this.priority;
    }

    @Nullable
    public List<TextTemplate> getHeader() {
        return this.header;
    }

    public float getHeaderAnimationUpdateInterval() {
        return this.headerAnimationUpdateInterval;
    }

    @Nullable
    public List<TextTemplate> getFooter() {
        return this.footer;
    }

    public float getFooterAnimationUpdateInterval() {
        return this.footerAnimationUpdateInterval;
    }

    public Map<String, PlayerSetTemplate> getPlayerSets() {
        return this.playerSets;
    }

    public void setPath(Path path) {
        this.path = path;
    }

    public void setViewerPredicate(ExpressionTemplate viewerPredicate) {
        this.viewerPredicate = viewerPredicate;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public void setHeader(@Nullable List<TextTemplate> header) {
        this.header = header;
    }

    public void setHeaderAnimationUpdateInterval(float headerAnimationUpdateInterval) {
        this.headerAnimationUpdateInterval = headerAnimationUpdateInterval;
    }

    public void setFooter(@Nullable List<TextTemplate> footer) {
        this.footer = footer;
    }

    public void setFooterAnimationUpdateInterval(float footerAnimationUpdateInterval) {
        this.footerAnimationUpdateInterval = footerAnimationUpdateInterval;
    }

    public void setPlayerSets(Map<String, PlayerSetTemplate> playerSets) {
        this.playerSets = playerSets;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AbstractTabOverlayTemplate)) {
            return false;
        }
        AbstractTabOverlayTemplate other = (AbstractTabOverlayTemplate)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getPriority() != other.getPriority()) {
            return false;
        }
        if (Float.compare(this.getHeaderAnimationUpdateInterval(), other.getHeaderAnimationUpdateInterval()) != 0) {
            return false;
        }
        if (Float.compare(this.getFooterAnimationUpdateInterval(), other.getFooterAnimationUpdateInterval()) != 0) {
            return false;
        }
        Path this$path = this.getPath();
        Path other$path = other.getPath();
        if (this$path == null ? other$path != null : !((Object)this$path).equals(other$path)) {
            return false;
        }
        ExpressionTemplate this$viewerPredicate = this.getViewerPredicate();
        ExpressionTemplate other$viewerPredicate = other.getViewerPredicate();
        if (this$viewerPredicate == null ? other$viewerPredicate != null : !this$viewerPredicate.equals(other$viewerPredicate)) {
            return false;
        }
        List<TextTemplate> this$header = this.getHeader();
        List<TextTemplate> other$header = other.getHeader();
        if (this$header == null ? other$header != null : !((Object)this$header).equals(other$header)) {
            return false;
        }
        List<TextTemplate> this$footer = this.getFooter();
        List<TextTemplate> other$footer = other.getFooter();
        if (this$footer == null ? other$footer != null : !((Object)this$footer).equals(other$footer)) {
            return false;
        }
        Map<String, PlayerSetTemplate> this$playerSets = this.getPlayerSets();
        Map<String, PlayerSetTemplate> other$playerSets = other.getPlayerSets();
        return !(this$playerSets == null ? other$playerSets != null : !((Object)this$playerSets).equals(other$playerSets));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AbstractTabOverlayTemplate;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getPriority();
        result = result * 59 + Float.floatToIntBits(this.getHeaderAnimationUpdateInterval());
        result = result * 59 + Float.floatToIntBits(this.getFooterAnimationUpdateInterval());
        Path $path = this.getPath();
        result = result * 59 + ($path == null ? 43 : ((Object)$path).hashCode());
        ExpressionTemplate $viewerPredicate = this.getViewerPredicate();
        result = result * 59 + ($viewerPredicate == null ? 43 : $viewerPredicate.hashCode());
        List<TextTemplate> $header = this.getHeader();
        result = result * 59 + ($header == null ? 43 : ((Object)$header).hashCode());
        List<TextTemplate> $footer = this.getFooter();
        result = result * 59 + ($footer == null ? 43 : ((Object)$footer).hashCode());
        Map<String, PlayerSetTemplate> $playerSets = this.getPlayerSets();
        result = result * 59 + ($playerSets == null ? 43 : ((Object)$playerSets).hashCode());
        return result;
    }

    public String toString() {
        return "AbstractTabOverlayTemplate(path=" + this.getPath() + ", viewerPredicate=" + this.getViewerPredicate() + ", priority=" + this.getPriority() + ", header=" + this.getHeader() + ", headerAnimationUpdateInterval=" + this.getHeaderAnimationUpdateInterval() + ", footer=" + this.getFooter() + ", footerAnimationUpdateInterval=" + this.getFooterAnimationUpdateInterval() + ", playerSets=" + this.getPlayerSets() + ")";
    }
}

