/*
 * Decompiled with CFR 0.152.
 */
package de.codecrafter47.taboverlay.config.spectator;

import de.codecrafter47.data.api.DataKey;
import de.codecrafter47.taboverlay.AbstractTabOverlayProvider;
import de.codecrafter47.taboverlay.TabOverlayProviderSet;
import de.codecrafter47.taboverlay.TabView;
import de.codecrafter47.taboverlay.config.player.Player;
import de.codecrafter47.taboverlay.handler.ContentOperationMode;
import de.codecrafter47.taboverlay.handler.HeaderAndFooterOperationMode;
import de.codecrafter47.taboverlay.handler.TabOverlayHandle;
import java.util.concurrent.ScheduledExecutorService;

public class SpectatorPassthroughTabOverlayProvider
extends AbstractTabOverlayProvider<TabOverlayHandle, TabOverlayHandle>
implements Runnable {
    private final Player player;
    private final ScheduledExecutorService tabEventLoop;
    private final DataKey<Integer> DATA_KEY_GAMEMODE;
    private boolean shouldBeActive = false;
    private TabOverlayProviderSet tabOverlayProviderSet;

    public SpectatorPassthroughTabOverlayProvider(Player player, ScheduledExecutorService tabEventLoop, DataKey<Integer> data_key_gamemode) {
        super("spectator-passthrough", 10002, ContentOperationMode.PASS_TROUGH, HeaderAndFooterOperationMode.PASS_TROUGH);
        this.player = player;
        this.tabEventLoop = tabEventLoop;
        this.DATA_KEY_GAMEMODE = data_key_gamemode;
    }

    @Override
    protected void activate(TabView tabView, TabOverlayHandle contentHandle, TabOverlayHandle headerAndFooterHandle) {
    }

    @Override
    protected void attach(TabView tabView) {
        this.tabEventLoop.submit(() -> {
            this.tabOverlayProviderSet = tabView.getTabOverlayProviders();
            this.player.addDataChangeListener(this.DATA_KEY_GAMEMODE, this);
            Integer gamemode = this.player.get(this.DATA_KEY_GAMEMODE);
            this.shouldBeActive = gamemode != null && gamemode == 3;
        }).get();
    }

    @Override
    protected void detach(TabView tabView) {
        this.tabEventLoop.submit(() -> this.player.removeDataChangeListener(this.DATA_KEY_GAMEMODE, this)).get();
    }

    @Override
    protected void deactivate(TabView tabView) {
    }

    @Override
    protected boolean shouldActivate(TabView tabView) {
        return this.shouldBeActive;
    }

    @Override
    public void run() {
        Integer gamemode = this.player.get(this.DATA_KEY_GAMEMODE);
        this.shouldBeActive = gamemode != null && gamemode == 3;
        if (this.shouldBeActive != this.shouldBeActive) {
            this.tabOverlayProviderSet.scheduleUpdate();
        }
    }
}

