/*
 * Decompiled with CFR 0.152.
 */
package de.codecrafter47.taboverlay.config.spectator;

import de.codecrafter47.data.api.DataKey;
import de.codecrafter47.taboverlay.TabView;
import de.codecrafter47.taboverlay.config.platform.EventListener;
import de.codecrafter47.taboverlay.config.platform.Platform;
import de.codecrafter47.taboverlay.config.player.Player;
import de.codecrafter47.taboverlay.config.spectator.SpectatorPassthroughTabOverlayProvider;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;

public class SpectatorPassthroughTabOverlayManager {
    private final Platform platform;
    private final ScheduledExecutorService tabEventLoop;
    private final DataKey<Integer> dataKeyGamemode;
    private final HashMap<TabView, Player> tabViews = new HashMap();
    private boolean enabled = false;

    public SpectatorPassthroughTabOverlayManager(Platform platform, ScheduledExecutorService tabEventLoop, DataKey<Integer> dataKeyGamemode) {
        this.platform = platform;
        this.tabEventLoop = tabEventLoop;
        this.dataKeyGamemode = dataKeyGamemode;
        platform.addEventListener(new Listener());
    }

    public synchronized void enable() {
        if (!this.enabled) {
            this.enabled = true;
            for (Map.Entry<TabView, Player> entry : this.tabViews.entrySet()) {
                TabView tabView = entry.getKey();
                Player player = entry.getValue();
                SpectatorPassthroughTabOverlayProvider provider = new SpectatorPassthroughTabOverlayProvider(player, this.tabEventLoop, this.dataKeyGamemode);
                tabView.getTabOverlayProviders().addProvider(provider);
            }
        }
    }

    public synchronized void disable() {
        if (this.enabled) {
            this.enabled = false;
            for (Map.Entry<TabView, Player> entry : this.tabViews.entrySet()) {
                entry.getKey().getTabOverlayProviders().removeProviders(SpectatorPassthroughTabOverlayProvider.class);
            }
        }
    }

    private class Listener
    implements EventListener {
        private Listener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onTabViewAdded(TabView tabView, Player viewer) {
            SpectatorPassthroughTabOverlayManager spectatorPassthroughTabOverlayManager = SpectatorPassthroughTabOverlayManager.this;
            synchronized (spectatorPassthroughTabOverlayManager) {
                SpectatorPassthroughTabOverlayManager.this.tabViews.put(tabView, viewer);
                if (SpectatorPassthroughTabOverlayManager.this.enabled) {
                    SpectatorPassthroughTabOverlayProvider provider = new SpectatorPassthroughTabOverlayProvider(viewer, SpectatorPassthroughTabOverlayManager.this.tabEventLoop, SpectatorPassthroughTabOverlayManager.this.dataKeyGamemode);
                    tabView.getTabOverlayProviders().addProvider(provider);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onTabViewRemoved(TabView tabView) {
            SpectatorPassthroughTabOverlayManager spectatorPassthroughTabOverlayManager = SpectatorPassthroughTabOverlayManager.this;
            synchronized (spectatorPassthroughTabOverlayManager) {
                SpectatorPassthroughTabOverlayManager.this.tabViews.remove(tabView);
                tabView.getTabOverlayProviders().removeProviders(SpectatorPassthroughTabOverlayProvider.class);
            }
        }
    }
}

